<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfDistributionList ArrayType
 * @subpackage Arrays
 */
class ArrayOfDistributionList extends AbstractStructArrayBase
{
    /**
     * The DistributionList
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DistributionList[]
     */
    public $DistributionList;
    /**
     * Constructor method for ArrayOfDistributionList
     * @uses ArrayOfDistributionList::setDistributionList()
     * @param \StructType\DistributionList[] $distributionList
     */
    public function __construct(array $distributionList = array())
    {
        $this
            ->setDistributionList($distributionList);
    }
    /**
     * Get DistributionList value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DistributionList[]|null
     */
    public function getDistributionList()
    {
        return isset($this->DistributionList) ? $this->DistributionList : null;
    }
    /**
     * This method is responsible for validating the values passed to the setDistributionList method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDistributionList method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDistributionListForArrayConstraintsFromSetDistributionList(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfDistributionListDistributionListItem) {
            // validation for constraint: itemType
            if (!$arrayOfDistributionListDistributionListItem instanceof \StructType\DistributionList) {
                $invalidValues[] = is_object($arrayOfDistributionListDistributionListItem) ? get_class($arrayOfDistributionListDistributionListItem) : sprintf('%s(%s)', gettype($arrayOfDistributionListDistributionListItem), var_export($arrayOfDistributionListDistributionListItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The DistributionList property can only contain items of type \StructType\DistributionList, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set DistributionList value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\DistributionList[] $distributionList
     * @return \ArrayType\ArrayOfDistributionList
     */
    public function setDistributionList(array $distributionList = array())
    {
        // validation for constraint: array
        if ('' !== ($distributionListArrayErrorMessage = self::validateDistributionListForArrayConstraintsFromSetDistributionList($distributionList))) {
            throw new \InvalidArgumentException($distributionListArrayErrorMessage, __LINE__);
        }
        if (is_null($distributionList) || (is_array($distributionList) && empty($distributionList))) {
            unset($this->DistributionList);
        } else {
            $this->DistributionList = $distributionList;
        }
        return $this;
    }
    /**
     * Add item to DistributionList value
     * @throws \InvalidArgumentException
     * @param \StructType\DistributionList $item
     * @return \ArrayType\ArrayOfDistributionList
     */
    public function addToDistributionList(\StructType\DistributionList $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\DistributionList) {
            throw new \InvalidArgumentException(sprintf('The DistributionList property can only contain items of type \StructType\DistributionList, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->DistributionList[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\DistributionList|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\DistributionList|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\DistributionList|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\DistributionList|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\DistributionList|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string DistributionList
     */
    public function getAttributeName()
    {
        return 'DistributionList';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfDistributionList
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
