<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfCvInvitee ArrayType
 * @subpackage Arrays
 */
class ArrayOfCvInvitee extends AbstractStructArrayBase
{
    /**
     * The CvInvitee
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\CvInvitee[]
     */
    public $CvInvitee;
    /**
     * Constructor method for ArrayOfCvInvitee
     * @uses ArrayOfCvInvitee::setCvInvitee()
     * @param \StructType\CvInvitee[] $cvInvitee
     */
    public function __construct(array $cvInvitee = array())
    {
        $this
            ->setCvInvitee($cvInvitee);
    }
    /**
     * Get CvInvitee value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\CvInvitee[]|null
     */
    public function getCvInvitee()
    {
        return isset($this->CvInvitee) ? $this->CvInvitee : null;
    }
    /**
     * This method is responsible for validating the values passed to the setCvInvitee method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCvInvitee method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCvInviteeForArrayConstraintsFromSetCvInvitee(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfCvInviteeCvInviteeItem) {
            // validation for constraint: itemType
            if (!$arrayOfCvInviteeCvInviteeItem instanceof \StructType\CvInvitee) {
                $invalidValues[] = is_object($arrayOfCvInviteeCvInviteeItem) ? get_class($arrayOfCvInviteeCvInviteeItem) : sprintf('%s(%s)', gettype($arrayOfCvInviteeCvInviteeItem), var_export($arrayOfCvInviteeCvInviteeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The CvInvitee property can only contain items of type \StructType\CvInvitee, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set CvInvitee value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\CvInvitee[] $cvInvitee
     * @return \ArrayType\ArrayOfCvInvitee
     */
    public function setCvInvitee(array $cvInvitee = array())
    {
        // validation for constraint: array
        if ('' !== ($cvInviteeArrayErrorMessage = self::validateCvInviteeForArrayConstraintsFromSetCvInvitee($cvInvitee))) {
            throw new \InvalidArgumentException($cvInviteeArrayErrorMessage, __LINE__);
        }
        if (is_null($cvInvitee) || (is_array($cvInvitee) && empty($cvInvitee))) {
            unset($this->CvInvitee);
        } else {
            $this->CvInvitee = $cvInvitee;
        }
        return $this;
    }
    /**
     * Add item to CvInvitee value
     * @throws \InvalidArgumentException
     * @param \StructType\CvInvitee $item
     * @return \ArrayType\ArrayOfCvInvitee
     */
    public function addToCvInvitee(\StructType\CvInvitee $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CvInvitee) {
            throw new \InvalidArgumentException(sprintf('The CvInvitee property can only contain items of type \StructType\CvInvitee, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->CvInvitee[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\CvInvitee|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\CvInvitee|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\CvInvitee|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\CvInvitee|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\CvInvitee|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string CvInvitee
     */
    public function getAttributeName()
    {
        return 'CvInvitee';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfCvInvitee
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
