<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfCvAnswer ArrayType
 * @subpackage Arrays
 */
class ArrayOfCvAnswer extends AbstractStructArrayBase
{
    /**
     * The CvAnswer
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\CvAnswer[]
     */
    public $CvAnswer;
    /**
     * Constructor method for ArrayOfCvAnswer
     * @uses ArrayOfCvAnswer::setCvAnswer()
     * @param \StructType\CvAnswer[] $cvAnswer
     */
    public function __construct(array $cvAnswer = array())
    {
        $this
            ->setCvAnswer($cvAnswer);
    }
    /**
     * Get CvAnswer value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\CvAnswer[]|null
     */
    public function getCvAnswer()
    {
        return isset($this->CvAnswer) ? $this->CvAnswer : null;
    }
    /**
     * This method is responsible for validating the values passed to the setCvAnswer method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCvAnswer method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCvAnswerForArrayConstraintsFromSetCvAnswer(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfCvAnswerCvAnswerItem) {
            // validation for constraint: itemType
            if (!$arrayOfCvAnswerCvAnswerItem instanceof \StructType\CvAnswer) {
                $invalidValues[] = is_object($arrayOfCvAnswerCvAnswerItem) ? get_class($arrayOfCvAnswerCvAnswerItem) : sprintf('%s(%s)', gettype($arrayOfCvAnswerCvAnswerItem), var_export($arrayOfCvAnswerCvAnswerItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The CvAnswer property can only contain items of type \StructType\CvAnswer, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set CvAnswer value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\CvAnswer[] $cvAnswer
     * @return \ArrayType\ArrayOfCvAnswer
     */
    public function setCvAnswer(array $cvAnswer = array())
    {
        // validation for constraint: array
        if ('' !== ($cvAnswerArrayErrorMessage = self::validateCvAnswerForArrayConstraintsFromSetCvAnswer($cvAnswer))) {
            throw new \InvalidArgumentException($cvAnswerArrayErrorMessage, __LINE__);
        }
        if (is_null($cvAnswer) || (is_array($cvAnswer) && empty($cvAnswer))) {
            unset($this->CvAnswer);
        } else {
            $this->CvAnswer = $cvAnswer;
        }
        return $this;
    }
    /**
     * Add item to CvAnswer value
     * @throws \InvalidArgumentException
     * @param \StructType\CvAnswer $item
     * @return \ArrayType\ArrayOfCvAnswer
     */
    public function addToCvAnswer(\StructType\CvAnswer $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CvAnswer) {
            throw new \InvalidArgumentException(sprintf('The CvAnswer property can only contain items of type \StructType\CvAnswer, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->CvAnswer[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\CvAnswer|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\CvAnswer|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\CvAnswer|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\CvAnswer|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\CvAnswer|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string CvAnswer
     */
    public function getAttributeName()
    {
        return 'CvAnswer';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfCvAnswer
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
