<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfContactGroup ArrayType
 * @subpackage Arrays
 */
class ArrayOfContactGroup extends AbstractStructArrayBase
{
    /**
     * The ContactGroup
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\ContactGroup[]
     */
    public $ContactGroup;
    /**
     * Constructor method for ArrayOfContactGroup
     * @uses ArrayOfContactGroup::setContactGroup()
     * @param \StructType\ContactGroup[] $contactGroup
     */
    public function __construct(array $contactGroup = array())
    {
        $this
            ->setContactGroup($contactGroup);
    }
    /**
     * Get ContactGroup value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\ContactGroup[]|null
     */
    public function getContactGroup()
    {
        return isset($this->ContactGroup) ? $this->ContactGroup : null;
    }
    /**
     * This method is responsible for validating the values passed to the setContactGroup method
     * This method is willingly generated in order to preserve the one-line inline validation within the setContactGroup method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateContactGroupForArrayConstraintsFromSetContactGroup(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfContactGroupContactGroupItem) {
            // validation for constraint: itemType
            if (!$arrayOfContactGroupContactGroupItem instanceof \StructType\ContactGroup) {
                $invalidValues[] = is_object($arrayOfContactGroupContactGroupItem) ? get_class($arrayOfContactGroupContactGroupItem) : sprintf('%s(%s)', gettype($arrayOfContactGroupContactGroupItem), var_export($arrayOfContactGroupContactGroupItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ContactGroup property can only contain items of type \StructType\ContactGroup, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ContactGroup value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\ContactGroup[] $contactGroup
     * @return \ArrayType\ArrayOfContactGroup
     */
    public function setContactGroup(array $contactGroup = array())
    {
        // validation for constraint: array
        if ('' !== ($contactGroupArrayErrorMessage = self::validateContactGroupForArrayConstraintsFromSetContactGroup($contactGroup))) {
            throw new \InvalidArgumentException($contactGroupArrayErrorMessage, __LINE__);
        }
        if (is_null($contactGroup) || (is_array($contactGroup) && empty($contactGroup))) {
            unset($this->ContactGroup);
        } else {
            $this->ContactGroup = $contactGroup;
        }
        return $this;
    }
    /**
     * Add item to ContactGroup value
     * @throws \InvalidArgumentException
     * @param \StructType\ContactGroup $item
     * @return \ArrayType\ArrayOfContactGroup
     */
    public function addToContactGroup(\StructType\ContactGroup $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ContactGroup) {
            throw new \InvalidArgumentException(sprintf('The ContactGroup property can only contain items of type \StructType\ContactGroup, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ContactGroup[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\ContactGroup|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\ContactGroup|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\ContactGroup|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\ContactGroup|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\ContactGroup|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string ContactGroup
     */
    public function getAttributeName()
    {
        return 'ContactGroup';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfContactGroup
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
