<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfApprover ArrayType
 * @subpackage Arrays
 */
class ArrayOfApprover extends AbstractStructArrayBase
{
    /**
     * The Approver
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Approver[]
     */
    public $Approver;
    /**
     * Constructor method for ArrayOfApprover
     * @uses ArrayOfApprover::setApprover()
     * @param \StructType\Approver[] $approver
     */
    public function __construct(array $approver = array())
    {
        $this
            ->setApprover($approver);
    }
    /**
     * Get Approver value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Approver[]|null
     */
    public function getApprover()
    {
        return isset($this->Approver) ? $this->Approver : null;
    }
    /**
     * This method is responsible for validating the values passed to the setApprover method
     * This method is willingly generated in order to preserve the one-line inline validation within the setApprover method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateApproverForArrayConstraintsFromSetApprover(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfApproverApproverItem) {
            // validation for constraint: itemType
            if (!$arrayOfApproverApproverItem instanceof \StructType\Approver) {
                $invalidValues[] = is_object($arrayOfApproverApproverItem) ? get_class($arrayOfApproverApproverItem) : sprintf('%s(%s)', gettype($arrayOfApproverApproverItem), var_export($arrayOfApproverApproverItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Approver property can only contain items of type \StructType\Approver, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Approver value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Approver[] $approver
     * @return \ArrayType\ArrayOfApprover
     */
    public function setApprover(array $approver = array())
    {
        // validation for constraint: array
        if ('' !== ($approverArrayErrorMessage = self::validateApproverForArrayConstraintsFromSetApprover($approver))) {
            throw new \InvalidArgumentException($approverArrayErrorMessage, __LINE__);
        }
        if (is_null($approver) || (is_array($approver) && empty($approver))) {
            unset($this->Approver);
        } else {
            $this->Approver = $approver;
        }
        return $this;
    }
    /**
     * Add item to Approver value
     * @throws \InvalidArgumentException
     * @param \StructType\Approver $item
     * @return \ArrayType\ArrayOfApprover
     */
    public function addToApprover(\StructType\Approver $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Approver) {
            throw new \InvalidArgumentException(sprintf('The Approver property can only contain items of type \StructType\Approver, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Approver[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\Approver|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\Approver|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\Approver|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\Approver|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\Approver|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Approver
     */
    public function getAttributeName()
    {
        return 'Approver';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfApprover
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
