<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the fist needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientbase class each generated ServiceType class extends this class
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'http://tshirts.demos.mulesoft.com/?wsdl',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc....
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'http://tshirts.demos.mulesoft.com/?wsdl',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => ClassMap::get(),
);
/**
 * Samples for Track ServiceType
 */
$track = new \ServiceType\Track($options);
/**
 * Sample call for TrackOrder operation/method
 */
if ($track->TrackOrder(new \StructType\TrackOrder()) !== false) {
    print_r($track->getResult());
} else {
    print_r($track->getLastError());
}
/**
 * Samples for Order ServiceType
 */
$order = new \ServiceType\Order($options);
/**
 * Sample call for OrderTshirt operation/method
 */
if ($order->OrderTshirt(new \StructType\OrderTshirt()) !== false) {
    print_r($order->getResult());
} else {
    print_r($order->getLastError());
}
/**
 * Samples for List ServiceType
 */
$list = new \ServiceType\_List($options);
/**
 * Sample call for ListInventory operation/method
 */
if ($list->ListInventory($parameters) !== false) {
    print_r($list->getResult());
} else {
    print_r($list->getLastError());
}
