<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OrderTshirt StructType
 * @subpackage Structs
 */
class OrderTshirt extends AbstractStructBase
{
    /**
     * The size
     * @var string
     */
    public $size;
    /**
     * The email
     * @var string
     */
    public $email;
    /**
     * The name
     * @var string
     */
    public $name;
    /**
     * The address1
     * @var string
     */
    public $address1;
    /**
     * The address2
     * @var string
     */
    public $address2;
    /**
     * The city
     * @var string
     */
    public $city;
    /**
     * The stateOrProvince
     * @var string
     */
    public $stateOrProvince;
    /**
     * The postalCode
     * @var string
     */
    public $postalCode;
    /**
     * The country
     * @var string
     */
    public $country;
    /**
     * Constructor method for OrderTshirt
     * @uses OrderTshirt::setSize()
     * @uses OrderTshirt::setEmail()
     * @uses OrderTshirt::setName()
     * @uses OrderTshirt::setAddress1()
     * @uses OrderTshirt::setAddress2()
     * @uses OrderTshirt::setCity()
     * @uses OrderTshirt::setStateOrProvince()
     * @uses OrderTshirt::setPostalCode()
     * @uses OrderTshirt::setCountry()
     * @param string $size
     * @param string $email
     * @param string $name
     * @param string $address1
     * @param string $address2
     * @param string $city
     * @param string $stateOrProvince
     * @param string $postalCode
     * @param string $country
     */
    public function __construct($size = null, $email = null, $name = null, $address1 = null, $address2 = null, $city = null, $stateOrProvince = null, $postalCode = null, $country = null)
    {
        $this
            ->setSize($size)
            ->setEmail($email)
            ->setName($name)
            ->setAddress1($address1)
            ->setAddress2($address2)
            ->setCity($city)
            ->setStateOrProvince($stateOrProvince)
            ->setPostalCode($postalCode)
            ->setCountry($country);
    }
    /**
     * Get size value
     * @return string|null
     */
    public function getSize()
    {
        return $this->size;
    }
    /**
     * Set size value
     * @uses \EnumType\Size::valueIsValid()
     * @uses \EnumType\Size::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $size
     * @return \StructType\OrderTshirt
     */
    public function setSize($size = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\Size::valueIsValid($size)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\Size', is_array($size) ? implode(', ', $size) : var_export($size, true), implode(', ', \EnumType\Size::getValidValues())), __LINE__);
        }
        $this->size = $size;
        return $this;
    }
    /**
     * Get email value
     * @return string|null
     */
    public function getEmail()
    {
        return $this->email;
    }
    /**
     * Set email value
     * @param string $email
     * @return \StructType\OrderTshirt
     */
    public function setEmail($email = null)
    {
        // validation for constraint: string
        if (!is_null($email) && !is_string($email)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($email, true), gettype($email)), __LINE__);
        }
        $this->email = $email;
        return $this;
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \StructType\OrderTshirt
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get address1 value
     * @return string|null
     */
    public function getAddress1()
    {
        return $this->address1;
    }
    /**
     * Set address1 value
     * @param string $address1
     * @return \StructType\OrderTshirt
     */
    public function setAddress1($address1 = null)
    {
        // validation for constraint: string
        if (!is_null($address1) && !is_string($address1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($address1, true), gettype($address1)), __LINE__);
        }
        $this->address1 = $address1;
        return $this;
    }
    /**
     * Get address2 value
     * @return string|null
     */
    public function getAddress2()
    {
        return $this->address2;
    }
    /**
     * Set address2 value
     * @param string $address2
     * @return \StructType\OrderTshirt
     */
    public function setAddress2($address2 = null)
    {
        // validation for constraint: string
        if (!is_null($address2) && !is_string($address2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($address2, true), gettype($address2)), __LINE__);
        }
        $this->address2 = $address2;
        return $this;
    }
    /**
     * Get city value
     * @return string|null
     */
    public function getCity()
    {
        return $this->city;
    }
    /**
     * Set city value
     * @param string $city
     * @return \StructType\OrderTshirt
     */
    public function setCity($city = null)
    {
        // validation for constraint: string
        if (!is_null($city) && !is_string($city)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($city, true), gettype($city)), __LINE__);
        }
        $this->city = $city;
        return $this;
    }
    /**
     * Get stateOrProvince value
     * @return string|null
     */
    public function getStateOrProvince()
    {
        return $this->stateOrProvince;
    }
    /**
     * Set stateOrProvince value
     * @param string $stateOrProvince
     * @return \StructType\OrderTshirt
     */
    public function setStateOrProvince($stateOrProvince = null)
    {
        // validation for constraint: string
        if (!is_null($stateOrProvince) && !is_string($stateOrProvince)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($stateOrProvince, true), gettype($stateOrProvince)), __LINE__);
        }
        $this->stateOrProvince = $stateOrProvince;
        return $this;
    }
    /**
     * Get postalCode value
     * @return string|null
     */
    public function getPostalCode()
    {
        return $this->postalCode;
    }
    /**
     * Set postalCode value
     * @param string $postalCode
     * @return \StructType\OrderTshirt
     */
    public function setPostalCode($postalCode = null)
    {
        // validation for constraint: string
        if (!is_null($postalCode) && !is_string($postalCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($postalCode, true), gettype($postalCode)), __LINE__);
        }
        $this->postalCode = $postalCode;
        return $this;
    }
    /**
     * Get country value
     * @return string|null
     */
    public function getCountry()
    {
        return $this->country;
    }
    /**
     * Set country value
     * @param string $country
     * @return \StructType\OrderTshirt
     */
    public function setCountry($country = null)
    {
        // validation for constraint: string
        if (!is_null($country) && !is_string($country)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($country, true), gettype($country)), __LINE__);
        }
        $this->country = $country;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\OrderTshirt
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
