<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for InventoryItem StructType
 * @subpackage Structs
 */
class InventoryItem extends AbstractStructBase
{
    /**
     * The productCode
     * @var string
     */
    public $productCode;
    /**
     * The size
     * @var string
     */
    public $size;
    /**
     * The description
     * @var string
     */
    public $description;
    /**
     * The count
     * @var int
     */
    public $count;
    /**
     * Constructor method for InventoryItem
     * @uses InventoryItem::setProductCode()
     * @uses InventoryItem::setSize()
     * @uses InventoryItem::setDescription()
     * @uses InventoryItem::setCount()
     * @param string $productCode
     * @param string $size
     * @param string $description
     * @param int $count
     */
    public function __construct($productCode = null, $size = null, $description = null, $count = null)
    {
        $this
            ->setProductCode($productCode)
            ->setSize($size)
            ->setDescription($description)
            ->setCount($count);
    }
    /**
     * Get productCode value
     * @return string|null
     */
    public function getProductCode()
    {
        return $this->productCode;
    }
    /**
     * Set productCode value
     * @param string $productCode
     * @return \StructType\InventoryItem
     */
    public function setProductCode($productCode = null)
    {
        // validation for constraint: string
        if (!is_null($productCode) && !is_string($productCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($productCode, true), gettype($productCode)), __LINE__);
        }
        $this->productCode = $productCode;
        return $this;
    }
    /**
     * Get size value
     * @return string|null
     */
    public function getSize()
    {
        return $this->size;
    }
    /**
     * Set size value
     * @uses \EnumType\Size::valueIsValid()
     * @uses \EnumType\Size::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $size
     * @return \StructType\InventoryItem
     */
    public function setSize($size = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\Size::valueIsValid($size)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\Size', is_array($size) ? implode(', ', $size) : var_export($size, true), implode(', ', \EnumType\Size::getValidValues())), __LINE__);
        }
        $this->size = $size;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \StructType\InventoryItem
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get count value
     * @return int|null
     */
    public function getCount()
    {
        return $this->count;
    }
    /**
     * Set count value
     * @param int $count
     * @return \StructType\InventoryItem
     */
    public function setCount($count = null)
    {
        // validation for constraint: int
        if (!is_null($count) && !(is_int($count) || ctype_digit($count))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($count, true), gettype($count)), __LINE__);
        }
        $this->count = $count;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\InventoryItem
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
