<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for APIUsageInformation StructType
 * @subpackage Structs
 */
class APIUsageInformation extends AbstractStructBase
{
    /**
     * The apiCallsRemaining
     * @var int
     */
    public $apiCallsRemaining;
    /**
     * Constructor method for APIUsageInformation
     * @uses APIUsageInformation::setApiCallsRemaining()
     * @param int $apiCallsRemaining
     */
    public function __construct($apiCallsRemaining = null)
    {
        $this
            ->setApiCallsRemaining($apiCallsRemaining);
    }
    /**
     * Get apiCallsRemaining value
     * @return int|null
     */
    public function getApiCallsRemaining()
    {
        return $this->apiCallsRemaining;
    }
    /**
     * Set apiCallsRemaining value
     * @param int $apiCallsRemaining
     * @return \StructType\APIUsageInformation
     */
    public function setApiCallsRemaining($apiCallsRemaining = null)
    {
        // validation for constraint: int
        if (!is_null($apiCallsRemaining) && !(is_int($apiCallsRemaining) || ctype_digit($apiCallsRemaining))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($apiCallsRemaining, true), gettype($apiCallsRemaining)), __LINE__);
        }
        $this->apiCallsRemaining = $apiCallsRemaining;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\APIUsageInformation
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
