<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TrackOrderResponse StructType
 * @subpackage Structs
 */
class TrackOrderResponse extends AbstractStructBase
{
    /**
     * The orderId
     * @var string
     */
    public $orderId;
    /**
     * The status
     * @var string
     */
    public $status;
    /**
     * The size
     * @var string
     */
    public $size;
    /**
     * Constructor method for TrackOrderResponse
     * @uses TrackOrderResponse::setOrderId()
     * @uses TrackOrderResponse::setStatus()
     * @uses TrackOrderResponse::setSize()
     * @param string $orderId
     * @param string $status
     * @param string $size
     */
    public function __construct($orderId = null, $status = null, $size = null)
    {
        $this
            ->setOrderId($orderId)
            ->setStatus($status)
            ->setSize($size);
    }
    /**
     * Get orderId value
     * @return string|null
     */
    public function getOrderId()
    {
        return $this->orderId;
    }
    /**
     * Set orderId value
     * @param string $orderId
     * @return \StructType\TrackOrderResponse
     */
    public function setOrderId($orderId = null)
    {
        // validation for constraint: string
        if (!is_null($orderId) && !is_string($orderId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($orderId, true), gettype($orderId)), __LINE__);
        }
        $this->orderId = $orderId;
        return $this;
    }
    /**
     * Get status value
     * @return string|null
     */
    public function getStatus()
    {
        return $this->status;
    }
    /**
     * Set status value
     * @param string $status
     * @return \StructType\TrackOrderResponse
     */
    public function setStatus($status = null)
    {
        // validation for constraint: string
        if (!is_null($status) && !is_string($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($status, true), gettype($status)), __LINE__);
        }
        $this->status = $status;
        return $this;
    }
    /**
     * Get size value
     * @return string|null
     */
    public function getSize()
    {
        return $this->size;
    }
    /**
     * Set size value
     * @uses \EnumType\Size::valueIsValid()
     * @uses \EnumType\Size::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $size
     * @return \StructType\TrackOrderResponse
     */
    public function setSize($size = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\Size::valueIsValid($size)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\Size', is_array($size) ? implode(', ', $size) : var_export($size, true), implode(', ', \EnumType\Size::getValidValues())), __LINE__);
        }
        $this->size = $size;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\TrackOrderResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
