<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ListInventoryResponse StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: xs:anyType
 * @subpackage Structs
 */
class ListInventoryResponse extends AbstractStructBase
{
    /**
     * The inventory
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\InventoryItem[]
     */
    public $inventory;
    /**
     * Constructor method for ListInventoryResponse
     * @uses ListInventoryResponse::setInventory()
     * @param \StructType\InventoryItem[] $inventory
     */
    public function __construct(array $inventory = array())
    {
        $this
            ->setInventory($inventory);
    }
    /**
     * Get inventory value
     * @return \StructType\InventoryItem[]|null
     */
    public function getInventory()
    {
        return $this->inventory;
    }
    /**
     * This method is responsible for validating the values passed to the setInventory method
     * This method is willingly generated in order to preserve the one-line inline validation within the setInventory method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateInventoryForArrayConstraintsFromSetInventory(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $listInventoryResponseInventoryItem) {
            // validation for constraint: itemType
            if (!$listInventoryResponseInventoryItem instanceof \StructType\InventoryItem) {
                $invalidValues[] = is_object($listInventoryResponseInventoryItem) ? get_class($listInventoryResponseInventoryItem) : sprintf('%s(%s)', gettype($listInventoryResponseInventoryItem), var_export($listInventoryResponseInventoryItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The inventory property can only contain items of type \StructType\InventoryItem, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set inventory value
     * @throws \InvalidArgumentException
     * @param \StructType\InventoryItem[] $inventory
     * @return \StructType\ListInventoryResponse
     */
    public function setInventory(array $inventory = array())
    {
        // validation for constraint: array
        if ('' !== ($inventoryArrayErrorMessage = self::validateInventoryForArrayConstraintsFromSetInventory($inventory))) {
            throw new \InvalidArgumentException($inventoryArrayErrorMessage, __LINE__);
        }
        $this->inventory = $inventory;
        return $this;
    }
    /**
     * Add item to inventory value
     * @throws \InvalidArgumentException
     * @param \StructType\InventoryItem $item
     * @return \StructType\ListInventoryResponse
     */
    public function addToInventory(\StructType\InventoryItem $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\InventoryItem) {
            throw new \InvalidArgumentException(sprintf('The inventory property can only contain items of type \StructType\InventoryItem, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->inventory[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ListInventoryResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
