<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Results StructType
 * @subpackage Structs
 */
class Results extends AbstractStructBase
{
    /**
     * The CAVV
     * @var string
     */
    public $CAVV;
    /**
     * The PAResStatus
     * @var string
     */
    public $PAResStatus;
    /**
     * The SignatureVerfication
     * @var string
     */
    public $SignatureVerfication;
    /**
     * The TransactionID
     * @var string
     */
    public $TransactionID;
    /**
     * The XID
     * @var string
     */
    public $XID;
    /**
     * Constructor method for Results
     * @uses Results::setCAVV()
     * @uses Results::setPAResStatus()
     * @uses Results::setSignatureVerfication()
     * @uses Results::setTransactionID()
     * @uses Results::setXID()
     * @param string $cAVV
     * @param string $pAResStatus
     * @param string $signatureVerfication
     * @param string $transactionID
     * @param string $xID
     */
    public function __construct($cAVV = null, $pAResStatus = null, $signatureVerfication = null, $transactionID = null, $xID = null)
    {
        $this
            ->setCAVV($cAVV)
            ->setPAResStatus($pAResStatus)
            ->setSignatureVerfication($signatureVerfication)
            ->setTransactionID($transactionID)
            ->setXID($xID);
    }
    /**
     * Get CAVV value
     * @return string|null
     */
    public function getCAVV()
    {
        return $this->CAVV;
    }
    /**
     * Set CAVV value
     * @param string $cAVV
     * @return \StructType\Results
     */
    public function setCAVV($cAVV = null)
    {
        // validation for constraint: string
        if (!is_null($cAVV) && !is_string($cAVV)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cAVV, true), gettype($cAVV)), __LINE__);
        }
        $this->CAVV = $cAVV;
        return $this;
    }
    /**
     * Get PAResStatus value
     * @return string|null
     */
    public function getPAResStatus()
    {
        return $this->PAResStatus;
    }
    /**
     * Set PAResStatus value
     * @param string $pAResStatus
     * @return \StructType\Results
     */
    public function setPAResStatus($pAResStatus = null)
    {
        // validation for constraint: string
        if (!is_null($pAResStatus) && !is_string($pAResStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pAResStatus, true), gettype($pAResStatus)), __LINE__);
        }
        $this->PAResStatus = $pAResStatus;
        return $this;
    }
    /**
     * Get SignatureVerfication value
     * @return string|null
     */
    public function getSignatureVerfication()
    {
        return $this->SignatureVerfication;
    }
    /**
     * Set SignatureVerfication value
     * @param string $signatureVerfication
     * @return \StructType\Results
     */
    public function setSignatureVerfication($signatureVerfication = null)
    {
        // validation for constraint: string
        if (!is_null($signatureVerfication) && !is_string($signatureVerfication)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($signatureVerfication, true), gettype($signatureVerfication)), __LINE__);
        }
        $this->SignatureVerfication = $signatureVerfication;
        return $this;
    }
    /**
     * Get TransactionID value
     * @return string|null
     */
    public function getTransactionID()
    {
        return $this->TransactionID;
    }
    /**
     * Set TransactionID value
     * @param string $transactionID
     * @return \StructType\Results
     */
    public function setTransactionID($transactionID = null)
    {
        // validation for constraint: string
        if (!is_null($transactionID) && !is_string($transactionID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transactionID, true), gettype($transactionID)), __LINE__);
        }
        $this->TransactionID = $transactionID;
        return $this;
    }
    /**
     * Get XID value
     * @return string|null
     */
    public function getXID()
    {
        return $this->XID;
    }
    /**
     * Set XID value
     * @param string $xID
     * @return \StructType\Results
     */
    public function setXID($xID = null)
    {
        // validation for constraint: string
        if (!is_null($xID) && !is_string($xID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($xID, true), gettype($xID)), __LINE__);
        }
        $this->XID = $xID;
        return $this;
    }
}
