<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ProfileReadRequest StructType
 * @subpackage Structs
 */
class ProfileReadRequest extends AbstractStructBase
{
    /**
     * The UniqueID
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\UniqueID[]
     */
    public $UniqueID;
    /**
     * The Company
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ContactPersonType
     */
    public $Company;
    /**
     * The Customer
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\CustomerType
     */
    public $Customer;
    /**
     * The Start
     * @var string
     */
    public $Start;
    /**
     * The Duration
     * @var string
     */
    public $Duration;
    /**
     * The End
     * @var string
     */
    public $End;
    /**
     * The DateType
     * @var string
     */
    public $DateType;
    /**
     * The StatusCode
     * @var string
     */
    public $StatusCode;
    /**
     * The ProfileTypeCode
     * @var string
     */
    public $ProfileTypeCode;
    /**
     * Constructor method for ProfileReadRequest
     * @uses ProfileReadRequest::setUniqueID()
     * @uses ProfileReadRequest::setCompany()
     * @uses ProfileReadRequest::setCustomer()
     * @uses ProfileReadRequest::setStart()
     * @uses ProfileReadRequest::setDuration()
     * @uses ProfileReadRequest::setEnd()
     * @uses ProfileReadRequest::setDateType()
     * @uses ProfileReadRequest::setStatusCode()
     * @uses ProfileReadRequest::setProfileTypeCode()
     * @param \StructType\UniqueID[] $uniqueID
     * @param \StructType\ContactPersonType $company
     * @param \StructType\CustomerType $customer
     * @param string $start
     * @param string $duration
     * @param string $end
     * @param string $dateType
     * @param string $statusCode
     * @param string $profileTypeCode
     */
    public function __construct(array $uniqueID = array(), \StructType\ContactPersonType $company = null, \StructType\CustomerType $customer = null, $start = null, $duration = null, $end = null, $dateType = null, $statusCode = null, $profileTypeCode = null)
    {
        $this
            ->setUniqueID($uniqueID)
            ->setCompany($company)
            ->setCustomer($customer)
            ->setStart($start)
            ->setDuration($duration)
            ->setEnd($end)
            ->setDateType($dateType)
            ->setStatusCode($statusCode)
            ->setProfileTypeCode($profileTypeCode);
    }
    /**
     * Get UniqueID value
     * @return \StructType\UniqueID[]|null
     */
    public function getUniqueID()
    {
        return $this->UniqueID;
    }
    /**
     * This method is responsible for validating the values passed to the setUniqueID method
     * This method is willingly generated in order to preserve the one-line inline validation within the setUniqueID method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateUniqueIDForArrayConstraintsFromSetUniqueID(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $profileReadRequestUniqueIDItem) {
            // validation for constraint: itemType
            if (!$profileReadRequestUniqueIDItem instanceof \StructType\UniqueID) {
                $invalidValues[] = is_object($profileReadRequestUniqueIDItem) ? get_class($profileReadRequestUniqueIDItem) : sprintf('%s(%s)', gettype($profileReadRequestUniqueIDItem), var_export($profileReadRequestUniqueIDItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The UniqueID property can only contain items of type \StructType\UniqueID, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set UniqueID value
     * @throws \InvalidArgumentException
     * @param \StructType\UniqueID[] $uniqueID
     * @return \StructType\ProfileReadRequest
     */
    public function setUniqueID(array $uniqueID = array())
    {
        // validation for constraint: array
        if ('' !== ($uniqueIDArrayErrorMessage = self::validateUniqueIDForArrayConstraintsFromSetUniqueID($uniqueID))) {
            throw new \InvalidArgumentException($uniqueIDArrayErrorMessage, __LINE__);
        }
        $this->UniqueID = $uniqueID;
        return $this;
    }
    /**
     * Add item to UniqueID value
     * @throws \InvalidArgumentException
     * @param \StructType\UniqueID $item
     * @return \StructType\ProfileReadRequest
     */
    public function addToUniqueID(\StructType\UniqueID $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\UniqueID) {
            throw new \InvalidArgumentException(sprintf('The UniqueID property can only contain items of type \StructType\UniqueID, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->UniqueID[] = $item;
        return $this;
    }
    /**
     * Get Company value
     * @return \StructType\ContactPersonType|null
     */
    public function getCompany()
    {
        return $this->Company;
    }
    /**
     * Set Company value
     * @param \StructType\ContactPersonType $company
     * @return \StructType\ProfileReadRequest
     */
    public function setCompany(\StructType\ContactPersonType $company = null)
    {
        $this->Company = $company;
        return $this;
    }
    /**
     * Get Customer value
     * @return \StructType\CustomerType|null
     */
    public function getCustomer()
    {
        return $this->Customer;
    }
    /**
     * Set Customer value
     * @param \StructType\CustomerType $customer
     * @return \StructType\ProfileReadRequest
     */
    public function setCustomer(\StructType\CustomerType $customer = null)
    {
        $this->Customer = $customer;
        return $this;
    }
    /**
     * Get Start value
     * @return string|null
     */
    public function getStart()
    {
        return $this->Start;
    }
    /**
     * Set Start value
     * @param string $start
     * @return \StructType\ProfileReadRequest
     */
    public function setStart($start = null)
    {
        // validation for constraint: string
        if (!is_null($start) && !is_string($start)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($start, true), gettype($start)), __LINE__);
        }
        $this->Start = $start;
        return $this;
    }
    /**
     * Get Duration value
     * @return string|null
     */
    public function getDuration()
    {
        return $this->Duration;
    }
    /**
     * Set Duration value
     * @param string $duration
     * @return \StructType\ProfileReadRequest
     */
    public function setDuration($duration = null)
    {
        // validation for constraint: string
        if (!is_null($duration) && !is_string($duration)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($duration, true), gettype($duration)), __LINE__);
        }
        $this->Duration = $duration;
        return $this;
    }
    /**
     * Get End value
     * @return string|null
     */
    public function getEnd()
    {
        return $this->End;
    }
    /**
     * Set End value
     * @param string $end
     * @return \StructType\ProfileReadRequest
     */
    public function setEnd($end = null)
    {
        // validation for constraint: string
        if (!is_null($end) && !is_string($end)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($end, true), gettype($end)), __LINE__);
        }
        $this->End = $end;
        return $this;
    }
    /**
     * Get DateType value
     * @return string|null
     */
    public function getDateType()
    {
        return $this->DateType;
    }
    /**
     * Set DateType value
     * @param string $dateType
     * @return \StructType\ProfileReadRequest
     */
    public function setDateType($dateType = null)
    {
        // validation for constraint: string
        if (!is_null($dateType) && !is_string($dateType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dateType, true), gettype($dateType)), __LINE__);
        }
        $this->DateType = $dateType;
        return $this;
    }
    /**
     * Get StatusCode value
     * @return string|null
     */
    public function getStatusCode()
    {
        return $this->StatusCode;
    }
    /**
     * Set StatusCode value
     * @param string $statusCode
     * @return \StructType\ProfileReadRequest
     */
    public function setStatusCode($statusCode = null)
    {
        // validation for constraint: string
        if (!is_null($statusCode) && !is_string($statusCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($statusCode, true), gettype($statusCode)), __LINE__);
        }
        $this->StatusCode = $statusCode;
        return $this;
    }
    /**
     * Get ProfileTypeCode value
     * @return string|null
     */
    public function getProfileTypeCode()
    {
        return $this->ProfileTypeCode;
    }
    /**
     * Set ProfileTypeCode value
     * @param string $profileTypeCode
     * @return \StructType\ProfileReadRequest
     */
    public function setProfileTypeCode($profileTypeCode = null)
    {
        // validation for constraint: string
        if (!is_null($profileTypeCode) && !is_string($profileTypeCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($profileTypeCode, true), gettype($profileTypeCode)), __LINE__);
        }
        $this->ProfileTypeCode = $profileTypeCode;
        return $this;
    }
}
