<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CustLoyalty StructType
 * @subpackage Structs
 */
class CustLoyalty extends AbstractStructBase
{
    /**
     * The ProgramID
     * @var string
     */
    public $ProgramID;
    /**
     * The MembershipID
     * @var string
     */
    public $MembershipID;
    /**
     * The LoyalLevel
     * @var string
     */
    public $LoyalLevel;
    /**
     * The SignupDate
     * @var string
     */
    public $SignupDate;
    /**
     * The EffectiveDate
     * @var string
     */
    public $EffectiveDate;
    /**
     * The ExpireDate
     * @var string
     */
    public $ExpireDate;
    /**
     * The SubAccountBalance
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SubAccountBalance[]
     */
    public $SubAccountBalance;
    /**
     * Constructor method for CustLoyalty
     * @uses CustLoyalty::setProgramID()
     * @uses CustLoyalty::setMembershipID()
     * @uses CustLoyalty::setLoyalLevel()
     * @uses CustLoyalty::setSignupDate()
     * @uses CustLoyalty::setEffectiveDate()
     * @uses CustLoyalty::setExpireDate()
     * @uses CustLoyalty::setSubAccountBalance()
     * @param string $programID
     * @param string $membershipID
     * @param string $loyalLevel
     * @param string $signupDate
     * @param string $effectiveDate
     * @param string $expireDate
     * @param \StructType\SubAccountBalance[] $subAccountBalance
     */
    public function __construct($programID = null, $membershipID = null, $loyalLevel = null, $signupDate = null, $effectiveDate = null, $expireDate = null, array $subAccountBalance = array())
    {
        $this
            ->setProgramID($programID)
            ->setMembershipID($membershipID)
            ->setLoyalLevel($loyalLevel)
            ->setSignupDate($signupDate)
            ->setEffectiveDate($effectiveDate)
            ->setExpireDate($expireDate)
            ->setSubAccountBalance($subAccountBalance);
    }
    /**
     * Get ProgramID value
     * @return string|null
     */
    public function getProgramID()
    {
        return $this->ProgramID;
    }
    /**
     * Set ProgramID value
     * @param string $programID
     * @return \StructType\CustLoyalty
     */
    public function setProgramID($programID = null)
    {
        // validation for constraint: string
        if (!is_null($programID) && !is_string($programID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($programID, true), gettype($programID)), __LINE__);
        }
        $this->ProgramID = $programID;
        return $this;
    }
    /**
     * Get MembershipID value
     * @return string|null
     */
    public function getMembershipID()
    {
        return $this->MembershipID;
    }
    /**
     * Set MembershipID value
     * @param string $membershipID
     * @return \StructType\CustLoyalty
     */
    public function setMembershipID($membershipID = null)
    {
        // validation for constraint: string
        if (!is_null($membershipID) && !is_string($membershipID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($membershipID, true), gettype($membershipID)), __LINE__);
        }
        $this->MembershipID = $membershipID;
        return $this;
    }
    /**
     * Get LoyalLevel value
     * @return string|null
     */
    public function getLoyalLevel()
    {
        return $this->LoyalLevel;
    }
    /**
     * Set LoyalLevel value
     * @param string $loyalLevel
     * @return \StructType\CustLoyalty
     */
    public function setLoyalLevel($loyalLevel = null)
    {
        // validation for constraint: string
        if (!is_null($loyalLevel) && !is_string($loyalLevel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($loyalLevel, true), gettype($loyalLevel)), __LINE__);
        }
        $this->LoyalLevel = $loyalLevel;
        return $this;
    }
    /**
     * Get SignupDate value
     * @return string|null
     */
    public function getSignupDate()
    {
        return $this->SignupDate;
    }
    /**
     * Set SignupDate value
     * @param string $signupDate
     * @return \StructType\CustLoyalty
     */
    public function setSignupDate($signupDate = null)
    {
        // validation for constraint: string
        if (!is_null($signupDate) && !is_string($signupDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($signupDate, true), gettype($signupDate)), __LINE__);
        }
        $this->SignupDate = $signupDate;
        return $this;
    }
    /**
     * Get EffectiveDate value
     * @return string|null
     */
    public function getEffectiveDate()
    {
        return $this->EffectiveDate;
    }
    /**
     * Set EffectiveDate value
     * @param string $effectiveDate
     * @return \StructType\CustLoyalty
     */
    public function setEffectiveDate($effectiveDate = null)
    {
        // validation for constraint: string
        if (!is_null($effectiveDate) && !is_string($effectiveDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($effectiveDate, true), gettype($effectiveDate)), __LINE__);
        }
        $this->EffectiveDate = $effectiveDate;
        return $this;
    }
    /**
     * Get ExpireDate value
     * @return string|null
     */
    public function getExpireDate()
    {
        return $this->ExpireDate;
    }
    /**
     * Set ExpireDate value
     * @param string $expireDate
     * @return \StructType\CustLoyalty
     */
    public function setExpireDate($expireDate = null)
    {
        // validation for constraint: string
        if (!is_null($expireDate) && !is_string($expireDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($expireDate, true), gettype($expireDate)), __LINE__);
        }
        $this->ExpireDate = $expireDate;
        return $this;
    }
    /**
     * Get SubAccountBalance value
     * @return \StructType\SubAccountBalance[]|null
     */
    public function getSubAccountBalance()
    {
        return $this->SubAccountBalance;
    }
    /**
     * This method is responsible for validating the values passed to the setSubAccountBalance method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSubAccountBalance method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSubAccountBalanceForArrayConstraintsFromSetSubAccountBalance(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $custLoyaltySubAccountBalanceItem) {
            // validation for constraint: itemType
            if (!$custLoyaltySubAccountBalanceItem instanceof \StructType\SubAccountBalance) {
                $invalidValues[] = is_object($custLoyaltySubAccountBalanceItem) ? get_class($custLoyaltySubAccountBalanceItem) : sprintf('%s(%s)', gettype($custLoyaltySubAccountBalanceItem), var_export($custLoyaltySubAccountBalanceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The SubAccountBalance property can only contain items of type \StructType\SubAccountBalance, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set SubAccountBalance value
     * @throws \InvalidArgumentException
     * @param \StructType\SubAccountBalance[] $subAccountBalance
     * @return \StructType\CustLoyalty
     */
    public function setSubAccountBalance(array $subAccountBalance = array())
    {
        // validation for constraint: array
        if ('' !== ($subAccountBalanceArrayErrorMessage = self::validateSubAccountBalanceForArrayConstraintsFromSetSubAccountBalance($subAccountBalance))) {
            throw new \InvalidArgumentException($subAccountBalanceArrayErrorMessage, __LINE__);
        }
        $this->SubAccountBalance = $subAccountBalance;
        return $this;
    }
    /**
     * Add item to SubAccountBalance value
     * @throws \InvalidArgumentException
     * @param \StructType\SubAccountBalance $item
     * @return \StructType\CustLoyalty
     */
    public function addToSubAccountBalance(\StructType\SubAccountBalance $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SubAccountBalance) {
            throw new \InvalidArgumentException(sprintf('The SubAccountBalance property can only contain items of type \StructType\SubAccountBalance, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->SubAccountBalance[] = $item;
        return $this;
    }
}
