<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Occupancy StructType
 * @subpackage Structs
 */
class Occupancy extends AbstractStructBase
{
    /**
     * The MinOccupancy
     * @var int
     */
    public $MinOccupancy;
    /**
     * The MaxOccupancy
     * @var int
     */
    public $MaxOccupancy;
    /**
     * The AgeQualifyingCode
     * @var string
     */
    public $AgeQualifyingCode;
    /**
     * The MinAge
     * @var int
     */
    public $MinAge;
    /**
     * The MaxAge
     * @var int
     */
    public $MaxAge;
    /**
     * The AgeTimeUnit
     * @var string
     */
    public $AgeTimeUnit;
    /**
     * The AgeBucket
     * @var string
     */
    public $AgeBucket;
    /**
     * Constructor method for Occupancy
     * @uses Occupancy::setMinOccupancy()
     * @uses Occupancy::setMaxOccupancy()
     * @uses Occupancy::setAgeQualifyingCode()
     * @uses Occupancy::setMinAge()
     * @uses Occupancy::setMaxAge()
     * @uses Occupancy::setAgeTimeUnit()
     * @uses Occupancy::setAgeBucket()
     * @param int $minOccupancy
     * @param int $maxOccupancy
     * @param string $ageQualifyingCode
     * @param int $minAge
     * @param int $maxAge
     * @param string $ageTimeUnit
     * @param string $ageBucket
     */
    public function __construct($minOccupancy = null, $maxOccupancy = null, $ageQualifyingCode = null, $minAge = null, $maxAge = null, $ageTimeUnit = null, $ageBucket = null)
    {
        $this
            ->setMinOccupancy($minOccupancy)
            ->setMaxOccupancy($maxOccupancy)
            ->setAgeQualifyingCode($ageQualifyingCode)
            ->setMinAge($minAge)
            ->setMaxAge($maxAge)
            ->setAgeTimeUnit($ageTimeUnit)
            ->setAgeBucket($ageBucket);
    }
    /**
     * Get MinOccupancy value
     * @return int|null
     */
    public function getMinOccupancy()
    {
        return $this->MinOccupancy;
    }
    /**
     * Set MinOccupancy value
     * @param int $minOccupancy
     * @return \StructType\Occupancy
     */
    public function setMinOccupancy($minOccupancy = null)
    {
        // validation for constraint: int
        if (!is_null($minOccupancy) && !(is_int($minOccupancy) || ctype_digit($minOccupancy))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($minOccupancy, true), gettype($minOccupancy)), __LINE__);
        }
        $this->MinOccupancy = $minOccupancy;
        return $this;
    }
    /**
     * Get MaxOccupancy value
     * @return int|null
     */
    public function getMaxOccupancy()
    {
        return $this->MaxOccupancy;
    }
    /**
     * Set MaxOccupancy value
     * @param int $maxOccupancy
     * @return \StructType\Occupancy
     */
    public function setMaxOccupancy($maxOccupancy = null)
    {
        // validation for constraint: int
        if (!is_null($maxOccupancy) && !(is_int($maxOccupancy) || ctype_digit($maxOccupancy))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($maxOccupancy, true), gettype($maxOccupancy)), __LINE__);
        }
        $this->MaxOccupancy = $maxOccupancy;
        return $this;
    }
    /**
     * Get AgeQualifyingCode value
     * @return string|null
     */
    public function getAgeQualifyingCode()
    {
        return $this->AgeQualifyingCode;
    }
    /**
     * Set AgeQualifyingCode value
     * @param string $ageQualifyingCode
     * @return \StructType\Occupancy
     */
    public function setAgeQualifyingCode($ageQualifyingCode = null)
    {
        // validation for constraint: string
        if (!is_null($ageQualifyingCode) && !is_string($ageQualifyingCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ageQualifyingCode, true), gettype($ageQualifyingCode)), __LINE__);
        }
        $this->AgeQualifyingCode = $ageQualifyingCode;
        return $this;
    }
    /**
     * Get MinAge value
     * @return int|null
     */
    public function getMinAge()
    {
        return $this->MinAge;
    }
    /**
     * Set MinAge value
     * @param int $minAge
     * @return \StructType\Occupancy
     */
    public function setMinAge($minAge = null)
    {
        // validation for constraint: int
        if (!is_null($minAge) && !(is_int($minAge) || ctype_digit($minAge))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($minAge, true), gettype($minAge)), __LINE__);
        }
        $this->MinAge = $minAge;
        return $this;
    }
    /**
     * Get MaxAge value
     * @return int|null
     */
    public function getMaxAge()
    {
        return $this->MaxAge;
    }
    /**
     * Set MaxAge value
     * @param int $maxAge
     * @return \StructType\Occupancy
     */
    public function setMaxAge($maxAge = null)
    {
        // validation for constraint: int
        if (!is_null($maxAge) && !(is_int($maxAge) || ctype_digit($maxAge))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($maxAge, true), gettype($maxAge)), __LINE__);
        }
        $this->MaxAge = $maxAge;
        return $this;
    }
    /**
     * Get AgeTimeUnit value
     * @return string|null
     */
    public function getAgeTimeUnit()
    {
        return $this->AgeTimeUnit;
    }
    /**
     * Set AgeTimeUnit value
     * @uses \EnumType\TimeUnitType::valueIsValid()
     * @uses \EnumType\TimeUnitType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $ageTimeUnit
     * @return \StructType\Occupancy
     */
    public function setAgeTimeUnit($ageTimeUnit = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\TimeUnitType::valueIsValid($ageTimeUnit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\TimeUnitType', is_array($ageTimeUnit) ? implode(', ', $ageTimeUnit) : var_export($ageTimeUnit, true), implode(', ', \EnumType\TimeUnitType::getValidValues())), __LINE__);
        }
        $this->AgeTimeUnit = $ageTimeUnit;
        return $this;
    }
    /**
     * Get AgeBucket value
     * @return string|null
     */
    public function getAgeBucket()
    {
        return $this->AgeBucket;
    }
    /**
     * Set AgeBucket value
     * @param string $ageBucket
     * @return \StructType\Occupancy
     */
    public function setAgeBucket($ageBucket = null)
    {
        // validation for constraint: string
        if (!is_null($ageBucket) && !is_string($ageBucket)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ageBucket, true), gettype($ageBucket)), __LINE__);
        }
        $this->AgeBucket = $ageBucket;
        return $this;
    }
}
