<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ItemSearchCriterionType StructType
 * @subpackage Structs
 */
class ItemSearchCriterionType extends AbstractStructBase
{
    /**
     * The HotelRef
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\HotelRef[]
     */
    public $HotelRef;
    /**
     * The ExactMatch
     * @var bool
     */
    public $ExactMatch;
    /**
     * Constructor method for ItemSearchCriterionType
     * @uses ItemSearchCriterionType::setHotelRef()
     * @uses ItemSearchCriterionType::setExactMatch()
     * @param \StructType\HotelRef[] $hotelRef
     * @param bool $exactMatch
     */
    public function __construct(array $hotelRef = array(), $exactMatch = null)
    {
        $this
            ->setHotelRef($hotelRef)
            ->setExactMatch($exactMatch);
    }
    /**
     * Get HotelRef value
     * @return \StructType\HotelRef[]|null
     */
    public function getHotelRef()
    {
        return $this->HotelRef;
    }
    /**
     * This method is responsible for validating the values passed to the setHotelRef method
     * This method is willingly generated in order to preserve the one-line inline validation within the setHotelRef method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateHotelRefForArrayConstraintsFromSetHotelRef(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $itemSearchCriterionTypeHotelRefItem) {
            // validation for constraint: itemType
            if (!$itemSearchCriterionTypeHotelRefItem instanceof \StructType\HotelRef) {
                $invalidValues[] = is_object($itemSearchCriterionTypeHotelRefItem) ? get_class($itemSearchCriterionTypeHotelRefItem) : sprintf('%s(%s)', gettype($itemSearchCriterionTypeHotelRefItem), var_export($itemSearchCriterionTypeHotelRefItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The HotelRef property can only contain items of type \StructType\HotelRef, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set HotelRef value
     * @throws \InvalidArgumentException
     * @param \StructType\HotelRef[] $hotelRef
     * @return \StructType\ItemSearchCriterionType
     */
    public function setHotelRef(array $hotelRef = array())
    {
        // validation for constraint: array
        if ('' !== ($hotelRefArrayErrorMessage = self::validateHotelRefForArrayConstraintsFromSetHotelRef($hotelRef))) {
            throw new \InvalidArgumentException($hotelRefArrayErrorMessage, __LINE__);
        }
        $this->HotelRef = $hotelRef;
        return $this;
    }
    /**
     * Add item to HotelRef value
     * @throws \InvalidArgumentException
     * @param \StructType\HotelRef $item
     * @return \StructType\ItemSearchCriterionType
     */
    public function addToHotelRef(\StructType\HotelRef $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\HotelRef) {
            throw new \InvalidArgumentException(sprintf('The HotelRef property can only contain items of type \StructType\HotelRef, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->HotelRef[] = $item;
        return $this;
    }
    /**
     * Get ExactMatch value
     * @return bool|null
     */
    public function getExactMatch()
    {
        return $this->ExactMatch;
    }
    /**
     * Set ExactMatch value
     * @param bool $exactMatch
     * @return \StructType\ItemSearchCriterionType
     */
    public function setExactMatch($exactMatch = null)
    {
        // validation for constraint: boolean
        if (!is_null($exactMatch) && !is_bool($exactMatch)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($exactMatch, true), gettype($exactMatch)), __LINE__);
        }
        $this->ExactMatch = $exactMatch;
        return $this;
    }
}
