<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Hotel ServiceType
 * @subpackage Services
 */
class Hotel extends AbstractSoapClientBase
{
    /**
     * Sets the Security SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param Security $security
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderSecurity(Security $security, $nameSpace = 'http://tempuri.org/', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'Security', $security, $mustUnderstand, $actor);
    }
    /**
     * Method to call the operation originally named HotelAvailNotifRQ
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Security
     * - SOAPHeaderNamespaces: http://tempuri.org/
     * - SOAPHeaderTypes: Security
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\OTA_HotelAvailNotifRQ $oTA_HotelAvailNotifRQ
     * @return \StructType\OTA_HotelAvailNotifRS|bool
     */
    public function HotelAvailNotifRQ(\StructType\OTA_HotelAvailNotifRQ $oTA_HotelAvailNotifRQ)
    {
        try {
            $this->setResult($this->getSoapClient()->HotelAvailNotifRQ($oTA_HotelAvailNotifRQ));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named HotelAvailRQ
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Security
     * - SOAPHeaderNamespaces: http://tempuri.org/
     * - SOAPHeaderTypes: Security
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\OTA_HotelAvailRQ $oTA_HotelAvailRQ
     * @return \StructType\OTA_HotelAvailRS|bool
     */
    public function HotelAvailRQ(\StructType\OTA_HotelAvailRQ $oTA_HotelAvailRQ)
    {
        try {
            $this->setResult($this->getSoapClient()->HotelAvailRQ($oTA_HotelAvailRQ));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named HotelRatePlanNotifRQ
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Security
     * - SOAPHeaderNamespaces: http://tempuri.org/
     * - SOAPHeaderTypes: Security
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\OTA_HotelRatePlanNotifRQ $oTA_HotelRatePlanNotifRQ
     * @return \StructType\OTA_HotelRatePlanNotifRS|bool
     */
    public function HotelRatePlanNotifRQ(\StructType\OTA_HotelRatePlanNotifRQ $oTA_HotelRatePlanNotifRQ)
    {
        try {
            $this->setResult($this->getSoapClient()->HotelRatePlanNotifRQ($oTA_HotelRatePlanNotifRQ));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named HotelRateAmountNotifRQ
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Security
     * - SOAPHeaderNamespaces: http://tempuri.org/
     * - SOAPHeaderTypes: Security
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\OTA_HotelRateAmountNotifRQ $oTA_HotelRateAmountNotifRQ
     * @return \StructType\MessageAcknowledgementType|bool
     */
    public function HotelRateAmountNotifRQ(\StructType\OTA_HotelRateAmountNotifRQ $oTA_HotelRateAmountNotifRQ)
    {
        try {
            $this->setResult($this->getSoapClient()->HotelRateAmountNotifRQ($oTA_HotelRateAmountNotifRQ));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named HotelReadReservationRQ
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Security
     * - SOAPHeaderNamespaces: http://tempuri.org/
     * - SOAPHeaderTypes: Security
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\OTA_ReadRQ $oTA_ReadRQ
     * @return \StructType\OTA_ResRetrieveRS|bool
     */
    public function HotelReadReservationRQ(\StructType\OTA_ReadRQ $oTA_ReadRQ)
    {
        try {
            $this->setResult($this->getSoapClient()->HotelReadReservationRQ($oTA_ReadRQ));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named HotelInvNotifRQ
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Security
     * - SOAPHeaderNamespaces: http://tempuri.org/
     * - SOAPHeaderTypes: Security
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\OTA_HotelInvNotifRQ $oTA_HotelInvNotifRQ
     * @return \StructType\OTA_HotelInvNotifRS|bool
     */
    public function HotelInvNotifRQ(\StructType\OTA_HotelInvNotifRQ $oTA_HotelInvNotifRQ)
    {
        try {
            $this->setResult($this->getSoapClient()->HotelInvNotifRQ($oTA_HotelInvNotifRQ));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named HotelDescriptiveInfoRQ
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Security
     * - SOAPHeaderNamespaces: http://tempuri.org/
     * - SOAPHeaderTypes: Security
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\OTA_HotelDescriptiveInfoRQ $oTA_HotelDescriptiveInfoRQ
     * @return \StructType\OTA_HotelDescriptiveInfoRS|bool
     */
    public function HotelDescriptiveInfoRQ(\StructType\OTA_HotelDescriptiveInfoRQ $oTA_HotelDescriptiveInfoRQ)
    {
        try {
            $this->setResult($this->getSoapClient()->HotelDescriptiveInfoRQ($oTA_HotelDescriptiveInfoRQ));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named HotelResNotifRQ
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Security
     * - SOAPHeaderNamespaces: http://tempuri.org/
     * - SOAPHeaderTypes: Security
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\OTA_HotelResNotifRQ $oTA_HotelResNotifRQ
     * @return \StructType\OTA_HotelResNotifRS|bool
     */
    public function HotelResNotifRQ(\StructType\OTA_HotelResNotifRQ $oTA_HotelResNotifRQ)
    {
        try {
            $this->setResult($this->getSoapClient()->HotelResNotifRQ($oTA_HotelResNotifRQ));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named HotelInvBlockNotifRQ
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Security
     * - SOAPHeaderNamespaces: http://tempuri.org/
     * - SOAPHeaderTypes: Security
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\OTA_HotelInvBlockNotifRQ $oTA_HotelInvBlockNotifRQ
     * @return \StructType\OTA_HotelInvBlockNotifRS|bool
     */
    public function HotelInvBlockNotifRQ(\StructType\OTA_HotelInvBlockNotifRQ $oTA_HotelInvBlockNotifRQ)
    {
        try {
            $this->setResult($this->getSoapClient()->HotelInvBlockNotifRQ($oTA_HotelInvBlockNotifRQ));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named HotelInvCountNotifRQ
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Security
     * - SOAPHeaderNamespaces: http://tempuri.org/
     * - SOAPHeaderTypes: Security
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\OTA_HotelInvCountNotifRQ $oTA_HotelInvCountNotifRQ
     * @return \StructType\OTA_HotelInvCountNotifRS|bool
     */
    public function HotelInvCountNotifRQ(\StructType\OTA_HotelInvCountNotifRQ $oTA_HotelInvCountNotifRQ)
    {
        try {
            $this->setResult($this->getSoapClient()->HotelInvCountNotifRQ($oTA_HotelInvCountNotifRQ));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named HotelRatePlanRQ
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Security
     * - SOAPHeaderNamespaces: http://tempuri.org/
     * - SOAPHeaderTypes: Security
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\OTA_HotelRatePlanRQ $oTA_HotelRatePlanRQ
     * @return \StructType\OTA_HotelRatePlanRS|bool
     */
    public function HotelRatePlanRQ(\StructType\OTA_HotelRatePlanRQ $oTA_HotelRatePlanRQ)
    {
        try {
            $this->setResult($this->getSoapClient()->HotelRatePlanRQ($oTA_HotelRatePlanRQ));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\MessageAcknowledgementType|\StructType\OTA_HotelAvailNotifRS|\StructType\OTA_HotelAvailRS|\StructType\OTA_HotelDescriptiveInfoRS|\StructType\OTA_HotelInvBlockNotifRS|\StructType\OTA_HotelInvCountNotifRS|\StructType\OTA_HotelInvNotifRS|\StructType\OTA_HotelRatePlanNotifRS|\StructType\OTA_HotelRatePlanRS|\StructType\OTA_HotelResNotifRS|\StructType\OTA_ResRetrieveRS
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
