<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RatePlanLevelFee StructType
 * @subpackage Structs
 */
class RatePlanLevelFee extends AbstractStructBase
{
    /**
     * The Fee
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Fee[]
     */
    public $Fee;
    /**
     * The Code
     * @var string
     */
    public $Code;
    /**
     * The CodeContext
     * @var string
     */
    public $CodeContext;
    /**
     * The Quantity
     * @var int
     */
    public $Quantity;
    /**
     * The URI
     * @var string
     */
    public $URI;
    /**
     * Constructor method for RatePlanLevelFee
     * @uses RatePlanLevelFee::setFee()
     * @uses RatePlanLevelFee::setCode()
     * @uses RatePlanLevelFee::setCodeContext()
     * @uses RatePlanLevelFee::setQuantity()
     * @uses RatePlanLevelFee::setURI()
     * @param \StructType\Fee[] $fee
     * @param string $code
     * @param string $codeContext
     * @param int $quantity
     * @param string $uRI
     */
    public function __construct(array $fee = array(), $code = null, $codeContext = null, $quantity = null, $uRI = null)
    {
        $this
            ->setFee($fee)
            ->setCode($code)
            ->setCodeContext($codeContext)
            ->setQuantity($quantity)
            ->setURI($uRI);
    }
    /**
     * Get Fee value
     * @return \StructType\Fee[]|null
     */
    public function getFee()
    {
        return $this->Fee;
    }
    /**
     * This method is responsible for validating the values passed to the setFee method
     * This method is willingly generated in order to preserve the one-line inline validation within the setFee method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateFeeForArrayConstraintsFromSetFee(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $ratePlanLevelFeeFeeItem) {
            // validation for constraint: itemType
            if (!$ratePlanLevelFeeFeeItem instanceof \StructType\Fee) {
                $invalidValues[] = is_object($ratePlanLevelFeeFeeItem) ? get_class($ratePlanLevelFeeFeeItem) : sprintf('%s(%s)', gettype($ratePlanLevelFeeFeeItem), var_export($ratePlanLevelFeeFeeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Fee property can only contain items of type \StructType\Fee, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Fee value
     * @throws \InvalidArgumentException
     * @param \StructType\Fee[] $fee
     * @return \StructType\RatePlanLevelFee
     */
    public function setFee(array $fee = array())
    {
        // validation for constraint: array
        if ('' !== ($feeArrayErrorMessage = self::validateFeeForArrayConstraintsFromSetFee($fee))) {
            throw new \InvalidArgumentException($feeArrayErrorMessage, __LINE__);
        }
        $this->Fee = $fee;
        return $this;
    }
    /**
     * Add item to Fee value
     * @throws \InvalidArgumentException
     * @param \StructType\Fee $item
     * @return \StructType\RatePlanLevelFee
     */
    public function addToFee(\StructType\Fee $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Fee) {
            throw new \InvalidArgumentException(sprintf('The Fee property can only contain items of type \StructType\Fee, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Fee[] = $item;
        return $this;
    }
    /**
     * Get Code value
     * @return string|null
     */
    public function getCode()
    {
        return $this->Code;
    }
    /**
     * Set Code value
     * @param string $code
     * @return \StructType\RatePlanLevelFee
     */
    public function setCode($code = null)
    {
        // validation for constraint: string
        if (!is_null($code) && !is_string($code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($code, true), gettype($code)), __LINE__);
        }
        $this->Code = $code;
        return $this;
    }
    /**
     * Get CodeContext value
     * @return string|null
     */
    public function getCodeContext()
    {
        return $this->CodeContext;
    }
    /**
     * Set CodeContext value
     * @param string $codeContext
     * @return \StructType\RatePlanLevelFee
     */
    public function setCodeContext($codeContext = null)
    {
        // validation for constraint: string
        if (!is_null($codeContext) && !is_string($codeContext)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($codeContext, true), gettype($codeContext)), __LINE__);
        }
        $this->CodeContext = $codeContext;
        return $this;
    }
    /**
     * Get Quantity value
     * @return int|null
     */
    public function getQuantity()
    {
        return $this->Quantity;
    }
    /**
     * Set Quantity value
     * @param int $quantity
     * @return \StructType\RatePlanLevelFee
     */
    public function setQuantity($quantity = null)
    {
        // validation for constraint: int
        if (!is_null($quantity) && !(is_int($quantity) || ctype_digit($quantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($quantity, true), gettype($quantity)), __LINE__);
        }
        $this->Quantity = $quantity;
        return $this;
    }
    /**
     * Get URI value
     * @return string|null
     */
    public function getURI()
    {
        return $this->URI;
    }
    /**
     * Set URI value
     * @param string $uRI
     * @return \StructType\RatePlanLevelFee
     */
    public function setURI($uRI = null)
    {
        // validation for constraint: string
        if (!is_null($uRI) && !is_string($uRI)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uRI, true), gettype($uRI)), __LINE__);
        }
        $this->URI = $uRI;
        return $this;
    }
}
