<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Quantities StructType
 * @subpackage Structs
 */
class Quantities extends AbstractStructBase
{
    /**
     * The MaximumAdditionalGuests
     * @var int
     */
    public $MaximumAdditionalGuests;
    /**
     * Constructor method for Quantities
     * @uses Quantities::setMaximumAdditionalGuests()
     * @param int $maximumAdditionalGuests
     */
    public function __construct($maximumAdditionalGuests = null)
    {
        $this
            ->setMaximumAdditionalGuests($maximumAdditionalGuests);
    }
    /**
     * Get MaximumAdditionalGuests value
     * @return int|null
     */
    public function getMaximumAdditionalGuests()
    {
        return $this->MaximumAdditionalGuests;
    }
    /**
     * Set MaximumAdditionalGuests value
     * @param int $maximumAdditionalGuests
     * @return \StructType\Quantities
     */
    public function setMaximumAdditionalGuests($maximumAdditionalGuests = null)
    {
        // validation for constraint: int
        if (!is_null($maximumAdditionalGuests) && !(is_int($maximumAdditionalGuests) || ctype_digit($maximumAdditionalGuests))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($maximumAdditionalGuests, true), gettype($maximumAdditionalGuests)), __LINE__);
        }
        $this->MaximumAdditionalGuests = $maximumAdditionalGuests;
        return $this;
    }
}
