<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for InvBlockCutoff StructType
 * @subpackage Structs
 */
class InvBlockCutoff extends AbstractStructBase
{
    /**
     * The AbsoluteCutoff
     * @var string
     */
    public $AbsoluteCutoff;
    /**
     * The OffsetDuration
     * @var string
     */
    public $OffsetDuration;
    /**
     * The OffsetCalculationMode
     * @var string
     */
    public $OffsetCalculationMode;
    /**
     * Constructor method for InvBlockCutoff
     * @uses InvBlockCutoff::setAbsoluteCutoff()
     * @uses InvBlockCutoff::setOffsetDuration()
     * @uses InvBlockCutoff::setOffsetCalculationMode()
     * @param string $absoluteCutoff
     * @param string $offsetDuration
     * @param string $offsetCalculationMode
     */
    public function __construct($absoluteCutoff = null, $offsetDuration = null, $offsetCalculationMode = null)
    {
        $this
            ->setAbsoluteCutoff($absoluteCutoff)
            ->setOffsetDuration($offsetDuration)
            ->setOffsetCalculationMode($offsetCalculationMode);
    }
    /**
     * Get AbsoluteCutoff value
     * @return string|null
     */
    public function getAbsoluteCutoff()
    {
        return $this->AbsoluteCutoff;
    }
    /**
     * Set AbsoluteCutoff value
     * @param string $absoluteCutoff
     * @return \StructType\InvBlockCutoff
     */
    public function setAbsoluteCutoff($absoluteCutoff = null)
    {
        // validation for constraint: string
        if (!is_null($absoluteCutoff) && !is_string($absoluteCutoff)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($absoluteCutoff, true), gettype($absoluteCutoff)), __LINE__);
        }
        $this->AbsoluteCutoff = $absoluteCutoff;
        return $this;
    }
    /**
     * Get OffsetDuration value
     * @return string|null
     */
    public function getOffsetDuration()
    {
        return $this->OffsetDuration;
    }
    /**
     * Set OffsetDuration value
     * @param string $offsetDuration
     * @return \StructType\InvBlockCutoff
     */
    public function setOffsetDuration($offsetDuration = null)
    {
        // validation for constraint: string
        if (!is_null($offsetDuration) && !is_string($offsetDuration)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($offsetDuration, true), gettype($offsetDuration)), __LINE__);
        }
        $this->OffsetDuration = $offsetDuration;
        return $this;
    }
    /**
     * Get OffsetCalculationMode value
     * @return string|null
     */
    public function getOffsetCalculationMode()
    {
        return $this->OffsetCalculationMode;
    }
    /**
     * Set OffsetCalculationMode value
     * @param string $offsetCalculationMode
     * @return \StructType\InvBlockCutoff
     */
    public function setOffsetCalculationMode($offsetCalculationMode = null)
    {
        // validation for constraint: string
        if (!is_null($offsetCalculationMode) && !is_string($offsetCalculationMode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($offsetCalculationMode, true), gettype($offsetCalculationMode)), __LINE__);
        }
        $this->OffsetCalculationMode = $offsetCalculationMode;
        return $this;
    }
}
