<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for HotelSearchCriterionType StructType
 * @subpackage Structs
 */
class HotelSearchCriterionType extends ItemSearchCriterionType
{
    /**
     * The RateRange
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\RateRange[]
     */
    public $RateRange;
    /**
     * The StayDateRange
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\DateTimeSpanType
     */
    public $StayDateRange;
    /**
     * The RoomStayCandidates
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfHotelSearchCriterionTypeRoomStayCandidate
     */
    public $RoomStayCandidates;
    /**
     * The Address
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Address
     */
    public $Address;
    /**
     * Constructor method for HotelSearchCriterionType
     * @uses HotelSearchCriterionType::setRateRange()
     * @uses HotelSearchCriterionType::setStayDateRange()
     * @uses HotelSearchCriterionType::setRoomStayCandidates()
     * @uses HotelSearchCriterionType::setAddress()
     * @param \StructType\RateRange[] $rateRange
     * @param \StructType\DateTimeSpanType $stayDateRange
     * @param \ArrayType\ArrayOfHotelSearchCriterionTypeRoomStayCandidate $roomStayCandidates
     * @param \StructType\Address $address
     */
    public function __construct(array $rateRange = array(), \StructType\DateTimeSpanType $stayDateRange = null, \ArrayType\ArrayOfHotelSearchCriterionTypeRoomStayCandidate $roomStayCandidates = null, \StructType\Address $address = null)
    {
        $this
            ->setRateRange($rateRange)
            ->setStayDateRange($stayDateRange)
            ->setRoomStayCandidates($roomStayCandidates)
            ->setAddress($address);
    }
    /**
     * Get RateRange value
     * @return \StructType\RateRange[]|null
     */
    public function getRateRange()
    {
        return $this->RateRange;
    }
    /**
     * This method is responsible for validating the values passed to the setRateRange method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRateRange method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRateRangeForArrayConstraintsFromSetRateRange(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $hotelSearchCriterionTypeRateRangeItem) {
            // validation for constraint: itemType
            if (!$hotelSearchCriterionTypeRateRangeItem instanceof \StructType\RateRange) {
                $invalidValues[] = is_object($hotelSearchCriterionTypeRateRangeItem) ? get_class($hotelSearchCriterionTypeRateRangeItem) : sprintf('%s(%s)', gettype($hotelSearchCriterionTypeRateRangeItem), var_export($hotelSearchCriterionTypeRateRangeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The RateRange property can only contain items of type \StructType\RateRange, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set RateRange value
     * @throws \InvalidArgumentException
     * @param \StructType\RateRange[] $rateRange
     * @return \StructType\HotelSearchCriterionType
     */
    public function setRateRange(array $rateRange = array())
    {
        // validation for constraint: array
        if ('' !== ($rateRangeArrayErrorMessage = self::validateRateRangeForArrayConstraintsFromSetRateRange($rateRange))) {
            throw new \InvalidArgumentException($rateRangeArrayErrorMessage, __LINE__);
        }
        $this->RateRange = $rateRange;
        return $this;
    }
    /**
     * Add item to RateRange value
     * @throws \InvalidArgumentException
     * @param \StructType\RateRange $item
     * @return \StructType\HotelSearchCriterionType
     */
    public function addToRateRange(\StructType\RateRange $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\RateRange) {
            throw new \InvalidArgumentException(sprintf('The RateRange property can only contain items of type \StructType\RateRange, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->RateRange[] = $item;
        return $this;
    }
    /**
     * Get StayDateRange value
     * @return \StructType\DateTimeSpanType|null
     */
    public function getStayDateRange()
    {
        return $this->StayDateRange;
    }
    /**
     * Set StayDateRange value
     * @param \StructType\DateTimeSpanType $stayDateRange
     * @return \StructType\HotelSearchCriterionType
     */
    public function setStayDateRange(\StructType\DateTimeSpanType $stayDateRange = null)
    {
        $this->StayDateRange = $stayDateRange;
        return $this;
    }
    /**
     * Get RoomStayCandidates value
     * @return \ArrayType\ArrayOfHotelSearchCriterionTypeRoomStayCandidate|null
     */
    public function getRoomStayCandidates()
    {
        return $this->RoomStayCandidates;
    }
    /**
     * Set RoomStayCandidates value
     * @param \ArrayType\ArrayOfHotelSearchCriterionTypeRoomStayCandidate $roomStayCandidates
     * @return \StructType\HotelSearchCriterionType
     */
    public function setRoomStayCandidates(\ArrayType\ArrayOfHotelSearchCriterionTypeRoomStayCandidate $roomStayCandidates = null)
    {
        $this->RoomStayCandidates = $roomStayCandidates;
        return $this;
    }
    /**
     * Get Address value
     * @return \StructType\Address|null
     */
    public function getAddress()
    {
        return $this->Address;
    }
    /**
     * Set Address value
     * @param \StructType\Address $address
     * @return \StructType\HotelSearchCriterionType
     */
    public function setAddress(\StructType\Address $address = null)
    {
        $this->Address = $address;
        return $this;
    }
}
