<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OTA_HotelRatePlanNotifRS StructType
 * @subpackage Structs
 */
class OTA_HotelRatePlanNotifRS extends AbstractStructBase
{
    /**
     * The Errors
     * Meta information extracted from the WSDL
     * - choice: Errors | RatePlanCrossRefs | Success | Warnings
     * - choiceMaxOccurs: unbounded
     * - choiceMinOccurs: 0
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ErrorsType
     */
    public $Errors;
    /**
     * The RatePlanCrossRefs
     * Meta information extracted from the WSDL
     * - choice: Errors | RatePlanCrossRefs | Success | Warnings
     * - choiceMaxOccurs: unbounded
     * - choiceMinOccurs: 0
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\RatePlanCrossRefs
     */
    public $RatePlanCrossRefs;
    /**
     * The Success
     * Meta information extracted from the WSDL
     * - choice: Errors | RatePlanCrossRefs | Success | Warnings
     * - choiceMaxOccurs: unbounded
     * - choiceMinOccurs: 0
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\SuccessType
     */
    public $Success;
    /**
     * The Warnings
     * Meta information extracted from the WSDL
     * - choice: Errors | RatePlanCrossRefs | Success | Warnings
     * - choiceMaxOccurs: unbounded
     * - choiceMinOccurs: 0
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\WarningsType
     */
    public $Warnings;
    /**
     * The EchoToken
     * @var string
     */
    public $EchoToken;
    /**
     * The TimeStamp
     * @var string
     */
    public $TimeStamp;
    /**
     * The Target
     * @var string
     */
    public $Target;
    /**
     * The TargetName
     * @var string
     */
    public $TargetName;
    /**
     * The Version
     * @var string
     */
    public $Version;
    /**
     * The TransactionIdentifier
     * @var string
     */
    public $TransactionIdentifier;
    /**
     * The SequenceNmbr
     * @var int
     */
    public $SequenceNmbr;
    /**
     * The TransactionStatusCode
     * @var string
     */
    public $TransactionStatusCode;
    /**
     * The RetransmissionIndicator
     * @var bool
     */
    public $RetransmissionIndicator;
    /**
     * The CorrelationID
     * @var string
     */
    public $CorrelationID;
    /**
     * The PrimaryLangID
     * @var string
     */
    public $PrimaryLangID;
    /**
     * The AltLangID
     * @var string
     */
    public $AltLangID;
    /**
     * Constructor method for OTA_HotelRatePlanNotifRS
     * @uses OTA_HotelRatePlanNotifRS::setErrors()
     * @uses OTA_HotelRatePlanNotifRS::setRatePlanCrossRefs()
     * @uses OTA_HotelRatePlanNotifRS::setSuccess()
     * @uses OTA_HotelRatePlanNotifRS::setWarnings()
     * @uses OTA_HotelRatePlanNotifRS::setEchoToken()
     * @uses OTA_HotelRatePlanNotifRS::setTimeStamp()
     * @uses OTA_HotelRatePlanNotifRS::setTarget()
     * @uses OTA_HotelRatePlanNotifRS::setTargetName()
     * @uses OTA_HotelRatePlanNotifRS::setVersion()
     * @uses OTA_HotelRatePlanNotifRS::setTransactionIdentifier()
     * @uses OTA_HotelRatePlanNotifRS::setSequenceNmbr()
     * @uses OTA_HotelRatePlanNotifRS::setTransactionStatusCode()
     * @uses OTA_HotelRatePlanNotifRS::setRetransmissionIndicator()
     * @uses OTA_HotelRatePlanNotifRS::setCorrelationID()
     * @uses OTA_HotelRatePlanNotifRS::setPrimaryLangID()
     * @uses OTA_HotelRatePlanNotifRS::setAltLangID()
     * @param \StructType\ErrorsType $errors
     * @param \StructType\RatePlanCrossRefs $ratePlanCrossRefs
     * @param \StructType\SuccessType $success
     * @param \StructType\WarningsType $warnings
     * @param string $echoToken
     * @param string $timeStamp
     * @param string $target
     * @param string $targetName
     * @param string $version
     * @param string $transactionIdentifier
     * @param int $sequenceNmbr
     * @param string $transactionStatusCode
     * @param bool $retransmissionIndicator
     * @param string $correlationID
     * @param string $primaryLangID
     * @param string $altLangID
     */
    public function __construct(\StructType\ErrorsType $errors = null, \StructType\RatePlanCrossRefs $ratePlanCrossRefs = null, \StructType\SuccessType $success = null, \StructType\WarningsType $warnings = null, $echoToken = null, $timeStamp = null, $target = null, $targetName = null, $version = null, $transactionIdentifier = null, $sequenceNmbr = null, $transactionStatusCode = null, $retransmissionIndicator = null, $correlationID = null, $primaryLangID = null, $altLangID = null)
    {
        $this
            ->setErrors($errors)
            ->setRatePlanCrossRefs($ratePlanCrossRefs)
            ->setSuccess($success)
            ->setWarnings($warnings)
            ->setEchoToken($echoToken)
            ->setTimeStamp($timeStamp)
            ->setTarget($target)
            ->setTargetName($targetName)
            ->setVersion($version)
            ->setTransactionIdentifier($transactionIdentifier)
            ->setSequenceNmbr($sequenceNmbr)
            ->setTransactionStatusCode($transactionStatusCode)
            ->setRetransmissionIndicator($retransmissionIndicator)
            ->setCorrelationID($correlationID)
            ->setPrimaryLangID($primaryLangID)
            ->setAltLangID($altLangID);
    }
    /**
     * Get Errors value
     * @return \StructType\ErrorsType|null
     */
    public function getErrors()
    {
        return isset($this->Errors) ? $this->Errors : null;
    }
    /**
     * This method is responsible for validating the value passed to the setErrors method
     * This method is willingly generated in order to preserve the one-line inline validation within the setErrors method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateErrorsForChoiceConstraintsFromSetErrors($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'RatePlanCrossRefs',
            'Success',
            'Warnings',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property Errors can\'t be set as the property %s is already set. Only one property must be set among these properties: Errors, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set Errors value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\ErrorsType $errors
     * @return \StructType\OTA_HotelRatePlanNotifRS
     */
    public function setErrors(\StructType\ErrorsType $errors = null)
    {
        // validation for constraint: choice(Errors, RatePlanCrossRefs, Success, Warnings)
        if ('' !== ($errorsChoiceErrorMessage = self::validateErrorsForChoiceConstraintsFromSetErrors($errors))) {
            throw new \InvalidArgumentException($errorsChoiceErrorMessage, __LINE__);
        }
        if (is_null($errors) || (is_array($errors) && empty($errors))) {
            unset($this->Errors);
        } else {
            $this->Errors = $errors;
        }
        return $this;
    }
    /**
     * Get RatePlanCrossRefs value
     * @return \StructType\RatePlanCrossRefs|null
     */
    public function getRatePlanCrossRefs()
    {
        return isset($this->RatePlanCrossRefs) ? $this->RatePlanCrossRefs : null;
    }
    /**
     * This method is responsible for validating the value passed to the setRatePlanCrossRefs method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRatePlanCrossRefs method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateRatePlanCrossRefsForChoiceConstraintsFromSetRatePlanCrossRefs($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'Errors',
            'Success',
            'Warnings',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property RatePlanCrossRefs can\'t be set as the property %s is already set. Only one property must be set among these properties: RatePlanCrossRefs, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set RatePlanCrossRefs value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\RatePlanCrossRefs $ratePlanCrossRefs
     * @return \StructType\OTA_HotelRatePlanNotifRS
     */
    public function setRatePlanCrossRefs(\StructType\RatePlanCrossRefs $ratePlanCrossRefs = null)
    {
        // validation for constraint: choice(Errors, RatePlanCrossRefs, Success, Warnings)
        if ('' !== ($ratePlanCrossRefsChoiceErrorMessage = self::validateRatePlanCrossRefsForChoiceConstraintsFromSetRatePlanCrossRefs($ratePlanCrossRefs))) {
            throw new \InvalidArgumentException($ratePlanCrossRefsChoiceErrorMessage, __LINE__);
        }
        if (is_null($ratePlanCrossRefs) || (is_array($ratePlanCrossRefs) && empty($ratePlanCrossRefs))) {
            unset($this->RatePlanCrossRefs);
        } else {
            $this->RatePlanCrossRefs = $ratePlanCrossRefs;
        }
        return $this;
    }
    /**
     * Get Success value
     * @return \StructType\SuccessType|null
     */
    public function getSuccess()
    {
        return isset($this->Success) ? $this->Success : null;
    }
    /**
     * This method is responsible for validating the value passed to the setSuccess method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSuccess method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateSuccessForChoiceConstraintsFromSetSuccess($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'Errors',
            'RatePlanCrossRefs',
            'Warnings',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property Success can\'t be set as the property %s is already set. Only one property must be set among these properties: Success, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set Success value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\SuccessType $success
     * @return \StructType\OTA_HotelRatePlanNotifRS
     */
    public function setSuccess(\StructType\SuccessType $success = null)
    {
        // validation for constraint: choice(Errors, RatePlanCrossRefs, Success, Warnings)
        if ('' !== ($successChoiceErrorMessage = self::validateSuccessForChoiceConstraintsFromSetSuccess($success))) {
            throw new \InvalidArgumentException($successChoiceErrorMessage, __LINE__);
        }
        if (is_null($success) || (is_array($success) && empty($success))) {
            unset($this->Success);
        } else {
            $this->Success = $success;
        }
        return $this;
    }
    /**
     * Get Warnings value
     * @return \StructType\WarningsType|null
     */
    public function getWarnings()
    {
        return isset($this->Warnings) ? $this->Warnings : null;
    }
    /**
     * This method is responsible for validating the value passed to the setWarnings method
     * This method is willingly generated in order to preserve the one-line inline validation within the setWarnings method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateWarningsForChoiceConstraintsFromSetWarnings($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'Errors',
            'RatePlanCrossRefs',
            'Success',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property Warnings can\'t be set as the property %s is already set. Only one property must be set among these properties: Warnings, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set Warnings value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\WarningsType $warnings
     * @return \StructType\OTA_HotelRatePlanNotifRS
     */
    public function setWarnings(\StructType\WarningsType $warnings = null)
    {
        // validation for constraint: choice(Errors, RatePlanCrossRefs, Success, Warnings)
        if ('' !== ($warningsChoiceErrorMessage = self::validateWarningsForChoiceConstraintsFromSetWarnings($warnings))) {
            throw new \InvalidArgumentException($warningsChoiceErrorMessage, __LINE__);
        }
        if (is_null($warnings) || (is_array($warnings) && empty($warnings))) {
            unset($this->Warnings);
        } else {
            $this->Warnings = $warnings;
        }
        return $this;
    }
    /**
     * Get EchoToken value
     * @return string|null
     */
    public function getEchoToken()
    {
        return $this->EchoToken;
    }
    /**
     * Set EchoToken value
     * @param string $echoToken
     * @return \StructType\OTA_HotelRatePlanNotifRS
     */
    public function setEchoToken($echoToken = null)
    {
        // validation for constraint: string
        if (!is_null($echoToken) && !is_string($echoToken)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($echoToken, true), gettype($echoToken)), __LINE__);
        }
        $this->EchoToken = $echoToken;
        return $this;
    }
    /**
     * Get TimeStamp value
     * @return string|null
     */
    public function getTimeStamp()
    {
        return $this->TimeStamp;
    }
    /**
     * Set TimeStamp value
     * @param string $timeStamp
     * @return \StructType\OTA_HotelRatePlanNotifRS
     */
    public function setTimeStamp($timeStamp = null)
    {
        // validation for constraint: string
        if (!is_null($timeStamp) && !is_string($timeStamp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($timeStamp, true), gettype($timeStamp)), __LINE__);
        }
        $this->TimeStamp = $timeStamp;
        return $this;
    }
    /**
     * Get Target value
     * @return string|null
     */
    public function getTarget()
    {
        return $this->Target;
    }
    /**
     * Set Target value
     * @param string $target
     * @return \StructType\OTA_HotelRatePlanNotifRS
     */
    public function setTarget($target = null)
    {
        // validation for constraint: string
        if (!is_null($target) && !is_string($target)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($target, true), gettype($target)), __LINE__);
        }
        $this->Target = $target;
        return $this;
    }
    /**
     * Get TargetName value
     * @return string|null
     */
    public function getTargetName()
    {
        return $this->TargetName;
    }
    /**
     * Set TargetName value
     * @param string $targetName
     * @return \StructType\OTA_HotelRatePlanNotifRS
     */
    public function setTargetName($targetName = null)
    {
        // validation for constraint: string
        if (!is_null($targetName) && !is_string($targetName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($targetName, true), gettype($targetName)), __LINE__);
        }
        $this->TargetName = $targetName;
        return $this;
    }
    /**
     * Get Version value
     * @return string|null
     */
    public function getVersion()
    {
        return $this->Version;
    }
    /**
     * Set Version value
     * @param string $version
     * @return \StructType\OTA_HotelRatePlanNotifRS
     */
    public function setVersion($version = null)
    {
        // validation for constraint: string
        if (!is_null($version) && !is_string($version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($version, true), gettype($version)), __LINE__);
        }
        $this->Version = $version;
        return $this;
    }
    /**
     * Get TransactionIdentifier value
     * @return string|null
     */
    public function getTransactionIdentifier()
    {
        return $this->TransactionIdentifier;
    }
    /**
     * Set TransactionIdentifier value
     * @param string $transactionIdentifier
     * @return \StructType\OTA_HotelRatePlanNotifRS
     */
    public function setTransactionIdentifier($transactionIdentifier = null)
    {
        // validation for constraint: string
        if (!is_null($transactionIdentifier) && !is_string($transactionIdentifier)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transactionIdentifier, true), gettype($transactionIdentifier)), __LINE__);
        }
        $this->TransactionIdentifier = $transactionIdentifier;
        return $this;
    }
    /**
     * Get SequenceNmbr value
     * @return int|null
     */
    public function getSequenceNmbr()
    {
        return $this->SequenceNmbr;
    }
    /**
     * Set SequenceNmbr value
     * @param int $sequenceNmbr
     * @return \StructType\OTA_HotelRatePlanNotifRS
     */
    public function setSequenceNmbr($sequenceNmbr = null)
    {
        // validation for constraint: int
        if (!is_null($sequenceNmbr) && !(is_int($sequenceNmbr) || ctype_digit($sequenceNmbr))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($sequenceNmbr, true), gettype($sequenceNmbr)), __LINE__);
        }
        $this->SequenceNmbr = $sequenceNmbr;
        return $this;
    }
    /**
     * Get TransactionStatusCode value
     * @return string|null
     */
    public function getTransactionStatusCode()
    {
        return $this->TransactionStatusCode;
    }
    /**
     * Set TransactionStatusCode value
     * @param string $transactionStatusCode
     * @return \StructType\OTA_HotelRatePlanNotifRS
     */
    public function setTransactionStatusCode($transactionStatusCode = null)
    {
        // validation for constraint: string
        if (!is_null($transactionStatusCode) && !is_string($transactionStatusCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transactionStatusCode, true), gettype($transactionStatusCode)), __LINE__);
        }
        $this->TransactionStatusCode = $transactionStatusCode;
        return $this;
    }
    /**
     * Get RetransmissionIndicator value
     * @return bool|null
     */
    public function getRetransmissionIndicator()
    {
        return $this->RetransmissionIndicator;
    }
    /**
     * Set RetransmissionIndicator value
     * @param bool $retransmissionIndicator
     * @return \StructType\OTA_HotelRatePlanNotifRS
     */
    public function setRetransmissionIndicator($retransmissionIndicator = null)
    {
        // validation for constraint: boolean
        if (!is_null($retransmissionIndicator) && !is_bool($retransmissionIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($retransmissionIndicator, true), gettype($retransmissionIndicator)), __LINE__);
        }
        $this->RetransmissionIndicator = $retransmissionIndicator;
        return $this;
    }
    /**
     * Get CorrelationID value
     * @return string|null
     */
    public function getCorrelationID()
    {
        return $this->CorrelationID;
    }
    /**
     * Set CorrelationID value
     * @param string $correlationID
     * @return \StructType\OTA_HotelRatePlanNotifRS
     */
    public function setCorrelationID($correlationID = null)
    {
        // validation for constraint: string
        if (!is_null($correlationID) && !is_string($correlationID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($correlationID, true), gettype($correlationID)), __LINE__);
        }
        $this->CorrelationID = $correlationID;
        return $this;
    }
    /**
     * Get PrimaryLangID value
     * @return string|null
     */
    public function getPrimaryLangID()
    {
        return $this->PrimaryLangID;
    }
    /**
     * Set PrimaryLangID value
     * @param string $primaryLangID
     * @return \StructType\OTA_HotelRatePlanNotifRS
     */
    public function setPrimaryLangID($primaryLangID = null)
    {
        // validation for constraint: string
        if (!is_null($primaryLangID) && !is_string($primaryLangID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($primaryLangID, true), gettype($primaryLangID)), __LINE__);
        }
        $this->PrimaryLangID = $primaryLangID;
        return $this;
    }
    /**
     * Get AltLangID value
     * @return string|null
     */
    public function getAltLangID()
    {
        return $this->AltLangID;
    }
    /**
     * Set AltLangID value
     * @param string $altLangID
     * @return \StructType\OTA_HotelRatePlanNotifRS
     */
    public function setAltLangID($altLangID = null)
    {
        // validation for constraint: string
        if (!is_null($altLangID) && !is_string($altLangID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($altLangID, true), gettype($altLangID)), __LINE__);
        }
        $this->AltLangID = $altLangID;
        return $this;
    }
}
