<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfProfilesTypeProfileInfo ArrayType
 * @subpackage Arrays
 */
class ArrayOfProfilesTypeProfileInfo extends AbstractStructArrayBase
{
    /**
     * The ProfileInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\ProfileInfo[]
     */
    public $ProfileInfo;
    /**
     * Constructor method for ArrayOfProfilesTypeProfileInfo
     * @uses ArrayOfProfilesTypeProfileInfo::setProfileInfo()
     * @param \StructType\ProfileInfo[] $profileInfo
     */
    public function __construct(array $profileInfo = array())
    {
        $this
            ->setProfileInfo($profileInfo);
    }
    /**
     * Get ProfileInfo value
     * @return \StructType\ProfileInfo[]|null
     */
    public function getProfileInfo()
    {
        return $this->ProfileInfo;
    }
    /**
     * This method is responsible for validating the values passed to the setProfileInfo method
     * This method is willingly generated in order to preserve the one-line inline validation within the setProfileInfo method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateProfileInfoForArrayConstraintsFromSetProfileInfo(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfProfilesTypeProfileInfoProfileInfoItem) {
            // validation for constraint: itemType
            if (!$arrayOfProfilesTypeProfileInfoProfileInfoItem instanceof \StructType\ProfileInfo) {
                $invalidValues[] = is_object($arrayOfProfilesTypeProfileInfoProfileInfoItem) ? get_class($arrayOfProfilesTypeProfileInfoProfileInfoItem) : sprintf('%s(%s)', gettype($arrayOfProfilesTypeProfileInfoProfileInfoItem), var_export($arrayOfProfilesTypeProfileInfoProfileInfoItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ProfileInfo property can only contain items of type \StructType\ProfileInfo, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ProfileInfo value
     * @throws \InvalidArgumentException
     * @param \StructType\ProfileInfo[] $profileInfo
     * @return \ArrayType\ArrayOfProfilesTypeProfileInfo
     */
    public function setProfileInfo(array $profileInfo = array())
    {
        // validation for constraint: array
        if ('' !== ($profileInfoArrayErrorMessage = self::validateProfileInfoForArrayConstraintsFromSetProfileInfo($profileInfo))) {
            throw new \InvalidArgumentException($profileInfoArrayErrorMessage, __LINE__);
        }
        $this->ProfileInfo = $profileInfo;
        return $this;
    }
    /**
     * Add item to ProfileInfo value
     * @throws \InvalidArgumentException
     * @param \StructType\ProfileInfo $item
     * @return \ArrayType\ArrayOfProfilesTypeProfileInfo
     */
    public function addToProfileInfo(\StructType\ProfileInfo $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ProfileInfo) {
            throw new \InvalidArgumentException(sprintf('The ProfileInfo property can only contain items of type \StructType\ProfileInfo, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ProfileInfo[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\ProfileInfo|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\ProfileInfo|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\ProfileInfo|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\ProfileInfo|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\ProfileInfo|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string ProfileInfo
     */
    public function getAttributeName()
    {
        return 'ProfileInfo';
    }
}
