<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SignatureOnFile StructType
 * @subpackage Structs
 */
class SignatureOnFile extends AbstractStructBase
{
    /**
     * The SignatureOnFileInd
     * @var bool
     */
    public $SignatureOnFileInd;
    /**
     * The EffectiveDate
     * @var string
     */
    public $EffectiveDate;
    /**
     * The ExpireDate
     * @var string
     */
    public $ExpireDate;
    /**
     * The ExpireDateExclusiveInd
     * @var bool
     */
    public $ExpireDateExclusiveInd;
    /**
     * Constructor method for SignatureOnFile
     * @uses SignatureOnFile::setSignatureOnFileInd()
     * @uses SignatureOnFile::setEffectiveDate()
     * @uses SignatureOnFile::setExpireDate()
     * @uses SignatureOnFile::setExpireDateExclusiveInd()
     * @param bool $signatureOnFileInd
     * @param string $effectiveDate
     * @param string $expireDate
     * @param bool $expireDateExclusiveInd
     */
    public function __construct($signatureOnFileInd = null, $effectiveDate = null, $expireDate = null, $expireDateExclusiveInd = null)
    {
        $this
            ->setSignatureOnFileInd($signatureOnFileInd)
            ->setEffectiveDate($effectiveDate)
            ->setExpireDate($expireDate)
            ->setExpireDateExclusiveInd($expireDateExclusiveInd);
    }
    /**
     * Get SignatureOnFileInd value
     * @return bool|null
     */
    public function getSignatureOnFileInd()
    {
        return $this->SignatureOnFileInd;
    }
    /**
     * Set SignatureOnFileInd value
     * @param bool $signatureOnFileInd
     * @return \StructType\SignatureOnFile
     */
    public function setSignatureOnFileInd($signatureOnFileInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($signatureOnFileInd) && !is_bool($signatureOnFileInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($signatureOnFileInd, true), gettype($signatureOnFileInd)), __LINE__);
        }
        $this->SignatureOnFileInd = $signatureOnFileInd;
        return $this;
    }
    /**
     * Get EffectiveDate value
     * @return string|null
     */
    public function getEffectiveDate()
    {
        return $this->EffectiveDate;
    }
    /**
     * Set EffectiveDate value
     * @param string $effectiveDate
     * @return \StructType\SignatureOnFile
     */
    public function setEffectiveDate($effectiveDate = null)
    {
        // validation for constraint: string
        if (!is_null($effectiveDate) && !is_string($effectiveDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($effectiveDate, true), gettype($effectiveDate)), __LINE__);
        }
        $this->EffectiveDate = $effectiveDate;
        return $this;
    }
    /**
     * Get ExpireDate value
     * @return string|null
     */
    public function getExpireDate()
    {
        return $this->ExpireDate;
    }
    /**
     * Set ExpireDate value
     * @param string $expireDate
     * @return \StructType\SignatureOnFile
     */
    public function setExpireDate($expireDate = null)
    {
        // validation for constraint: string
        if (!is_null($expireDate) && !is_string($expireDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($expireDate, true), gettype($expireDate)), __LINE__);
        }
        $this->ExpireDate = $expireDate;
        return $this;
    }
    /**
     * Get ExpireDateExclusiveInd value
     * @return bool|null
     */
    public function getExpireDateExclusiveInd()
    {
        return $this->ExpireDateExclusiveInd;
    }
    /**
     * Set ExpireDateExclusiveInd value
     * @param bool $expireDateExclusiveInd
     * @return \StructType\SignatureOnFile
     */
    public function setExpireDateExclusiveInd($expireDateExclusiveInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($expireDateExclusiveInd) && !is_bool($expireDateExclusiveInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($expireDateExclusiveInd, true), gettype($expireDateExclusiveInd)), __LINE__);
        }
        $this->ExpireDateExclusiveInd = $expireDateExclusiveInd;
        return $this;
    }
}
