<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RoomTypeAllocation StructType
 * @subpackage Structs
 */
class RoomTypeAllocation extends AbstractStructBase
{
    /**
     * The Start
     * @var string
     */
    public $Start;
    /**
     * The Duration
     * @var string
     */
    public $Duration;
    /**
     * The End
     * @var string
     */
    public $End;
    /**
     * The NumberOfUnits
     * @var int
     */
    public $NumberOfUnits;
    /**
     * The CompRoomQuantity
     * @var int
     */
    public $CompRoomQuantity;
    /**
     * The CompRoomFactor
     * @var int
     */
    public $CompRoomFactor;
    /**
     * The EndDateIndicator
     * @var bool
     */
    public $EndDateIndicator;
    /**
     * The SellLimit
     * @var int
     */
    public $SellLimit;
    /**
     * The ProcureBlockCode
     * @var string
     */
    public $ProcureBlockCode;
    /**
     * The AllocationID
     * @var string
     */
    public $AllocationID;
    /**
     * The AllowGeneralInvInd
     * @var bool
     */
    public $AllowGeneralInvInd;
    /**
     * Constructor method for RoomTypeAllocation
     * @uses RoomTypeAllocation::setStart()
     * @uses RoomTypeAllocation::setDuration()
     * @uses RoomTypeAllocation::setEnd()
     * @uses RoomTypeAllocation::setNumberOfUnits()
     * @uses RoomTypeAllocation::setCompRoomQuantity()
     * @uses RoomTypeAllocation::setCompRoomFactor()
     * @uses RoomTypeAllocation::setEndDateIndicator()
     * @uses RoomTypeAllocation::setSellLimit()
     * @uses RoomTypeAllocation::setProcureBlockCode()
     * @uses RoomTypeAllocation::setAllocationID()
     * @uses RoomTypeAllocation::setAllowGeneralInvInd()
     * @param string $start
     * @param string $duration
     * @param string $end
     * @param int $numberOfUnits
     * @param int $compRoomQuantity
     * @param int $compRoomFactor
     * @param bool $endDateIndicator
     * @param int $sellLimit
     * @param string $procureBlockCode
     * @param string $allocationID
     * @param bool $allowGeneralInvInd
     */
    public function __construct($start = null, $duration = null, $end = null, $numberOfUnits = null, $compRoomQuantity = null, $compRoomFactor = null, $endDateIndicator = null, $sellLimit = null, $procureBlockCode = null, $allocationID = null, $allowGeneralInvInd = null)
    {
        $this
            ->setStart($start)
            ->setDuration($duration)
            ->setEnd($end)
            ->setNumberOfUnits($numberOfUnits)
            ->setCompRoomQuantity($compRoomQuantity)
            ->setCompRoomFactor($compRoomFactor)
            ->setEndDateIndicator($endDateIndicator)
            ->setSellLimit($sellLimit)
            ->setProcureBlockCode($procureBlockCode)
            ->setAllocationID($allocationID)
            ->setAllowGeneralInvInd($allowGeneralInvInd);
    }
    /**
     * Get Start value
     * @return string|null
     */
    public function getStart()
    {
        return $this->Start;
    }
    /**
     * Set Start value
     * @param string $start
     * @return \StructType\RoomTypeAllocation
     */
    public function setStart($start = null)
    {
        // validation for constraint: string
        if (!is_null($start) && !is_string($start)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($start, true), gettype($start)), __LINE__);
        }
        $this->Start = $start;
        return $this;
    }
    /**
     * Get Duration value
     * @return string|null
     */
    public function getDuration()
    {
        return $this->Duration;
    }
    /**
     * Set Duration value
     * @param string $duration
     * @return \StructType\RoomTypeAllocation
     */
    public function setDuration($duration = null)
    {
        // validation for constraint: string
        if (!is_null($duration) && !is_string($duration)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($duration, true), gettype($duration)), __LINE__);
        }
        $this->Duration = $duration;
        return $this;
    }
    /**
     * Get End value
     * @return string|null
     */
    public function getEnd()
    {
        return $this->End;
    }
    /**
     * Set End value
     * @param string $end
     * @return \StructType\RoomTypeAllocation
     */
    public function setEnd($end = null)
    {
        // validation for constraint: string
        if (!is_null($end) && !is_string($end)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($end, true), gettype($end)), __LINE__);
        }
        $this->End = $end;
        return $this;
    }
    /**
     * Get NumberOfUnits value
     * @return int|null
     */
    public function getNumberOfUnits()
    {
        return $this->NumberOfUnits;
    }
    /**
     * Set NumberOfUnits value
     * @param int $numberOfUnits
     * @return \StructType\RoomTypeAllocation
     */
    public function setNumberOfUnits($numberOfUnits = null)
    {
        // validation for constraint: int
        if (!is_null($numberOfUnits) && !(is_int($numberOfUnits) || ctype_digit($numberOfUnits))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($numberOfUnits, true), gettype($numberOfUnits)), __LINE__);
        }
        $this->NumberOfUnits = $numberOfUnits;
        return $this;
    }
    /**
     * Get CompRoomQuantity value
     * @return int|null
     */
    public function getCompRoomQuantity()
    {
        return $this->CompRoomQuantity;
    }
    /**
     * Set CompRoomQuantity value
     * @param int $compRoomQuantity
     * @return \StructType\RoomTypeAllocation
     */
    public function setCompRoomQuantity($compRoomQuantity = null)
    {
        // validation for constraint: int
        if (!is_null($compRoomQuantity) && !(is_int($compRoomQuantity) || ctype_digit($compRoomQuantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($compRoomQuantity, true), gettype($compRoomQuantity)), __LINE__);
        }
        $this->CompRoomQuantity = $compRoomQuantity;
        return $this;
    }
    /**
     * Get CompRoomFactor value
     * @return int|null
     */
    public function getCompRoomFactor()
    {
        return $this->CompRoomFactor;
    }
    /**
     * Set CompRoomFactor value
     * @param int $compRoomFactor
     * @return \StructType\RoomTypeAllocation
     */
    public function setCompRoomFactor($compRoomFactor = null)
    {
        // validation for constraint: int
        if (!is_null($compRoomFactor) && !(is_int($compRoomFactor) || ctype_digit($compRoomFactor))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($compRoomFactor, true), gettype($compRoomFactor)), __LINE__);
        }
        $this->CompRoomFactor = $compRoomFactor;
        return $this;
    }
    /**
     * Get EndDateIndicator value
     * @return bool|null
     */
    public function getEndDateIndicator()
    {
        return $this->EndDateIndicator;
    }
    /**
     * Set EndDateIndicator value
     * @param bool $endDateIndicator
     * @return \StructType\RoomTypeAllocation
     */
    public function setEndDateIndicator($endDateIndicator = null)
    {
        // validation for constraint: boolean
        if (!is_null($endDateIndicator) && !is_bool($endDateIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($endDateIndicator, true), gettype($endDateIndicator)), __LINE__);
        }
        $this->EndDateIndicator = $endDateIndicator;
        return $this;
    }
    /**
     * Get SellLimit value
     * @return int|null
     */
    public function getSellLimit()
    {
        return $this->SellLimit;
    }
    /**
     * Set SellLimit value
     * @param int $sellLimit
     * @return \StructType\RoomTypeAllocation
     */
    public function setSellLimit($sellLimit = null)
    {
        // validation for constraint: int
        if (!is_null($sellLimit) && !(is_int($sellLimit) || ctype_digit($sellLimit))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($sellLimit, true), gettype($sellLimit)), __LINE__);
        }
        $this->SellLimit = $sellLimit;
        return $this;
    }
    /**
     * Get ProcureBlockCode value
     * @return string|null
     */
    public function getProcureBlockCode()
    {
        return $this->ProcureBlockCode;
    }
    /**
     * Set ProcureBlockCode value
     * @param string $procureBlockCode
     * @return \StructType\RoomTypeAllocation
     */
    public function setProcureBlockCode($procureBlockCode = null)
    {
        // validation for constraint: string
        if (!is_null($procureBlockCode) && !is_string($procureBlockCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($procureBlockCode, true), gettype($procureBlockCode)), __LINE__);
        }
        $this->ProcureBlockCode = $procureBlockCode;
        return $this;
    }
    /**
     * Get AllocationID value
     * @return string|null
     */
    public function getAllocationID()
    {
        return $this->AllocationID;
    }
    /**
     * Set AllocationID value
     * @param string $allocationID
     * @return \StructType\RoomTypeAllocation
     */
    public function setAllocationID($allocationID = null)
    {
        // validation for constraint: string
        if (!is_null($allocationID) && !is_string($allocationID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($allocationID, true), gettype($allocationID)), __LINE__);
        }
        $this->AllocationID = $allocationID;
        return $this;
    }
    /**
     * Get AllowGeneralInvInd value
     * @return bool|null
     */
    public function getAllowGeneralInvInd()
    {
        return $this->AllowGeneralInvInd;
    }
    /**
     * Set AllowGeneralInvInd value
     * @param bool $allowGeneralInvInd
     * @return \StructType\RoomTypeAllocation
     */
    public function setAllowGeneralInvInd($allowGeneralInvInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($allowGeneralInvInd) && !is_bool($allowGeneralInvInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($allowGeneralInvInd, true), gettype($allowGeneralInvInd)), __LINE__);
        }
        $this->AllowGeneralInvInd = $allowGeneralInvInd;
        return $this;
    }
}
