<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for NotifDetails StructType
 * @subpackage Structs
 */
class NotifDetails extends AbstractStructBase
{
    /**
     * The HotelNotifReport
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\HotelNotifReport
     */
    public $HotelNotifReport;
    /**
     * The HotelCode
     * @var string
     */
    public $HotelCode;
    /**
     * The HotelName
     * @var string
     */
    public $HotelName;
    /**
     * Constructor method for NotifDetails
     * @uses NotifDetails::setHotelNotifReport()
     * @uses NotifDetails::setHotelCode()
     * @uses NotifDetails::setHotelName()
     * @param \StructType\HotelNotifReport $hotelNotifReport
     * @param string $hotelCode
     * @param string $hotelName
     */
    public function __construct(\StructType\HotelNotifReport $hotelNotifReport = null, $hotelCode = null, $hotelName = null)
    {
        $this
            ->setHotelNotifReport($hotelNotifReport)
            ->setHotelCode($hotelCode)
            ->setHotelName($hotelName);
    }
    /**
     * Get HotelNotifReport value
     * @return \StructType\HotelNotifReport|null
     */
    public function getHotelNotifReport()
    {
        return $this->HotelNotifReport;
    }
    /**
     * Set HotelNotifReport value
     * @param \StructType\HotelNotifReport $hotelNotifReport
     * @return \StructType\NotifDetails
     */
    public function setHotelNotifReport(\StructType\HotelNotifReport $hotelNotifReport = null)
    {
        $this->HotelNotifReport = $hotelNotifReport;
        return $this;
    }
    /**
     * Get HotelCode value
     * @return string|null
     */
    public function getHotelCode()
    {
        return $this->HotelCode;
    }
    /**
     * Set HotelCode value
     * @param string $hotelCode
     * @return \StructType\NotifDetails
     */
    public function setHotelCode($hotelCode = null)
    {
        // validation for constraint: string
        if (!is_null($hotelCode) && !is_string($hotelCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hotelCode, true), gettype($hotelCode)), __LINE__);
        }
        $this->HotelCode = $hotelCode;
        return $this;
    }
    /**
     * Get HotelName value
     * @return string|null
     */
    public function getHotelName()
    {
        return $this->HotelName;
    }
    /**
     * Set HotelName value
     * @param string $hotelName
     * @return \StructType\NotifDetails
     */
    public function setHotelName($hotelName = null)
    {
        // validation for constraint: string
        if (!is_null($hotelName) && !is_string($hotelName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hotelName, true), gettype($hotelName)), __LINE__);
        }
        $this->HotelName = $hotelName;
        return $this;
    }
}
