<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for HotelDescriptiveContentType StructType
 * @subpackage Structs
 */
class HotelDescriptiveContentType extends AbstractStructBase
{
    /**
     * The HotelInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\HotelInfoType
     */
    public $HotelInfo;
    /**
     * The FacilityInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\FacilityInfoType
     */
    public $FacilityInfo;
    /**
     * The AffiliationInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\AffiliationInfoType
     */
    public $AffiliationInfo;
    /**
     * The ContactInfos
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfContactInfoRootType
     */
    public $ContactInfos;
    /**
     * The LanguageCode
     * @var string
     */
    public $LanguageCode;
    /**
     * Constructor method for HotelDescriptiveContentType
     * @uses HotelDescriptiveContentType::setHotelInfo()
     * @uses HotelDescriptiveContentType::setFacilityInfo()
     * @uses HotelDescriptiveContentType::setAffiliationInfo()
     * @uses HotelDescriptiveContentType::setContactInfos()
     * @uses HotelDescriptiveContentType::setLanguageCode()
     * @param \StructType\HotelInfoType $hotelInfo
     * @param \StructType\FacilityInfoType $facilityInfo
     * @param \StructType\AffiliationInfoType $affiliationInfo
     * @param \ArrayType\ArrayOfContactInfoRootType $contactInfos
     * @param string $languageCode
     */
    public function __construct(\StructType\HotelInfoType $hotelInfo = null, \StructType\FacilityInfoType $facilityInfo = null, \StructType\AffiliationInfoType $affiliationInfo = null, \ArrayType\ArrayOfContactInfoRootType $contactInfos = null, $languageCode = null)
    {
        $this
            ->setHotelInfo($hotelInfo)
            ->setFacilityInfo($facilityInfo)
            ->setAffiliationInfo($affiliationInfo)
            ->setContactInfos($contactInfos)
            ->setLanguageCode($languageCode);
    }
    /**
     * Get HotelInfo value
     * @return \StructType\HotelInfoType|null
     */
    public function getHotelInfo()
    {
        return $this->HotelInfo;
    }
    /**
     * Set HotelInfo value
     * @param \StructType\HotelInfoType $hotelInfo
     * @return \StructType\HotelDescriptiveContentType
     */
    public function setHotelInfo(\StructType\HotelInfoType $hotelInfo = null)
    {
        $this->HotelInfo = $hotelInfo;
        return $this;
    }
    /**
     * Get FacilityInfo value
     * @return \StructType\FacilityInfoType|null
     */
    public function getFacilityInfo()
    {
        return $this->FacilityInfo;
    }
    /**
     * Set FacilityInfo value
     * @param \StructType\FacilityInfoType $facilityInfo
     * @return \StructType\HotelDescriptiveContentType
     */
    public function setFacilityInfo(\StructType\FacilityInfoType $facilityInfo = null)
    {
        $this->FacilityInfo = $facilityInfo;
        return $this;
    }
    /**
     * Get AffiliationInfo value
     * @return \StructType\AffiliationInfoType|null
     */
    public function getAffiliationInfo()
    {
        return $this->AffiliationInfo;
    }
    /**
     * Set AffiliationInfo value
     * @param \StructType\AffiliationInfoType $affiliationInfo
     * @return \StructType\HotelDescriptiveContentType
     */
    public function setAffiliationInfo(\StructType\AffiliationInfoType $affiliationInfo = null)
    {
        $this->AffiliationInfo = $affiliationInfo;
        return $this;
    }
    /**
     * Get ContactInfos value
     * @return \ArrayType\ArrayOfContactInfoRootType|null
     */
    public function getContactInfos()
    {
        return $this->ContactInfos;
    }
    /**
     * Set ContactInfos value
     * @param \ArrayType\ArrayOfContactInfoRootType $contactInfos
     * @return \StructType\HotelDescriptiveContentType
     */
    public function setContactInfos(\ArrayType\ArrayOfContactInfoRootType $contactInfos = null)
    {
        $this->ContactInfos = $contactInfos;
        return $this;
    }
    /**
     * Get LanguageCode value
     * @return string|null
     */
    public function getLanguageCode()
    {
        return $this->LanguageCode;
    }
    /**
     * Set LanguageCode value
     * @param string $languageCode
     * @return \StructType\HotelDescriptiveContentType
     */
    public function setLanguageCode($languageCode = null)
    {
        // validation for constraint: string
        if (!is_null($languageCode) && !is_string($languageCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($languageCode, true), gettype($languageCode)), __LINE__);
        }
        $this->LanguageCode = $languageCode;
        return $this;
    }
}
