<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Award StructType
 * @subpackage Structs
 */
class Award extends AbstractStructBase
{
    /**
     * The Date
     * @var string
     */
    public $Date;
    /**
     * The Provider
     * @var string
     */
    public $Provider;
    /**
     * The Rating
     * @var string
     */
    public $Rating;
    /**
     * The RatingSymbol
     * @var string
     */
    public $RatingSymbol;
    /**
     * Constructor method for Award
     * @uses Award::setDate()
     * @uses Award::setProvider()
     * @uses Award::setRating()
     * @uses Award::setRatingSymbol()
     * @param string $date
     * @param string $provider
     * @param string $rating
     * @param string $ratingSymbol
     */
    public function __construct($date = null, $provider = null, $rating = null, $ratingSymbol = null)
    {
        $this
            ->setDate($date)
            ->setProvider($provider)
            ->setRating($rating)
            ->setRatingSymbol($ratingSymbol);
    }
    /**
     * Get Date value
     * @return string|null
     */
    public function getDate()
    {
        return $this->Date;
    }
    /**
     * Set Date value
     * @param string $date
     * @return \StructType\Award
     */
    public function setDate($date = null)
    {
        // validation for constraint: string
        if (!is_null($date) && !is_string($date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($date, true), gettype($date)), __LINE__);
        }
        $this->Date = $date;
        return $this;
    }
    /**
     * Get Provider value
     * @return string|null
     */
    public function getProvider()
    {
        return $this->Provider;
    }
    /**
     * Set Provider value
     * @param string $provider
     * @return \StructType\Award
     */
    public function setProvider($provider = null)
    {
        // validation for constraint: string
        if (!is_null($provider) && !is_string($provider)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($provider, true), gettype($provider)), __LINE__);
        }
        $this->Provider = $provider;
        return $this;
    }
    /**
     * Get Rating value
     * @return string|null
     */
    public function getRating()
    {
        return $this->Rating;
    }
    /**
     * Set Rating value
     * @param string $rating
     * @return \StructType\Award
     */
    public function setRating($rating = null)
    {
        // validation for constraint: string
        if (!is_null($rating) && !is_string($rating)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rating, true), gettype($rating)), __LINE__);
        }
        $this->Rating = $rating;
        return $this;
    }
    /**
     * Get RatingSymbol value
     * @return string|null
     */
    public function getRatingSymbol()
    {
        return $this->RatingSymbol;
    }
    /**
     * Set RatingSymbol value
     * @param string $ratingSymbol
     * @return \StructType\Award
     */
    public function setRatingSymbol($ratingSymbol = null)
    {
        // validation for constraint: string
        if (!is_null($ratingSymbol) && !is_string($ratingSymbol)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ratingSymbol, true), gettype($ratingSymbol)), __LINE__);
        }
        $this->RatingSymbol = $ratingSymbol;
        return $this;
    }
}
