<?php

namespace EnumType;

use \WsdlToPhp\PackageBase\AbstractStructEnumBase;

/**
 * This class stands for TaxType EnumType
 * @subpackage Enumerations
 */
class TaxType extends AbstractStructEnumBase
{
    /**
     * Constant for value 'Taxable'
     * @return string 'Taxable'
     */
    const VALUE_TAXABLE = 'Taxable';
    /**
     * Constant for value 'RoomExempt'
     * @return string 'RoomExempt'
     */
    const VALUE_ROOM_EXEMPT = 'RoomExempt';
    /**
     * Constant for value 'FullExempt'
     * @return string 'FullExempt'
     */
    const VALUE_FULL_EXEMPT = 'FullExempt';
    /**
     * Constant for value ''
     * @return string ''
     */
    const VALUE_ = '';
    /**
     * Return allowed values
     * @uses self::VALUE_TAXABLE
     * @uses self::VALUE_ROOM_EXEMPT
     * @uses self::VALUE_FULL_EXEMPT
     * @uses self::VALUE_
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_TAXABLE,
            self::VALUE_ROOM_EXEMPT,
            self::VALUE_FULL_EXEMPT,
            self::VALUE_,
        );
    }
}
