<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SubAccountBalance StructType
 * @subpackage Structs
 */
class SubAccountBalance extends AbstractStructBase
{
    /**
     * The Type
     * @var string
     */
    public $Type;
    /**
     * The Balance
     * @var int
     */
    public $Balance;
    /**
     * Constructor method for SubAccountBalance
     * @uses SubAccountBalance::setType()
     * @uses SubAccountBalance::setBalance()
     * @param string $type
     * @param int $balance
     */
    public function __construct($type = null, $balance = null)
    {
        $this
            ->setType($type)
            ->setBalance($balance);
    }
    /**
     * Get Type value
     * @return string|null
     */
    public function getType()
    {
        return $this->Type;
    }
    /**
     * Set Type value
     * @param string $type
     * @return \StructType\SubAccountBalance
     */
    public function setType($type = null)
    {
        // validation for constraint: string
        if (!is_null($type) && !is_string($type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($type, true), gettype($type)), __LINE__);
        }
        $this->Type = $type;
        return $this;
    }
    /**
     * Get Balance value
     * @return int|null
     */
    public function getBalance()
    {
        return $this->Balance;
    }
    /**
     * Set Balance value
     * @param int $balance
     * @return \StructType\SubAccountBalance
     */
    public function setBalance($balance = null)
    {
        // validation for constraint: int
        if (!is_null($balance) && !(is_int($balance) || ctype_digit($balance))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($balance, true), gettype($balance)), __LINE__);
        }
        $this->Balance = $balance;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SubAccountBalance
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
