<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ServicesType StructType
 * @subpackage Structs
 */
class ServicesType extends AbstractStructBase
{
    /**
     * The Service
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\ServiceType[]
     */
    public $Service;
    /**
     * Constructor method for ServicesType
     * @uses ServicesType::setService()
     * @param \StructType\ServiceType[] $service
     */
    public function __construct(array $service = array())
    {
        $this
            ->setService($service);
    }
    /**
     * Get Service value
     * @return \StructType\ServiceType[]|null
     */
    public function getService()
    {
        return $this->Service;
    }
    /**
     * This method is responsible for validating the values passed to the setService method
     * This method is willingly generated in order to preserve the one-line inline validation within the setService method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateServiceForArrayConstraintsFromSetService(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $servicesTypeServiceItem) {
            // validation for constraint: itemType
            if (!$servicesTypeServiceItem instanceof \StructType\ServiceType) {
                $invalidValues[] = is_object($servicesTypeServiceItem) ? get_class($servicesTypeServiceItem) : sprintf('%s(%s)', gettype($servicesTypeServiceItem), var_export($servicesTypeServiceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Service property can only contain items of type \StructType\ServiceType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Service value
     * @throws \InvalidArgumentException
     * @param \StructType\ServiceType[] $service
     * @return \StructType\ServicesType
     */
    public function setService(array $service = array())
    {
        // validation for constraint: array
        if ('' !== ($serviceArrayErrorMessage = self::validateServiceForArrayConstraintsFromSetService($service))) {
            throw new \InvalidArgumentException($serviceArrayErrorMessage, __LINE__);
        }
        $this->Service = $service;
        return $this;
    }
    /**
     * Add item to Service value
     * @throws \InvalidArgumentException
     * @param \StructType\ServiceType $item
     * @return \StructType\ServicesType
     */
    public function addToService(\StructType\ServiceType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ServiceType) {
            throw new \InvalidArgumentException(sprintf('The Service property can only contain items of type \StructType\ServiceType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Service[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ServicesType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
