<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SellableProductsType StructType
 * @subpackage Structs
 */
class SellableProductsType extends AbstractStructBase
{
    /**
     * The SellableProduct
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SellableProduct[]
     */
    public $SellableProduct;
    /**
     * Constructor method for SellableProductsType
     * @uses SellableProductsType::setSellableProduct()
     * @param \StructType\SellableProduct[] $sellableProduct
     */
    public function __construct(array $sellableProduct = array())
    {
        $this
            ->setSellableProduct($sellableProduct);
    }
    /**
     * Get SellableProduct value
     * @return \StructType\SellableProduct[]|null
     */
    public function getSellableProduct()
    {
        return $this->SellableProduct;
    }
    /**
     * This method is responsible for validating the values passed to the setSellableProduct method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSellableProduct method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSellableProductForArrayConstraintsFromSetSellableProduct(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $sellableProductsTypeSellableProductItem) {
            // validation for constraint: itemType
            if (!$sellableProductsTypeSellableProductItem instanceof \StructType\SellableProduct) {
                $invalidValues[] = is_object($sellableProductsTypeSellableProductItem) ? get_class($sellableProductsTypeSellableProductItem) : sprintf('%s(%s)', gettype($sellableProductsTypeSellableProductItem), var_export($sellableProductsTypeSellableProductItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The SellableProduct property can only contain items of type \StructType\SellableProduct, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set SellableProduct value
     * @throws \InvalidArgumentException
     * @param \StructType\SellableProduct[] $sellableProduct
     * @return \StructType\SellableProductsType
     */
    public function setSellableProduct(array $sellableProduct = array())
    {
        // validation for constraint: array
        if ('' !== ($sellableProductArrayErrorMessage = self::validateSellableProductForArrayConstraintsFromSetSellableProduct($sellableProduct))) {
            throw new \InvalidArgumentException($sellableProductArrayErrorMessage, __LINE__);
        }
        $this->SellableProduct = $sellableProduct;
        return $this;
    }
    /**
     * Add item to SellableProduct value
     * @throws \InvalidArgumentException
     * @param \StructType\SellableProduct $item
     * @return \StructType\SellableProductsType
     */
    public function addToSellableProduct(\StructType\SellableProduct $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SellableProduct) {
            throw new \InvalidArgumentException(sprintf('The SellableProduct property can only contain items of type \StructType\SellableProduct, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->SellableProduct[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SellableProductsType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
