<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RatePlanType StructType
 * @subpackage Structs
 */
class RatePlanType extends AbstractStructBase
{
    /**
     * The Guarantee
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Guarantee[]
     */
    public $Guarantee;
    /**
     * The CancelPenalties
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\CancelPenaltiesType
     */
    public $CancelPenalties;
    /**
     * The RatePlanDescription
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ParagraphType
     */
    public $RatePlanDescription;
    /**
     * The Commission
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\CommissionType
     */
    public $Commission;
    /**
     * The MealsIncluded
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\MealsIncluded
     */
    public $MealsIncluded;
    /**
     * The RatePlanCode
     * @var string
     */
    public $RatePlanCode;
    /**
     * The EffectiveDate
     * @var string
     */
    public $EffectiveDate;
    /**
     * The ExpireDate
     * @var string
     */
    public $ExpireDate;
    /**
     * The ExpireDateExclusiveInd
     * @var bool
     */
    public $ExpireDateExclusiveInd;
    /**
     * The RatePlanType
     * @var string
     */
    public $RatePlanType;
    /**
     * The RatePlanID
     * @var string
     */
    public $RatePlanID;
    /**
     * The RatePlanName
     * @var string
     */
    public $RatePlanName;
    /**
     * Constructor method for RatePlanType
     * @uses RatePlanType::setGuarantee()
     * @uses RatePlanType::setCancelPenalties()
     * @uses RatePlanType::setRatePlanDescription()
     * @uses RatePlanType::setCommission()
     * @uses RatePlanType::setMealsIncluded()
     * @uses RatePlanType::setRatePlanCode()
     * @uses RatePlanType::setEffectiveDate()
     * @uses RatePlanType::setExpireDate()
     * @uses RatePlanType::setExpireDateExclusiveInd()
     * @uses RatePlanType::setRatePlanType()
     * @uses RatePlanType::setRatePlanID()
     * @uses RatePlanType::setRatePlanName()
     * @param \StructType\Guarantee[] $guarantee
     * @param \StructType\CancelPenaltiesType $cancelPenalties
     * @param \StructType\ParagraphType $ratePlanDescription
     * @param \StructType\CommissionType $commission
     * @param \StructType\MealsIncluded $mealsIncluded
     * @param string $ratePlanCode
     * @param string $effectiveDate
     * @param string $expireDate
     * @param bool $expireDateExclusiveInd
     * @param string $ratePlanType
     * @param string $ratePlanID
     * @param string $ratePlanName
     */
    public function __construct(array $guarantee = array(), \StructType\CancelPenaltiesType $cancelPenalties = null, \StructType\ParagraphType $ratePlanDescription = null, \StructType\CommissionType $commission = null, \StructType\MealsIncluded $mealsIncluded = null, $ratePlanCode = null, $effectiveDate = null, $expireDate = null, $expireDateExclusiveInd = null, $ratePlanType = null, $ratePlanID = null, $ratePlanName = null)
    {
        $this
            ->setGuarantee($guarantee)
            ->setCancelPenalties($cancelPenalties)
            ->setRatePlanDescription($ratePlanDescription)
            ->setCommission($commission)
            ->setMealsIncluded($mealsIncluded)
            ->setRatePlanCode($ratePlanCode)
            ->setEffectiveDate($effectiveDate)
            ->setExpireDate($expireDate)
            ->setExpireDateExclusiveInd($expireDateExclusiveInd)
            ->setRatePlanType($ratePlanType)
            ->setRatePlanID($ratePlanID)
            ->setRatePlanName($ratePlanName);
    }
    /**
     * Get Guarantee value
     * @return \StructType\Guarantee[]|null
     */
    public function getGuarantee()
    {
        return $this->Guarantee;
    }
    /**
     * This method is responsible for validating the values passed to the setGuarantee method
     * This method is willingly generated in order to preserve the one-line inline validation within the setGuarantee method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateGuaranteeForArrayConstraintsFromSetGuarantee(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $ratePlanTypeGuaranteeItem) {
            // validation for constraint: itemType
            if (!$ratePlanTypeGuaranteeItem instanceof \StructType\Guarantee) {
                $invalidValues[] = is_object($ratePlanTypeGuaranteeItem) ? get_class($ratePlanTypeGuaranteeItem) : sprintf('%s(%s)', gettype($ratePlanTypeGuaranteeItem), var_export($ratePlanTypeGuaranteeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Guarantee property can only contain items of type \StructType\Guarantee, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Guarantee value
     * @throws \InvalidArgumentException
     * @param \StructType\Guarantee[] $guarantee
     * @return \StructType\RatePlanType
     */
    public function setGuarantee(array $guarantee = array())
    {
        // validation for constraint: array
        if ('' !== ($guaranteeArrayErrorMessage = self::validateGuaranteeForArrayConstraintsFromSetGuarantee($guarantee))) {
            throw new \InvalidArgumentException($guaranteeArrayErrorMessage, __LINE__);
        }
        $this->Guarantee = $guarantee;
        return $this;
    }
    /**
     * Add item to Guarantee value
     * @throws \InvalidArgumentException
     * @param \StructType\Guarantee $item
     * @return \StructType\RatePlanType
     */
    public function addToGuarantee(\StructType\Guarantee $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Guarantee) {
            throw new \InvalidArgumentException(sprintf('The Guarantee property can only contain items of type \StructType\Guarantee, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Guarantee[] = $item;
        return $this;
    }
    /**
     * Get CancelPenalties value
     * @return \StructType\CancelPenaltiesType|null
     */
    public function getCancelPenalties()
    {
        return $this->CancelPenalties;
    }
    /**
     * Set CancelPenalties value
     * @param \StructType\CancelPenaltiesType $cancelPenalties
     * @return \StructType\RatePlanType
     */
    public function setCancelPenalties(\StructType\CancelPenaltiesType $cancelPenalties = null)
    {
        $this->CancelPenalties = $cancelPenalties;
        return $this;
    }
    /**
     * Get RatePlanDescription value
     * @return \StructType\ParagraphType|null
     */
    public function getRatePlanDescription()
    {
        return $this->RatePlanDescription;
    }
    /**
     * Set RatePlanDescription value
     * @param \StructType\ParagraphType $ratePlanDescription
     * @return \StructType\RatePlanType
     */
    public function setRatePlanDescription(\StructType\ParagraphType $ratePlanDescription = null)
    {
        $this->RatePlanDescription = $ratePlanDescription;
        return $this;
    }
    /**
     * Get Commission value
     * @return \StructType\CommissionType|null
     */
    public function getCommission()
    {
        return $this->Commission;
    }
    /**
     * Set Commission value
     * @param \StructType\CommissionType $commission
     * @return \StructType\RatePlanType
     */
    public function setCommission(\StructType\CommissionType $commission = null)
    {
        $this->Commission = $commission;
        return $this;
    }
    /**
     * Get MealsIncluded value
     * @return \StructType\MealsIncluded|null
     */
    public function getMealsIncluded()
    {
        return $this->MealsIncluded;
    }
    /**
     * Set MealsIncluded value
     * @param \StructType\MealsIncluded $mealsIncluded
     * @return \StructType\RatePlanType
     */
    public function setMealsIncluded(\StructType\MealsIncluded $mealsIncluded = null)
    {
        $this->MealsIncluded = $mealsIncluded;
        return $this;
    }
    /**
     * Get RatePlanCode value
     * @return string|null
     */
    public function getRatePlanCode()
    {
        return $this->RatePlanCode;
    }
    /**
     * Set RatePlanCode value
     * @param string $ratePlanCode
     * @return \StructType\RatePlanType
     */
    public function setRatePlanCode($ratePlanCode = null)
    {
        // validation for constraint: string
        if (!is_null($ratePlanCode) && !is_string($ratePlanCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ratePlanCode, true), gettype($ratePlanCode)), __LINE__);
        }
        $this->RatePlanCode = $ratePlanCode;
        return $this;
    }
    /**
     * Get EffectiveDate value
     * @return string|null
     */
    public function getEffectiveDate()
    {
        return $this->EffectiveDate;
    }
    /**
     * Set EffectiveDate value
     * @param string $effectiveDate
     * @return \StructType\RatePlanType
     */
    public function setEffectiveDate($effectiveDate = null)
    {
        // validation for constraint: string
        if (!is_null($effectiveDate) && !is_string($effectiveDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($effectiveDate, true), gettype($effectiveDate)), __LINE__);
        }
        $this->EffectiveDate = $effectiveDate;
        return $this;
    }
    /**
     * Get ExpireDate value
     * @return string|null
     */
    public function getExpireDate()
    {
        return $this->ExpireDate;
    }
    /**
     * Set ExpireDate value
     * @param string $expireDate
     * @return \StructType\RatePlanType
     */
    public function setExpireDate($expireDate = null)
    {
        // validation for constraint: string
        if (!is_null($expireDate) && !is_string($expireDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($expireDate, true), gettype($expireDate)), __LINE__);
        }
        $this->ExpireDate = $expireDate;
        return $this;
    }
    /**
     * Get ExpireDateExclusiveInd value
     * @return bool|null
     */
    public function getExpireDateExclusiveInd()
    {
        return $this->ExpireDateExclusiveInd;
    }
    /**
     * Set ExpireDateExclusiveInd value
     * @param bool $expireDateExclusiveInd
     * @return \StructType\RatePlanType
     */
    public function setExpireDateExclusiveInd($expireDateExclusiveInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($expireDateExclusiveInd) && !is_bool($expireDateExclusiveInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($expireDateExclusiveInd, true), gettype($expireDateExclusiveInd)), __LINE__);
        }
        $this->ExpireDateExclusiveInd = $expireDateExclusiveInd;
        return $this;
    }
    /**
     * Get RatePlanType value
     * @return string|null
     */
    public function getRatePlanType()
    {
        return $this->RatePlanType;
    }
    /**
     * Set RatePlanType value
     * @param string $ratePlanType
     * @return \StructType\RatePlanType
     */
    public function setRatePlanType($ratePlanType = null)
    {
        // validation for constraint: string
        if (!is_null($ratePlanType) && !is_string($ratePlanType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ratePlanType, true), gettype($ratePlanType)), __LINE__);
        }
        $this->RatePlanType = $ratePlanType;
        return $this;
    }
    /**
     * Get RatePlanID value
     * @return string|null
     */
    public function getRatePlanID()
    {
        return $this->RatePlanID;
    }
    /**
     * Set RatePlanID value
     * @param string $ratePlanID
     * @return \StructType\RatePlanType
     */
    public function setRatePlanID($ratePlanID = null)
    {
        // validation for constraint: string
        if (!is_null($ratePlanID) && !is_string($ratePlanID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ratePlanID, true), gettype($ratePlanID)), __LINE__);
        }
        $this->RatePlanID = $ratePlanID;
        return $this;
    }
    /**
     * Get RatePlanName value
     * @return string|null
     */
    public function getRatePlanName()
    {
        return $this->RatePlanName;
    }
    /**
     * Set RatePlanName value
     * @param string $ratePlanName
     * @return \StructType\RatePlanType
     */
    public function setRatePlanName($ratePlanName = null)
    {
        // validation for constraint: string
        if (!is_null($ratePlanName) && !is_string($ratePlanName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ratePlanName, true), gettype($ratePlanName)), __LINE__);
        }
        $this->RatePlanName = $ratePlanName;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\RatePlanType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
