<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Rate StructType
 * @subpackage Structs
 */
class Rate extends RateUploadType
{
    /**
     * The Duration
     * @var string
     */
    public $Duration;
    /**
     * The RateMode
     * @var string
     */
    public $RateMode;
    /**
     * The CachedIndicator
     * @var bool
     */
    public $CachedIndicator;
    /**
     * The RateSource
     * @var string
     */
    public $RateSource;
    /**
     * The RateTypeCode
     * @var string
     */
    public $RateTypeCode;
    /**
     * The RoomPricingType
     * @var string
     */
    public $RoomPricingType;
    /**
     * The InvTypeCode
     * @var string
     */
    public $InvTypeCode;
    /**
     * Constructor method for Rate
     * @uses Rate::setDuration()
     * @uses Rate::setRateMode()
     * @uses Rate::setCachedIndicator()
     * @uses Rate::setRateSource()
     * @uses Rate::setRateTypeCode()
     * @uses Rate::setRoomPricingType()
     * @uses Rate::setInvTypeCode()
     * @param string $duration
     * @param string $rateMode
     * @param bool $cachedIndicator
     * @param string $rateSource
     * @param string $rateTypeCode
     * @param string $roomPricingType
     * @param string $invTypeCode
     */
    public function __construct($duration = null, $rateMode = null, $cachedIndicator = null, $rateSource = null, $rateTypeCode = null, $roomPricingType = null, $invTypeCode = null)
    {
        $this
            ->setDuration($duration)
            ->setRateMode($rateMode)
            ->setCachedIndicator($cachedIndicator)
            ->setRateSource($rateSource)
            ->setRateTypeCode($rateTypeCode)
            ->setRoomPricingType($roomPricingType)
            ->setInvTypeCode($invTypeCode);
    }
    /**
     * Get Duration value
     * @return string|null
     */
    public function getDuration()
    {
        return $this->Duration;
    }
    /**
     * Set Duration value
     * @param string $duration
     * @return \StructType\Rate
     */
    public function setDuration($duration = null)
    {
        // validation for constraint: string
        if (!is_null($duration) && !is_string($duration)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($duration, true), gettype($duration)), __LINE__);
        }
        $this->Duration = $duration;
        return $this;
    }
    /**
     * Get RateMode value
     * @return string|null
     */
    public function getRateMode()
    {
        return $this->RateMode;
    }
    /**
     * Set RateMode value
     * @param string $rateMode
     * @return \StructType\Rate
     */
    public function setRateMode($rateMode = null)
    {
        // validation for constraint: string
        if (!is_null($rateMode) && !is_string($rateMode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rateMode, true), gettype($rateMode)), __LINE__);
        }
        $this->RateMode = $rateMode;
        return $this;
    }
    /**
     * Get CachedIndicator value
     * @return bool|null
     */
    public function getCachedIndicator()
    {
        return $this->CachedIndicator;
    }
    /**
     * Set CachedIndicator value
     * @param bool $cachedIndicator
     * @return \StructType\Rate
     */
    public function setCachedIndicator($cachedIndicator = null)
    {
        // validation for constraint: boolean
        if (!is_null($cachedIndicator) && !is_bool($cachedIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($cachedIndicator, true), gettype($cachedIndicator)), __LINE__);
        }
        $this->CachedIndicator = $cachedIndicator;
        return $this;
    }
    /**
     * Get RateSource value
     * @return string|null
     */
    public function getRateSource()
    {
        return $this->RateSource;
    }
    /**
     * Set RateSource value
     * @param string $rateSource
     * @return \StructType\Rate
     */
    public function setRateSource($rateSource = null)
    {
        // validation for constraint: string
        if (!is_null($rateSource) && !is_string($rateSource)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rateSource, true), gettype($rateSource)), __LINE__);
        }
        $this->RateSource = $rateSource;
        return $this;
    }
    /**
     * Get RateTypeCode value
     * @return string|null
     */
    public function getRateTypeCode()
    {
        return $this->RateTypeCode;
    }
    /**
     * Set RateTypeCode value
     * @param string $rateTypeCode
     * @return \StructType\Rate
     */
    public function setRateTypeCode($rateTypeCode = null)
    {
        // validation for constraint: string
        if (!is_null($rateTypeCode) && !is_string($rateTypeCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rateTypeCode, true), gettype($rateTypeCode)), __LINE__);
        }
        $this->RateTypeCode = $rateTypeCode;
        return $this;
    }
    /**
     * Get RoomPricingType value
     * @return string|null
     */
    public function getRoomPricingType()
    {
        return $this->RoomPricingType;
    }
    /**
     * Set RoomPricingType value
     * @uses \EnumType\PricingType::valueIsValid()
     * @uses \EnumType\PricingType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $roomPricingType
     * @return \StructType\Rate
     */
    public function setRoomPricingType($roomPricingType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\PricingType::valueIsValid($roomPricingType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\PricingType', is_array($roomPricingType) ? implode(', ', $roomPricingType) : var_export($roomPricingType, true), implode(', ', \EnumType\PricingType::getValidValues())), __LINE__);
        }
        $this->RoomPricingType = $roomPricingType;
        return $this;
    }
    /**
     * Get InvTypeCode value
     * @return string|null
     */
    public function getInvTypeCode()
    {
        return $this->InvTypeCode;
    }
    /**
     * Set InvTypeCode value
     * @param string $invTypeCode
     * @return \StructType\Rate
     */
    public function setInvTypeCode($invTypeCode = null)
    {
        // validation for constraint: string
        if (!is_null($invTypeCode) && !is_string($invTypeCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($invTypeCode, true), gettype($invTypeCode)), __LINE__);
        }
        $this->InvTypeCode = $invTypeCode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Rate
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
