<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ProfilesType StructType
 * @subpackage Structs
 */
class ProfilesType extends AbstractStructBase
{
    /**
     * The ProfileInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\ProfileInfo[]
     */
    public $ProfileInfo;
    /**
     * Constructor method for ProfilesType
     * @uses ProfilesType::setProfileInfo()
     * @param \StructType\ProfileInfo[] $profileInfo
     */
    public function __construct(array $profileInfo = array())
    {
        $this
            ->setProfileInfo($profileInfo);
    }
    /**
     * Get ProfileInfo value
     * @return \StructType\ProfileInfo[]|null
     */
    public function getProfileInfo()
    {
        return $this->ProfileInfo;
    }
    /**
     * This method is responsible for validating the values passed to the setProfileInfo method
     * This method is willingly generated in order to preserve the one-line inline validation within the setProfileInfo method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateProfileInfoForArrayConstraintsFromSetProfileInfo(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $profilesTypeProfileInfoItem) {
            // validation for constraint: itemType
            if (!$profilesTypeProfileInfoItem instanceof \StructType\ProfileInfo) {
                $invalidValues[] = is_object($profilesTypeProfileInfoItem) ? get_class($profilesTypeProfileInfoItem) : sprintf('%s(%s)', gettype($profilesTypeProfileInfoItem), var_export($profilesTypeProfileInfoItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ProfileInfo property can only contain items of type \StructType\ProfileInfo, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ProfileInfo value
     * @throws \InvalidArgumentException
     * @param \StructType\ProfileInfo[] $profileInfo
     * @return \StructType\ProfilesType
     */
    public function setProfileInfo(array $profileInfo = array())
    {
        // validation for constraint: array
        if ('' !== ($profileInfoArrayErrorMessage = self::validateProfileInfoForArrayConstraintsFromSetProfileInfo($profileInfo))) {
            throw new \InvalidArgumentException($profileInfoArrayErrorMessage, __LINE__);
        }
        $this->ProfileInfo = $profileInfo;
        return $this;
    }
    /**
     * Add item to ProfileInfo value
     * @throws \InvalidArgumentException
     * @param \StructType\ProfileInfo $item
     * @return \StructType\ProfilesType
     */
    public function addToProfileInfo(\StructType\ProfileInfo $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ProfileInfo) {
            throw new \InvalidArgumentException(sprintf('The ProfileInfo property can only contain items of type \StructType\ProfileInfo, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ProfileInfo[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ProfilesType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
