<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PaymentFormType_ExtensionsType StructType
 * @subpackage Structs
 */
class PaymentFormType_ExtensionsType extends TPA_ExtensionsType
{
    /**
     * The PaymentInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\PaymentInfoType[]
     */
    public $PaymentInfo;
    /**
     * Constructor method for PaymentFormType_ExtensionsType
     * @uses PaymentFormType_ExtensionsType::setPaymentInfo()
     * @param \StructType\PaymentInfoType[] $paymentInfo
     */
    public function __construct(array $paymentInfo = array())
    {
        $this
            ->setPaymentInfo($paymentInfo);
    }
    /**
     * Get PaymentInfo value
     * @return \StructType\PaymentInfoType[]|null
     */
    public function getPaymentInfo()
    {
        return $this->PaymentInfo;
    }
    /**
     * This method is responsible for validating the values passed to the setPaymentInfo method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPaymentInfo method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePaymentInfoForArrayConstraintsFromSetPaymentInfo(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $paymentFormType_ExtensionsTypePaymentInfoItem) {
            // validation for constraint: itemType
            if (!$paymentFormType_ExtensionsTypePaymentInfoItem instanceof \StructType\PaymentInfoType) {
                $invalidValues[] = is_object($paymentFormType_ExtensionsTypePaymentInfoItem) ? get_class($paymentFormType_ExtensionsTypePaymentInfoItem) : sprintf('%s(%s)', gettype($paymentFormType_ExtensionsTypePaymentInfoItem), var_export($paymentFormType_ExtensionsTypePaymentInfoItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The PaymentInfo property can only contain items of type \StructType\PaymentInfoType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set PaymentInfo value
     * @throws \InvalidArgumentException
     * @param \StructType\PaymentInfoType[] $paymentInfo
     * @return \StructType\PaymentFormType_ExtensionsType
     */
    public function setPaymentInfo(array $paymentInfo = array())
    {
        // validation for constraint: array
        if ('' !== ($paymentInfoArrayErrorMessage = self::validatePaymentInfoForArrayConstraintsFromSetPaymentInfo($paymentInfo))) {
            throw new \InvalidArgumentException($paymentInfoArrayErrorMessage, __LINE__);
        }
        $this->PaymentInfo = $paymentInfo;
        return $this;
    }
    /**
     * Add item to PaymentInfo value
     * @throws \InvalidArgumentException
     * @param \StructType\PaymentInfoType $item
     * @return \StructType\PaymentFormType_ExtensionsType
     */
    public function addToPaymentInfo(\StructType\PaymentInfoType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\PaymentInfoType) {
            throw new \InvalidArgumentException(sprintf('The PaymentInfo property can only contain items of type \StructType\PaymentInfoType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->PaymentInfo[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PaymentFormType_ExtensionsType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
