<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Offer StructType
 * @subpackage Structs
 */
class Offer extends AbstractStructBase
{
    /**
     * The Communication
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Communication[]
     */
    public $Communication;
    /**
     * The Type
     * @var string
     */
    public $Type;
    /**
     * The OfferCode
     * @var string
     */
    public $OfferCode;
    /**
     * Constructor method for Offer
     * @uses Offer::setCommunication()
     * @uses Offer::setType()
     * @uses Offer::setOfferCode()
     * @param \StructType\Communication[] $communication
     * @param string $type
     * @param string $offerCode
     */
    public function __construct(array $communication = array(), $type = null, $offerCode = null)
    {
        $this
            ->setCommunication($communication)
            ->setType($type)
            ->setOfferCode($offerCode);
    }
    /**
     * Get Communication value
     * @return \StructType\Communication[]|null
     */
    public function getCommunication()
    {
        return $this->Communication;
    }
    /**
     * This method is responsible for validating the values passed to the setCommunication method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCommunication method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCommunicationForArrayConstraintsFromSetCommunication(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $offerCommunicationItem) {
            // validation for constraint: itemType
            if (!$offerCommunicationItem instanceof \StructType\Communication) {
                $invalidValues[] = is_object($offerCommunicationItem) ? get_class($offerCommunicationItem) : sprintf('%s(%s)', gettype($offerCommunicationItem), var_export($offerCommunicationItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Communication property can only contain items of type \StructType\Communication, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Communication value
     * @throws \InvalidArgumentException
     * @param \StructType\Communication[] $communication
     * @return \StructType\Offer
     */
    public function setCommunication(array $communication = array())
    {
        // validation for constraint: array
        if ('' !== ($communicationArrayErrorMessage = self::validateCommunicationForArrayConstraintsFromSetCommunication($communication))) {
            throw new \InvalidArgumentException($communicationArrayErrorMessage, __LINE__);
        }
        $this->Communication = $communication;
        return $this;
    }
    /**
     * Add item to Communication value
     * @throws \InvalidArgumentException
     * @param \StructType\Communication $item
     * @return \StructType\Offer
     */
    public function addToCommunication(\StructType\Communication $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Communication) {
            throw new \InvalidArgumentException(sprintf('The Communication property can only contain items of type \StructType\Communication, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Communication[] = $item;
        return $this;
    }
    /**
     * Get Type value
     * @return string|null
     */
    public function getType()
    {
        return $this->Type;
    }
    /**
     * Set Type value
     * @param string $type
     * @return \StructType\Offer
     */
    public function setType($type = null)
    {
        // validation for constraint: string
        if (!is_null($type) && !is_string($type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($type, true), gettype($type)), __LINE__);
        }
        $this->Type = $type;
        return $this;
    }
    /**
     * Get OfferCode value
     * @return string|null
     */
    public function getOfferCode()
    {
        return $this->OfferCode;
    }
    /**
     * Set OfferCode value
     * @param string $offerCode
     * @return \StructType\Offer
     */
    public function setOfferCode($offerCode = null)
    {
        // validation for constraint: string
        if (!is_null($offerCode) && !is_string($offerCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($offerCode, true), gettype($offerCode)), __LINE__);
        }
        $this->OfferCode = $offerCode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Offer
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
