<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for InvCountType StructType
 * @subpackage Structs
 */
class InvCountType extends AbstractStructBase
{
    /**
     * The Inventory
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\BaseInvCountType[]
     */
    public $Inventory;
    /**
     * The UniqueID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\UniqueID_Type
     */
    public $UniqueID;
    /**
     * The HotelCode
     * @var string
     */
    public $HotelCode;
    /**
     * The HotelName
     * @var string
     */
    public $HotelName;
    /**
     * Constructor method for InvCountType
     * @uses InvCountType::setInventory()
     * @uses InvCountType::setUniqueID()
     * @uses InvCountType::setHotelCode()
     * @uses InvCountType::setHotelName()
     * @param \StructType\BaseInvCountType[] $inventory
     * @param \StructType\UniqueID_Type $uniqueID
     * @param string $hotelCode
     * @param string $hotelName
     */
    public function __construct(array $inventory = array(), \StructType\UniqueID_Type $uniqueID = null, $hotelCode = null, $hotelName = null)
    {
        $this
            ->setInventory($inventory)
            ->setUniqueID($uniqueID)
            ->setHotelCode($hotelCode)
            ->setHotelName($hotelName);
    }
    /**
     * Get Inventory value
     * @return \StructType\BaseInvCountType[]|null
     */
    public function getInventory()
    {
        return $this->Inventory;
    }
    /**
     * This method is responsible for validating the values passed to the setInventory method
     * This method is willingly generated in order to preserve the one-line inline validation within the setInventory method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateInventoryForArrayConstraintsFromSetInventory(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $invCountTypeInventoryItem) {
            // validation for constraint: itemType
            if (!$invCountTypeInventoryItem instanceof \StructType\BaseInvCountType) {
                $invalidValues[] = is_object($invCountTypeInventoryItem) ? get_class($invCountTypeInventoryItem) : sprintf('%s(%s)', gettype($invCountTypeInventoryItem), var_export($invCountTypeInventoryItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Inventory property can only contain items of type \StructType\BaseInvCountType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Inventory value
     * @throws \InvalidArgumentException
     * @param \StructType\BaseInvCountType[] $inventory
     * @return \StructType\InvCountType
     */
    public function setInventory(array $inventory = array())
    {
        // validation for constraint: array
        if ('' !== ($inventoryArrayErrorMessage = self::validateInventoryForArrayConstraintsFromSetInventory($inventory))) {
            throw new \InvalidArgumentException($inventoryArrayErrorMessage, __LINE__);
        }
        $this->Inventory = $inventory;
        return $this;
    }
    /**
     * Add item to Inventory value
     * @throws \InvalidArgumentException
     * @param \StructType\BaseInvCountType $item
     * @return \StructType\InvCountType
     */
    public function addToInventory(\StructType\BaseInvCountType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\BaseInvCountType) {
            throw new \InvalidArgumentException(sprintf('The Inventory property can only contain items of type \StructType\BaseInvCountType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Inventory[] = $item;
        return $this;
    }
    /**
     * Get UniqueID value
     * @return \StructType\UniqueID_Type|null
     */
    public function getUniqueID()
    {
        return $this->UniqueID;
    }
    /**
     * Set UniqueID value
     * @param \StructType\UniqueID_Type $uniqueID
     * @return \StructType\InvCountType
     */
    public function setUniqueID(\StructType\UniqueID_Type $uniqueID = null)
    {
        $this->UniqueID = $uniqueID;
        return $this;
    }
    /**
     * Get HotelCode value
     * @return string|null
     */
    public function getHotelCode()
    {
        return $this->HotelCode;
    }
    /**
     * Set HotelCode value
     * @param string $hotelCode
     * @return \StructType\InvCountType
     */
    public function setHotelCode($hotelCode = null)
    {
        // validation for constraint: string
        if (!is_null($hotelCode) && !is_string($hotelCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hotelCode, true), gettype($hotelCode)), __LINE__);
        }
        $this->HotelCode = $hotelCode;
        return $this;
    }
    /**
     * Get HotelName value
     * @return string|null
     */
    public function getHotelName()
    {
        return $this->HotelName;
    }
    /**
     * Set HotelName value
     * @param string $hotelName
     * @return \StructType\InvCountType
     */
    public function setHotelName($hotelName = null)
    {
        // validation for constraint: string
        if (!is_null($hotelName) && !is_string($hotelName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hotelName, true), gettype($hotelName)), __LINE__);
        }
        $this->HotelName = $hotelName;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\InvCountType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
