<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for InvBlockCodeRefType StructType
 * @subpackage Structs
 */
class InvBlockCodeRefType extends AbstractStructBase
{
    /**
     * The HotelRef
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\HotelRef
     */
    public $HotelRef;
    /**
     * The InvBlockCode
     * @var string
     */
    public $InvBlockCode;
    /**
     * The InvBlockGroupingCode
     * @var string
     */
    public $InvBlockGroupingCode;
    /**
     * The InvSystemInvBlockCode
     * @var string
     */
    public $InvSystemInvBlockCode;
    /**
     * The InvSystemInvBlockGroupingCode
     * @var string
     */
    public $InvSystemInvBlockGroupingCode;
    /**
     * Constructor method for InvBlockCodeRefType
     * @uses InvBlockCodeRefType::setHotelRef()
     * @uses InvBlockCodeRefType::setInvBlockCode()
     * @uses InvBlockCodeRefType::setInvBlockGroupingCode()
     * @uses InvBlockCodeRefType::setInvSystemInvBlockCode()
     * @uses InvBlockCodeRefType::setInvSystemInvBlockGroupingCode()
     * @param \StructType\HotelRef $hotelRef
     * @param string $invBlockCode
     * @param string $invBlockGroupingCode
     * @param string $invSystemInvBlockCode
     * @param string $invSystemInvBlockGroupingCode
     */
    public function __construct(\StructType\HotelRef $hotelRef = null, $invBlockCode = null, $invBlockGroupingCode = null, $invSystemInvBlockCode = null, $invSystemInvBlockGroupingCode = null)
    {
        $this
            ->setHotelRef($hotelRef)
            ->setInvBlockCode($invBlockCode)
            ->setInvBlockGroupingCode($invBlockGroupingCode)
            ->setInvSystemInvBlockCode($invSystemInvBlockCode)
            ->setInvSystemInvBlockGroupingCode($invSystemInvBlockGroupingCode);
    }
    /**
     * Get HotelRef value
     * @return \StructType\HotelRef|null
     */
    public function getHotelRef()
    {
        return $this->HotelRef;
    }
    /**
     * Set HotelRef value
     * @param \StructType\HotelRef $hotelRef
     * @return \StructType\InvBlockCodeRefType
     */
    public function setHotelRef(\StructType\HotelRef $hotelRef = null)
    {
        $this->HotelRef = $hotelRef;
        return $this;
    }
    /**
     * Get InvBlockCode value
     * @return string|null
     */
    public function getInvBlockCode()
    {
        return $this->InvBlockCode;
    }
    /**
     * Set InvBlockCode value
     * @param string $invBlockCode
     * @return \StructType\InvBlockCodeRefType
     */
    public function setInvBlockCode($invBlockCode = null)
    {
        // validation for constraint: string
        if (!is_null($invBlockCode) && !is_string($invBlockCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($invBlockCode, true), gettype($invBlockCode)), __LINE__);
        }
        $this->InvBlockCode = $invBlockCode;
        return $this;
    }
    /**
     * Get InvBlockGroupingCode value
     * @return string|null
     */
    public function getInvBlockGroupingCode()
    {
        return $this->InvBlockGroupingCode;
    }
    /**
     * Set InvBlockGroupingCode value
     * @param string $invBlockGroupingCode
     * @return \StructType\InvBlockCodeRefType
     */
    public function setInvBlockGroupingCode($invBlockGroupingCode = null)
    {
        // validation for constraint: string
        if (!is_null($invBlockGroupingCode) && !is_string($invBlockGroupingCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($invBlockGroupingCode, true), gettype($invBlockGroupingCode)), __LINE__);
        }
        $this->InvBlockGroupingCode = $invBlockGroupingCode;
        return $this;
    }
    /**
     * Get InvSystemInvBlockCode value
     * @return string|null
     */
    public function getInvSystemInvBlockCode()
    {
        return $this->InvSystemInvBlockCode;
    }
    /**
     * Set InvSystemInvBlockCode value
     * @param string $invSystemInvBlockCode
     * @return \StructType\InvBlockCodeRefType
     */
    public function setInvSystemInvBlockCode($invSystemInvBlockCode = null)
    {
        // validation for constraint: string
        if (!is_null($invSystemInvBlockCode) && !is_string($invSystemInvBlockCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($invSystemInvBlockCode, true), gettype($invSystemInvBlockCode)), __LINE__);
        }
        $this->InvSystemInvBlockCode = $invSystemInvBlockCode;
        return $this;
    }
    /**
     * Get InvSystemInvBlockGroupingCode value
     * @return string|null
     */
    public function getInvSystemInvBlockGroupingCode()
    {
        return $this->InvSystemInvBlockGroupingCode;
    }
    /**
     * Set InvSystemInvBlockGroupingCode value
     * @param string $invSystemInvBlockGroupingCode
     * @return \StructType\InvBlockCodeRefType
     */
    public function setInvSystemInvBlockGroupingCode($invSystemInvBlockGroupingCode = null)
    {
        // validation for constraint: string
        if (!is_null($invSystemInvBlockGroupingCode) && !is_string($invSystemInvBlockGroupingCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($invSystemInvBlockGroupingCode, true), gettype($invSystemInvBlockGroupingCode)), __LINE__);
        }
        $this->InvSystemInvBlockGroupingCode = $invSystemInvBlockGroupingCode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\InvBlockCodeRefType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
