<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for InvBlock StructType
 * @subpackage Structs
 */
class InvBlock extends InvBlockType
{
    /**
     * The Guarantee
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\GuaranteeType
     */
    public $Guarantee;
    /**
     * The MarketCode
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\MarketCode[]
     */
    public $MarketCode;
    /**
     * Constructor method for InvBlock
     * @uses InvBlock::setGuarantee()
     * @uses InvBlock::setMarketCode()
     * @param \StructType\GuaranteeType $guarantee
     * @param \StructType\MarketCode[] $marketCode
     */
    public function __construct(\StructType\GuaranteeType $guarantee = null, array $marketCode = array())
    {
        $this
            ->setGuarantee($guarantee)
            ->setMarketCode($marketCode);
    }
    /**
     * Get Guarantee value
     * @return \StructType\GuaranteeType|null
     */
    public function getGuarantee()
    {
        return $this->Guarantee;
    }
    /**
     * Set Guarantee value
     * @param \StructType\GuaranteeType $guarantee
     * @return \StructType\InvBlock
     */
    public function setGuarantee(\StructType\GuaranteeType $guarantee = null)
    {
        $this->Guarantee = $guarantee;
        return $this;
    }
    /**
     * Get MarketCode value
     * @return \StructType\MarketCode[]|null
     */
    public function getMarketCode()
    {
        return $this->MarketCode;
    }
    /**
     * This method is responsible for validating the values passed to the setMarketCode method
     * This method is willingly generated in order to preserve the one-line inline validation within the setMarketCode method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateMarketCodeForArrayConstraintsFromSetMarketCode(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $invBlockMarketCodeItem) {
            // validation for constraint: itemType
            if (!$invBlockMarketCodeItem instanceof \StructType\MarketCode) {
                $invalidValues[] = is_object($invBlockMarketCodeItem) ? get_class($invBlockMarketCodeItem) : sprintf('%s(%s)', gettype($invBlockMarketCodeItem), var_export($invBlockMarketCodeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The MarketCode property can only contain items of type \StructType\MarketCode, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set MarketCode value
     * @throws \InvalidArgumentException
     * @param \StructType\MarketCode[] $marketCode
     * @return \StructType\InvBlock
     */
    public function setMarketCode(array $marketCode = array())
    {
        // validation for constraint: array
        if ('' !== ($marketCodeArrayErrorMessage = self::validateMarketCodeForArrayConstraintsFromSetMarketCode($marketCode))) {
            throw new \InvalidArgumentException($marketCodeArrayErrorMessage, __LINE__);
        }
        $this->MarketCode = $marketCode;
        return $this;
    }
    /**
     * Add item to MarketCode value
     * @throws \InvalidArgumentException
     * @param \StructType\MarketCode $item
     * @return \StructType\InvBlock
     */
    public function addToMarketCode(\StructType\MarketCode $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\MarketCode) {
            throw new \InvalidArgumentException(sprintf('The MarketCode property can only contain items of type \StructType\MarketCode, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->MarketCode[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\InvBlock
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
