<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ImageFormat StructType
 * @subpackage Structs
 */
class ImageFormat extends ImageItemType
{
    /**
     * The Language
     * @var string
     */
    public $Language;
    /**
     * The Format
     * @var string
     */
    public $Format;
    /**
     * The FileName
     * @var string
     */
    public $FileName;
    /**
     * The FileSize
     * @var int
     */
    public $FileSize;
    /**
     * The DimensionCategory
     * @var string
     */
    public $DimensionCategory;
    /**
     * The Sort
     * @var int
     */
    public $Sort;
    /**
     * The Resolution
     * @var int
     */
    public $Resolution;
    /**
     * The ColorSpace
     * @var string
     */
    public $ColorSpace;
    /**
     * The Latitude
     * @var string
     */
    public $Latitude;
    /**
     * The Longitude
     * @var string
     */
    public $Longitude;
    /**
     * The OriginalFileName
     * @var string
     */
    public $OriginalFileName;
    /**
     * Constructor method for ImageFormat
     * @uses ImageFormat::setLanguage()
     * @uses ImageFormat::setFormat()
     * @uses ImageFormat::setFileName()
     * @uses ImageFormat::setFileSize()
     * @uses ImageFormat::setDimensionCategory()
     * @uses ImageFormat::setSort()
     * @uses ImageFormat::setResolution()
     * @uses ImageFormat::setColorSpace()
     * @uses ImageFormat::setLatitude()
     * @uses ImageFormat::setLongitude()
     * @uses ImageFormat::setOriginalFileName()
     * @param string $language
     * @param string $format
     * @param string $fileName
     * @param int $fileSize
     * @param string $dimensionCategory
     * @param int $sort
     * @param int $resolution
     * @param string $colorSpace
     * @param string $latitude
     * @param string $longitude
     * @param string $originalFileName
     */
    public function __construct($language = null, $format = null, $fileName = null, $fileSize = null, $dimensionCategory = null, $sort = null, $resolution = null, $colorSpace = null, $latitude = null, $longitude = null, $originalFileName = null)
    {
        $this
            ->setLanguage($language)
            ->setFormat($format)
            ->setFileName($fileName)
            ->setFileSize($fileSize)
            ->setDimensionCategory($dimensionCategory)
            ->setSort($sort)
            ->setResolution($resolution)
            ->setColorSpace($colorSpace)
            ->setLatitude($latitude)
            ->setLongitude($longitude)
            ->setOriginalFileName($originalFileName);
    }
    /**
     * Get Language value
     * @return string|null
     */
    public function getLanguage()
    {
        return $this->Language;
    }
    /**
     * Set Language value
     * @param string $language
     * @return \StructType\ImageFormat
     */
    public function setLanguage($language = null)
    {
        // validation for constraint: string
        if (!is_null($language) && !is_string($language)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($language, true), gettype($language)), __LINE__);
        }
        $this->Language = $language;
        return $this;
    }
    /**
     * Get Format value
     * @return string|null
     */
    public function getFormat()
    {
        return $this->Format;
    }
    /**
     * Set Format value
     * @param string $format
     * @return \StructType\ImageFormat
     */
    public function setFormat($format = null)
    {
        // validation for constraint: string
        if (!is_null($format) && !is_string($format)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($format, true), gettype($format)), __LINE__);
        }
        $this->Format = $format;
        return $this;
    }
    /**
     * Get FileName value
     * @return string|null
     */
    public function getFileName()
    {
        return $this->FileName;
    }
    /**
     * Set FileName value
     * @param string $fileName
     * @return \StructType\ImageFormat
     */
    public function setFileName($fileName = null)
    {
        // validation for constraint: string
        if (!is_null($fileName) && !is_string($fileName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fileName, true), gettype($fileName)), __LINE__);
        }
        $this->FileName = $fileName;
        return $this;
    }
    /**
     * Get FileSize value
     * @return int|null
     */
    public function getFileSize()
    {
        return $this->FileSize;
    }
    /**
     * Set FileSize value
     * @param int $fileSize
     * @return \StructType\ImageFormat
     */
    public function setFileSize($fileSize = null)
    {
        // validation for constraint: int
        if (!is_null($fileSize) && !(is_int($fileSize) || ctype_digit($fileSize))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($fileSize, true), gettype($fileSize)), __LINE__);
        }
        $this->FileSize = $fileSize;
        return $this;
    }
    /**
     * Get DimensionCategory value
     * @return string|null
     */
    public function getDimensionCategory()
    {
        return $this->DimensionCategory;
    }
    /**
     * Set DimensionCategory value
     * @param string $dimensionCategory
     * @return \StructType\ImageFormat
     */
    public function setDimensionCategory($dimensionCategory = null)
    {
        // validation for constraint: string
        if (!is_null($dimensionCategory) && !is_string($dimensionCategory)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dimensionCategory, true), gettype($dimensionCategory)), __LINE__);
        }
        $this->DimensionCategory = $dimensionCategory;
        return $this;
    }
    /**
     * Get Sort value
     * @return int|null
     */
    public function getSort()
    {
        return $this->Sort;
    }
    /**
     * Set Sort value
     * @param int $sort
     * @return \StructType\ImageFormat
     */
    public function setSort($sort = null)
    {
        // validation for constraint: int
        if (!is_null($sort) && !(is_int($sort) || ctype_digit($sort))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($sort, true), gettype($sort)), __LINE__);
        }
        $this->Sort = $sort;
        return $this;
    }
    /**
     * Get Resolution value
     * @return int|null
     */
    public function getResolution()
    {
        return $this->Resolution;
    }
    /**
     * Set Resolution value
     * @param int $resolution
     * @return \StructType\ImageFormat
     */
    public function setResolution($resolution = null)
    {
        // validation for constraint: int
        if (!is_null($resolution) && !(is_int($resolution) || ctype_digit($resolution))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($resolution, true), gettype($resolution)), __LINE__);
        }
        $this->Resolution = $resolution;
        return $this;
    }
    /**
     * Get ColorSpace value
     * @return string|null
     */
    public function getColorSpace()
    {
        return $this->ColorSpace;
    }
    /**
     * Set ColorSpace value
     * @param string $colorSpace
     * @return \StructType\ImageFormat
     */
    public function setColorSpace($colorSpace = null)
    {
        // validation for constraint: string
        if (!is_null($colorSpace) && !is_string($colorSpace)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($colorSpace, true), gettype($colorSpace)), __LINE__);
        }
        $this->ColorSpace = $colorSpace;
        return $this;
    }
    /**
     * Get Latitude value
     * @return string|null
     */
    public function getLatitude()
    {
        return $this->Latitude;
    }
    /**
     * Set Latitude value
     * @param string $latitude
     * @return \StructType\ImageFormat
     */
    public function setLatitude($latitude = null)
    {
        // validation for constraint: string
        if (!is_null($latitude) && !is_string($latitude)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($latitude, true), gettype($latitude)), __LINE__);
        }
        $this->Latitude = $latitude;
        return $this;
    }
    /**
     * Get Longitude value
     * @return string|null
     */
    public function getLongitude()
    {
        return $this->Longitude;
    }
    /**
     * Set Longitude value
     * @param string $longitude
     * @return \StructType\ImageFormat
     */
    public function setLongitude($longitude = null)
    {
        // validation for constraint: string
        if (!is_null($longitude) && !is_string($longitude)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($longitude, true), gettype($longitude)), __LINE__);
        }
        $this->Longitude = $longitude;
        return $this;
    }
    /**
     * Get OriginalFileName value
     * @return string|null
     */
    public function getOriginalFileName()
    {
        return $this->OriginalFileName;
    }
    /**
     * Set OriginalFileName value
     * @param string $originalFileName
     * @return \StructType\ImageFormat
     */
    public function setOriginalFileName($originalFileName = null)
    {
        // validation for constraint: string
        if (!is_null($originalFileName) && !is_string($originalFileName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($originalFileName, true), gettype($originalFileName)), __LINE__);
        }
        $this->OriginalFileName = $originalFileName;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ImageFormat
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
