<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GuaranteePayment StructType
 * @subpackage Structs
 */
class GuaranteePayment extends AbstractStructBase
{
    /**
     * The AcceptedPayments
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfAcceptedPaymentsTypeAcceptedPayment
     */
    public $AcceptedPayments;
    /**
     * The AmountPercent
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\AmountPercent
     */
    public $AmountPercent;
    /**
     * The Deadline
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Deadline[]
     */
    public $Deadline;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\ParagraphType[]
     */
    public $Description;
    /**
     * The Address
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Address[]
     */
    public $Address;
    /**
     * The RetributionType
     * @var string
     */
    public $RetributionType;
    /**
     * The PaymentCode
     * @var string
     */
    public $PaymentCode;
    /**
     * The Type
     * @var string
     */
    public $Type;
    /**
     * The GuaranteeCode
     * @var string
     */
    public $GuaranteeCode;
    /**
     * The GuaranteeType
     * @var string
     */
    public $GuaranteeType;
    /**
     * The HoldTime
     * @var string
     */
    public $HoldTime;
    /**
     * The Mon
     * @var bool
     */
    public $Mon;
    /**
     * The Tue
     * @var bool
     */
    public $Tue;
    /**
     * The Weds
     * @var bool
     */
    public $Weds;
    /**
     * The Thur
     * @var bool
     */
    public $Thur;
    /**
     * The Fri
     * @var bool
     */
    public $Fri;
    /**
     * The Sat
     * @var bool
     */
    public $Sat;
    /**
     * The Sun
     * @var bool
     */
    public $Sun;
    /**
     * The Start
     * @var string
     */
    public $Start;
    /**
     * The Duration
     * @var string
     */
    public $Duration;
    /**
     * The End
     * @var string
     */
    public $End;
    /**
     * The NoCardHolderInfoReqInd
     * @var bool
     */
    public $NoCardHolderInfoReqInd;
    /**
     * The NameInd
     * @var bool
     */
    public $NameInd;
    /**
     * The AddressInd
     * @var bool
     */
    public $AddressInd;
    /**
     * The PhoneInd
     * @var bool
     */
    public $PhoneInd;
    /**
     * The InterbankNbrInd
     * @var bool
     */
    public $InterbankNbrInd;
    /**
     * The RoomTypeCode
     * @var string
     */
    public $RoomTypeCode;
    /**
     * The InfoSource
     * @var string
     */
    public $InfoSource;
    /**
     * The NonRefundableIndicator
     * @var bool
     */
    public $NonRefundableIndicator;
    /**
     * The PolicyCode
     * @var string
     */
    public $PolicyCode;
    /**
     * The AgencyNameAddrReqInd
     * @var bool
     */
    public $AgencyNameAddrReqInd;
    /**
     * The CompanyNameAddrReqInd
     * @var bool
     */
    public $CompanyNameAddrReqInd;
    /**
     * The NoCardHolderInfoRetainInd
     * @var bool
     */
    public $NoCardHolderInfoRetainInd;
    /**
     * The NameRetainInd
     * @var bool
     */
    public $NameRetainInd;
    /**
     * The AddressRetainInd
     * @var bool
     */
    public $AddressRetainInd;
    /**
     * The PhoneRetainInd
     * @var bool
     */
    public $PhoneRetainInd;
    /**
     * Constructor method for GuaranteePayment
     * @uses GuaranteePayment::setAcceptedPayments()
     * @uses GuaranteePayment::setAmountPercent()
     * @uses GuaranteePayment::setDeadline()
     * @uses GuaranteePayment::setDescription()
     * @uses GuaranteePayment::setAddress()
     * @uses GuaranteePayment::setRetributionType()
     * @uses GuaranteePayment::setPaymentCode()
     * @uses GuaranteePayment::setType()
     * @uses GuaranteePayment::setGuaranteeCode()
     * @uses GuaranteePayment::setGuaranteeType()
     * @uses GuaranteePayment::setHoldTime()
     * @uses GuaranteePayment::setMon()
     * @uses GuaranteePayment::setTue()
     * @uses GuaranteePayment::setWeds()
     * @uses GuaranteePayment::setThur()
     * @uses GuaranteePayment::setFri()
     * @uses GuaranteePayment::setSat()
     * @uses GuaranteePayment::setSun()
     * @uses GuaranteePayment::setStart()
     * @uses GuaranteePayment::setDuration()
     * @uses GuaranteePayment::setEnd()
     * @uses GuaranteePayment::setNoCardHolderInfoReqInd()
     * @uses GuaranteePayment::setNameInd()
     * @uses GuaranteePayment::setAddressInd()
     * @uses GuaranteePayment::setPhoneInd()
     * @uses GuaranteePayment::setInterbankNbrInd()
     * @uses GuaranteePayment::setRoomTypeCode()
     * @uses GuaranteePayment::setInfoSource()
     * @uses GuaranteePayment::setNonRefundableIndicator()
     * @uses GuaranteePayment::setPolicyCode()
     * @uses GuaranteePayment::setAgencyNameAddrReqInd()
     * @uses GuaranteePayment::setCompanyNameAddrReqInd()
     * @uses GuaranteePayment::setNoCardHolderInfoRetainInd()
     * @uses GuaranteePayment::setNameRetainInd()
     * @uses GuaranteePayment::setAddressRetainInd()
     * @uses GuaranteePayment::setPhoneRetainInd()
     * @param \ArrayType\ArrayOfAcceptedPaymentsTypeAcceptedPayment $acceptedPayments
     * @param \StructType\AmountPercent $amountPercent
     * @param \StructType\Deadline[] $deadline
     * @param \StructType\ParagraphType[] $description
     * @param \StructType\Address[] $address
     * @param string $retributionType
     * @param string $paymentCode
     * @param string $type
     * @param string $guaranteeCode
     * @param string $guaranteeType
     * @param string $holdTime
     * @param bool $mon
     * @param bool $tue
     * @param bool $weds
     * @param bool $thur
     * @param bool $fri
     * @param bool $sat
     * @param bool $sun
     * @param string $start
     * @param string $duration
     * @param string $end
     * @param bool $noCardHolderInfoReqInd
     * @param bool $nameInd
     * @param bool $addressInd
     * @param bool $phoneInd
     * @param bool $interbankNbrInd
     * @param string $roomTypeCode
     * @param string $infoSource
     * @param bool $nonRefundableIndicator
     * @param string $policyCode
     * @param bool $agencyNameAddrReqInd
     * @param bool $companyNameAddrReqInd
     * @param bool $noCardHolderInfoRetainInd
     * @param bool $nameRetainInd
     * @param bool $addressRetainInd
     * @param bool $phoneRetainInd
     */
    public function __construct(\ArrayType\ArrayOfAcceptedPaymentsTypeAcceptedPayment $acceptedPayments = null, \StructType\AmountPercent $amountPercent = null, array $deadline = array(), array $description = array(), array $address = array(), $retributionType = null, $paymentCode = null, $type = null, $guaranteeCode = null, $guaranteeType = null, $holdTime = null, $mon = null, $tue = null, $weds = null, $thur = null, $fri = null, $sat = null, $sun = null, $start = null, $duration = null, $end = null, $noCardHolderInfoReqInd = null, $nameInd = null, $addressInd = null, $phoneInd = null, $interbankNbrInd = null, $roomTypeCode = null, $infoSource = null, $nonRefundableIndicator = null, $policyCode = null, $agencyNameAddrReqInd = null, $companyNameAddrReqInd = null, $noCardHolderInfoRetainInd = null, $nameRetainInd = null, $addressRetainInd = null, $phoneRetainInd = null)
    {
        $this
            ->setAcceptedPayments($acceptedPayments)
            ->setAmountPercent($amountPercent)
            ->setDeadline($deadline)
            ->setDescription($description)
            ->setAddress($address)
            ->setRetributionType($retributionType)
            ->setPaymentCode($paymentCode)
            ->setType($type)
            ->setGuaranteeCode($guaranteeCode)
            ->setGuaranteeType($guaranteeType)
            ->setHoldTime($holdTime)
            ->setMon($mon)
            ->setTue($tue)
            ->setWeds($weds)
            ->setThur($thur)
            ->setFri($fri)
            ->setSat($sat)
            ->setSun($sun)
            ->setStart($start)
            ->setDuration($duration)
            ->setEnd($end)
            ->setNoCardHolderInfoReqInd($noCardHolderInfoReqInd)
            ->setNameInd($nameInd)
            ->setAddressInd($addressInd)
            ->setPhoneInd($phoneInd)
            ->setInterbankNbrInd($interbankNbrInd)
            ->setRoomTypeCode($roomTypeCode)
            ->setInfoSource($infoSource)
            ->setNonRefundableIndicator($nonRefundableIndicator)
            ->setPolicyCode($policyCode)
            ->setAgencyNameAddrReqInd($agencyNameAddrReqInd)
            ->setCompanyNameAddrReqInd($companyNameAddrReqInd)
            ->setNoCardHolderInfoRetainInd($noCardHolderInfoRetainInd)
            ->setNameRetainInd($nameRetainInd)
            ->setAddressRetainInd($addressRetainInd)
            ->setPhoneRetainInd($phoneRetainInd);
    }
    /**
     * Get AcceptedPayments value
     * @return \ArrayType\ArrayOfAcceptedPaymentsTypeAcceptedPayment|null
     */
    public function getAcceptedPayments()
    {
        return $this->AcceptedPayments;
    }
    /**
     * Set AcceptedPayments value
     * @param \ArrayType\ArrayOfAcceptedPaymentsTypeAcceptedPayment $acceptedPayments
     * @return \StructType\GuaranteePayment
     */
    public function setAcceptedPayments(\ArrayType\ArrayOfAcceptedPaymentsTypeAcceptedPayment $acceptedPayments = null)
    {
        $this->AcceptedPayments = $acceptedPayments;
        return $this;
    }
    /**
     * Get AmountPercent value
     * @return \StructType\AmountPercent|null
     */
    public function getAmountPercent()
    {
        return $this->AmountPercent;
    }
    /**
     * Set AmountPercent value
     * @param \StructType\AmountPercent $amountPercent
     * @return \StructType\GuaranteePayment
     */
    public function setAmountPercent(\StructType\AmountPercent $amountPercent = null)
    {
        $this->AmountPercent = $amountPercent;
        return $this;
    }
    /**
     * Get Deadline value
     * @return \StructType\Deadline[]|null
     */
    public function getDeadline()
    {
        return $this->Deadline;
    }
    /**
     * This method is responsible for validating the values passed to the setDeadline method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDeadline method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDeadlineForArrayConstraintsFromSetDeadline(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $guaranteePaymentDeadlineItem) {
            // validation for constraint: itemType
            if (!$guaranteePaymentDeadlineItem instanceof \StructType\Deadline) {
                $invalidValues[] = is_object($guaranteePaymentDeadlineItem) ? get_class($guaranteePaymentDeadlineItem) : sprintf('%s(%s)', gettype($guaranteePaymentDeadlineItem), var_export($guaranteePaymentDeadlineItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Deadline property can only contain items of type \StructType\Deadline, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Deadline value
     * @throws \InvalidArgumentException
     * @param \StructType\Deadline[] $deadline
     * @return \StructType\GuaranteePayment
     */
    public function setDeadline(array $deadline = array())
    {
        // validation for constraint: array
        if ('' !== ($deadlineArrayErrorMessage = self::validateDeadlineForArrayConstraintsFromSetDeadline($deadline))) {
            throw new \InvalidArgumentException($deadlineArrayErrorMessage, __LINE__);
        }
        $this->Deadline = $deadline;
        return $this;
    }
    /**
     * Add item to Deadline value
     * @throws \InvalidArgumentException
     * @param \StructType\Deadline $item
     * @return \StructType\GuaranteePayment
     */
    public function addToDeadline(\StructType\Deadline $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Deadline) {
            throw new \InvalidArgumentException(sprintf('The Deadline property can only contain items of type \StructType\Deadline, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Deadline[] = $item;
        return $this;
    }
    /**
     * Get Description value
     * @return \StructType\ParagraphType[]|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * This method is responsible for validating the values passed to the setDescription method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDescription method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDescriptionForArrayConstraintsFromSetDescription(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $guaranteePaymentDescriptionItem) {
            // validation for constraint: itemType
            if (!$guaranteePaymentDescriptionItem instanceof \StructType\ParagraphType) {
                $invalidValues[] = is_object($guaranteePaymentDescriptionItem) ? get_class($guaranteePaymentDescriptionItem) : sprintf('%s(%s)', gettype($guaranteePaymentDescriptionItem), var_export($guaranteePaymentDescriptionItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Description property can only contain items of type \StructType\ParagraphType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Description value
     * @throws \InvalidArgumentException
     * @param \StructType\ParagraphType[] $description
     * @return \StructType\GuaranteePayment
     */
    public function setDescription(array $description = array())
    {
        // validation for constraint: array
        if ('' !== ($descriptionArrayErrorMessage = self::validateDescriptionForArrayConstraintsFromSetDescription($description))) {
            throw new \InvalidArgumentException($descriptionArrayErrorMessage, __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Add item to Description value
     * @throws \InvalidArgumentException
     * @param \StructType\ParagraphType $item
     * @return \StructType\GuaranteePayment
     */
    public function addToDescription(\StructType\ParagraphType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ParagraphType) {
            throw new \InvalidArgumentException(sprintf('The Description property can only contain items of type \StructType\ParagraphType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Description[] = $item;
        return $this;
    }
    /**
     * Get Address value
     * @return \StructType\Address[]|null
     */
    public function getAddress()
    {
        return $this->Address;
    }
    /**
     * This method is responsible for validating the values passed to the setAddress method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAddress method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAddressForArrayConstraintsFromSetAddress(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $guaranteePaymentAddressItem) {
            // validation for constraint: itemType
            if (!$guaranteePaymentAddressItem instanceof \StructType\Address) {
                $invalidValues[] = is_object($guaranteePaymentAddressItem) ? get_class($guaranteePaymentAddressItem) : sprintf('%s(%s)', gettype($guaranteePaymentAddressItem), var_export($guaranteePaymentAddressItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Address property can only contain items of type \StructType\Address, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Address value
     * @throws \InvalidArgumentException
     * @param \StructType\Address[] $address
     * @return \StructType\GuaranteePayment
     */
    public function setAddress(array $address = array())
    {
        // validation for constraint: array
        if ('' !== ($addressArrayErrorMessage = self::validateAddressForArrayConstraintsFromSetAddress($address))) {
            throw new \InvalidArgumentException($addressArrayErrorMessage, __LINE__);
        }
        $this->Address = $address;
        return $this;
    }
    /**
     * Add item to Address value
     * @throws \InvalidArgumentException
     * @param \StructType\Address $item
     * @return \StructType\GuaranteePayment
     */
    public function addToAddress(\StructType\Address $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Address) {
            throw new \InvalidArgumentException(sprintf('The Address property can only contain items of type \StructType\Address, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Address[] = $item;
        return $this;
    }
    /**
     * Get RetributionType value
     * @return string|null
     */
    public function getRetributionType()
    {
        return $this->RetributionType;
    }
    /**
     * Set RetributionType value
     * @param string $retributionType
     * @return \StructType\GuaranteePayment
     */
    public function setRetributionType($retributionType = null)
    {
        // validation for constraint: string
        if (!is_null($retributionType) && !is_string($retributionType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($retributionType, true), gettype($retributionType)), __LINE__);
        }
        $this->RetributionType = $retributionType;
        return $this;
    }
    /**
     * Get PaymentCode value
     * @return string|null
     */
    public function getPaymentCode()
    {
        return $this->PaymentCode;
    }
    /**
     * Set PaymentCode value
     * @param string $paymentCode
     * @return \StructType\GuaranteePayment
     */
    public function setPaymentCode($paymentCode = null)
    {
        // validation for constraint: string
        if (!is_null($paymentCode) && !is_string($paymentCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentCode, true), gettype($paymentCode)), __LINE__);
        }
        $this->PaymentCode = $paymentCode;
        return $this;
    }
    /**
     * Get Type value
     * @return string|null
     */
    public function getType()
    {
        return $this->Type;
    }
    /**
     * Set Type value
     * @param string $type
     * @return \StructType\GuaranteePayment
     */
    public function setType($type = null)
    {
        // validation for constraint: string
        if (!is_null($type) && !is_string($type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($type, true), gettype($type)), __LINE__);
        }
        $this->Type = $type;
        return $this;
    }
    /**
     * Get GuaranteeCode value
     * @return string|null
     */
    public function getGuaranteeCode()
    {
        return $this->GuaranteeCode;
    }
    /**
     * Set GuaranteeCode value
     * @param string $guaranteeCode
     * @return \StructType\GuaranteePayment
     */
    public function setGuaranteeCode($guaranteeCode = null)
    {
        // validation for constraint: string
        if (!is_null($guaranteeCode) && !is_string($guaranteeCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($guaranteeCode, true), gettype($guaranteeCode)), __LINE__);
        }
        $this->GuaranteeCode = $guaranteeCode;
        return $this;
    }
    /**
     * Get GuaranteeType value
     * @return string|null
     */
    public function getGuaranteeType()
    {
        return $this->GuaranteeType;
    }
    /**
     * Set GuaranteeType value
     * @param string $guaranteeType
     * @return \StructType\GuaranteePayment
     */
    public function setGuaranteeType($guaranteeType = null)
    {
        // validation for constraint: string
        if (!is_null($guaranteeType) && !is_string($guaranteeType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($guaranteeType, true), gettype($guaranteeType)), __LINE__);
        }
        $this->GuaranteeType = $guaranteeType;
        return $this;
    }
    /**
     * Get HoldTime value
     * @return string|null
     */
    public function getHoldTime()
    {
        return $this->HoldTime;
    }
    /**
     * Set HoldTime value
     * @param string $holdTime
     * @return \StructType\GuaranteePayment
     */
    public function setHoldTime($holdTime = null)
    {
        // validation for constraint: string
        if (!is_null($holdTime) && !is_string($holdTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($holdTime, true), gettype($holdTime)), __LINE__);
        }
        $this->HoldTime = $holdTime;
        return $this;
    }
    /**
     * Get Mon value
     * @return bool|null
     */
    public function getMon()
    {
        return $this->Mon;
    }
    /**
     * Set Mon value
     * @param bool $mon
     * @return \StructType\GuaranteePayment
     */
    public function setMon($mon = null)
    {
        // validation for constraint: boolean
        if (!is_null($mon) && !is_bool($mon)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($mon, true), gettype($mon)), __LINE__);
        }
        $this->Mon = $mon;
        return $this;
    }
    /**
     * Get Tue value
     * @return bool|null
     */
    public function getTue()
    {
        return $this->Tue;
    }
    /**
     * Set Tue value
     * @param bool $tue
     * @return \StructType\GuaranteePayment
     */
    public function setTue($tue = null)
    {
        // validation for constraint: boolean
        if (!is_null($tue) && !is_bool($tue)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($tue, true), gettype($tue)), __LINE__);
        }
        $this->Tue = $tue;
        return $this;
    }
    /**
     * Get Weds value
     * @return bool|null
     */
    public function getWeds()
    {
        return $this->Weds;
    }
    /**
     * Set Weds value
     * @param bool $weds
     * @return \StructType\GuaranteePayment
     */
    public function setWeds($weds = null)
    {
        // validation for constraint: boolean
        if (!is_null($weds) && !is_bool($weds)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($weds, true), gettype($weds)), __LINE__);
        }
        $this->Weds = $weds;
        return $this;
    }
    /**
     * Get Thur value
     * @return bool|null
     */
    public function getThur()
    {
        return $this->Thur;
    }
    /**
     * Set Thur value
     * @param bool $thur
     * @return \StructType\GuaranteePayment
     */
    public function setThur($thur = null)
    {
        // validation for constraint: boolean
        if (!is_null($thur) && !is_bool($thur)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($thur, true), gettype($thur)), __LINE__);
        }
        $this->Thur = $thur;
        return $this;
    }
    /**
     * Get Fri value
     * @return bool|null
     */
    public function getFri()
    {
        return $this->Fri;
    }
    /**
     * Set Fri value
     * @param bool $fri
     * @return \StructType\GuaranteePayment
     */
    public function setFri($fri = null)
    {
        // validation for constraint: boolean
        if (!is_null($fri) && !is_bool($fri)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($fri, true), gettype($fri)), __LINE__);
        }
        $this->Fri = $fri;
        return $this;
    }
    /**
     * Get Sat value
     * @return bool|null
     */
    public function getSat()
    {
        return $this->Sat;
    }
    /**
     * Set Sat value
     * @param bool $sat
     * @return \StructType\GuaranteePayment
     */
    public function setSat($sat = null)
    {
        // validation for constraint: boolean
        if (!is_null($sat) && !is_bool($sat)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($sat, true), gettype($sat)), __LINE__);
        }
        $this->Sat = $sat;
        return $this;
    }
    /**
     * Get Sun value
     * @return bool|null
     */
    public function getSun()
    {
        return $this->Sun;
    }
    /**
     * Set Sun value
     * @param bool $sun
     * @return \StructType\GuaranteePayment
     */
    public function setSun($sun = null)
    {
        // validation for constraint: boolean
        if (!is_null($sun) && !is_bool($sun)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($sun, true), gettype($sun)), __LINE__);
        }
        $this->Sun = $sun;
        return $this;
    }
    /**
     * Get Start value
     * @return string|null
     */
    public function getStart()
    {
        return $this->Start;
    }
    /**
     * Set Start value
     * @param string $start
     * @return \StructType\GuaranteePayment
     */
    public function setStart($start = null)
    {
        // validation for constraint: string
        if (!is_null($start) && !is_string($start)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($start, true), gettype($start)), __LINE__);
        }
        $this->Start = $start;
        return $this;
    }
    /**
     * Get Duration value
     * @return string|null
     */
    public function getDuration()
    {
        return $this->Duration;
    }
    /**
     * Set Duration value
     * @param string $duration
     * @return \StructType\GuaranteePayment
     */
    public function setDuration($duration = null)
    {
        // validation for constraint: string
        if (!is_null($duration) && !is_string($duration)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($duration, true), gettype($duration)), __LINE__);
        }
        $this->Duration = $duration;
        return $this;
    }
    /**
     * Get End value
     * @return string|null
     */
    public function getEnd()
    {
        return $this->End;
    }
    /**
     * Set End value
     * @param string $end
     * @return \StructType\GuaranteePayment
     */
    public function setEnd($end = null)
    {
        // validation for constraint: string
        if (!is_null($end) && !is_string($end)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($end, true), gettype($end)), __LINE__);
        }
        $this->End = $end;
        return $this;
    }
    /**
     * Get NoCardHolderInfoReqInd value
     * @return bool|null
     */
    public function getNoCardHolderInfoReqInd()
    {
        return $this->NoCardHolderInfoReqInd;
    }
    /**
     * Set NoCardHolderInfoReqInd value
     * @param bool $noCardHolderInfoReqInd
     * @return \StructType\GuaranteePayment
     */
    public function setNoCardHolderInfoReqInd($noCardHolderInfoReqInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($noCardHolderInfoReqInd) && !is_bool($noCardHolderInfoReqInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($noCardHolderInfoReqInd, true), gettype($noCardHolderInfoReqInd)), __LINE__);
        }
        $this->NoCardHolderInfoReqInd = $noCardHolderInfoReqInd;
        return $this;
    }
    /**
     * Get NameInd value
     * @return bool|null
     */
    public function getNameInd()
    {
        return $this->NameInd;
    }
    /**
     * Set NameInd value
     * @param bool $nameInd
     * @return \StructType\GuaranteePayment
     */
    public function setNameInd($nameInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($nameInd) && !is_bool($nameInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($nameInd, true), gettype($nameInd)), __LINE__);
        }
        $this->NameInd = $nameInd;
        return $this;
    }
    /**
     * Get AddressInd value
     * @return bool|null
     */
    public function getAddressInd()
    {
        return $this->AddressInd;
    }
    /**
     * Set AddressInd value
     * @param bool $addressInd
     * @return \StructType\GuaranteePayment
     */
    public function setAddressInd($addressInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($addressInd) && !is_bool($addressInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($addressInd, true), gettype($addressInd)), __LINE__);
        }
        $this->AddressInd = $addressInd;
        return $this;
    }
    /**
     * Get PhoneInd value
     * @return bool|null
     */
    public function getPhoneInd()
    {
        return $this->PhoneInd;
    }
    /**
     * Set PhoneInd value
     * @param bool $phoneInd
     * @return \StructType\GuaranteePayment
     */
    public function setPhoneInd($phoneInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($phoneInd) && !is_bool($phoneInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($phoneInd, true), gettype($phoneInd)), __LINE__);
        }
        $this->PhoneInd = $phoneInd;
        return $this;
    }
    /**
     * Get InterbankNbrInd value
     * @return bool|null
     */
    public function getInterbankNbrInd()
    {
        return $this->InterbankNbrInd;
    }
    /**
     * Set InterbankNbrInd value
     * @param bool $interbankNbrInd
     * @return \StructType\GuaranteePayment
     */
    public function setInterbankNbrInd($interbankNbrInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($interbankNbrInd) && !is_bool($interbankNbrInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($interbankNbrInd, true), gettype($interbankNbrInd)), __LINE__);
        }
        $this->InterbankNbrInd = $interbankNbrInd;
        return $this;
    }
    /**
     * Get RoomTypeCode value
     * @return string|null
     */
    public function getRoomTypeCode()
    {
        return $this->RoomTypeCode;
    }
    /**
     * Set RoomTypeCode value
     * @param string $roomTypeCode
     * @return \StructType\GuaranteePayment
     */
    public function setRoomTypeCode($roomTypeCode = null)
    {
        // validation for constraint: string
        if (!is_null($roomTypeCode) && !is_string($roomTypeCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($roomTypeCode, true), gettype($roomTypeCode)), __LINE__);
        }
        $this->RoomTypeCode = $roomTypeCode;
        return $this;
    }
    /**
     * Get InfoSource value
     * @return string|null
     */
    public function getInfoSource()
    {
        return $this->InfoSource;
    }
    /**
     * Set InfoSource value
     * @param string $infoSource
     * @return \StructType\GuaranteePayment
     */
    public function setInfoSource($infoSource = null)
    {
        // validation for constraint: string
        if (!is_null($infoSource) && !is_string($infoSource)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($infoSource, true), gettype($infoSource)), __LINE__);
        }
        $this->InfoSource = $infoSource;
        return $this;
    }
    /**
     * Get NonRefundableIndicator value
     * @return bool|null
     */
    public function getNonRefundableIndicator()
    {
        return $this->NonRefundableIndicator;
    }
    /**
     * Set NonRefundableIndicator value
     * @param bool $nonRefundableIndicator
     * @return \StructType\GuaranteePayment
     */
    public function setNonRefundableIndicator($nonRefundableIndicator = null)
    {
        // validation for constraint: boolean
        if (!is_null($nonRefundableIndicator) && !is_bool($nonRefundableIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($nonRefundableIndicator, true), gettype($nonRefundableIndicator)), __LINE__);
        }
        $this->NonRefundableIndicator = $nonRefundableIndicator;
        return $this;
    }
    /**
     * Get PolicyCode value
     * @return string|null
     */
    public function getPolicyCode()
    {
        return $this->PolicyCode;
    }
    /**
     * Set PolicyCode value
     * @param string $policyCode
     * @return \StructType\GuaranteePayment
     */
    public function setPolicyCode($policyCode = null)
    {
        // validation for constraint: string
        if (!is_null($policyCode) && !is_string($policyCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($policyCode, true), gettype($policyCode)), __LINE__);
        }
        $this->PolicyCode = $policyCode;
        return $this;
    }
    /**
     * Get AgencyNameAddrReqInd value
     * @return bool|null
     */
    public function getAgencyNameAddrReqInd()
    {
        return $this->AgencyNameAddrReqInd;
    }
    /**
     * Set AgencyNameAddrReqInd value
     * @param bool $agencyNameAddrReqInd
     * @return \StructType\GuaranteePayment
     */
    public function setAgencyNameAddrReqInd($agencyNameAddrReqInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($agencyNameAddrReqInd) && !is_bool($agencyNameAddrReqInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($agencyNameAddrReqInd, true), gettype($agencyNameAddrReqInd)), __LINE__);
        }
        $this->AgencyNameAddrReqInd = $agencyNameAddrReqInd;
        return $this;
    }
    /**
     * Get CompanyNameAddrReqInd value
     * @return bool|null
     */
    public function getCompanyNameAddrReqInd()
    {
        return $this->CompanyNameAddrReqInd;
    }
    /**
     * Set CompanyNameAddrReqInd value
     * @param bool $companyNameAddrReqInd
     * @return \StructType\GuaranteePayment
     */
    public function setCompanyNameAddrReqInd($companyNameAddrReqInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($companyNameAddrReqInd) && !is_bool($companyNameAddrReqInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($companyNameAddrReqInd, true), gettype($companyNameAddrReqInd)), __LINE__);
        }
        $this->CompanyNameAddrReqInd = $companyNameAddrReqInd;
        return $this;
    }
    /**
     * Get NoCardHolderInfoRetainInd value
     * @return bool|null
     */
    public function getNoCardHolderInfoRetainInd()
    {
        return $this->NoCardHolderInfoRetainInd;
    }
    /**
     * Set NoCardHolderInfoRetainInd value
     * @param bool $noCardHolderInfoRetainInd
     * @return \StructType\GuaranteePayment
     */
    public function setNoCardHolderInfoRetainInd($noCardHolderInfoRetainInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($noCardHolderInfoRetainInd) && !is_bool($noCardHolderInfoRetainInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($noCardHolderInfoRetainInd, true), gettype($noCardHolderInfoRetainInd)), __LINE__);
        }
        $this->NoCardHolderInfoRetainInd = $noCardHolderInfoRetainInd;
        return $this;
    }
    /**
     * Get NameRetainInd value
     * @return bool|null
     */
    public function getNameRetainInd()
    {
        return $this->NameRetainInd;
    }
    /**
     * Set NameRetainInd value
     * @param bool $nameRetainInd
     * @return \StructType\GuaranteePayment
     */
    public function setNameRetainInd($nameRetainInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($nameRetainInd) && !is_bool($nameRetainInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($nameRetainInd, true), gettype($nameRetainInd)), __LINE__);
        }
        $this->NameRetainInd = $nameRetainInd;
        return $this;
    }
    /**
     * Get AddressRetainInd value
     * @return bool|null
     */
    public function getAddressRetainInd()
    {
        return $this->AddressRetainInd;
    }
    /**
     * Set AddressRetainInd value
     * @param bool $addressRetainInd
     * @return \StructType\GuaranteePayment
     */
    public function setAddressRetainInd($addressRetainInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($addressRetainInd) && !is_bool($addressRetainInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($addressRetainInd, true), gettype($addressRetainInd)), __LINE__);
        }
        $this->AddressRetainInd = $addressRetainInd;
        return $this;
    }
    /**
     * Get PhoneRetainInd value
     * @return bool|null
     */
    public function getPhoneRetainInd()
    {
        return $this->PhoneRetainInd;
    }
    /**
     * Set PhoneRetainInd value
     * @param bool $phoneRetainInd
     * @return \StructType\GuaranteePayment
     */
    public function setPhoneRetainInd($phoneRetainInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($phoneRetainInd) && !is_bool($phoneRetainInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($phoneRetainInd, true), gettype($phoneRetainInd)), __LINE__);
        }
        $this->PhoneRetainInd = $phoneRetainInd;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GuaranteePayment
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
