<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DirectBillType StructType
 * @subpackage Structs
 */
class DirectBillType extends AbstractStructBase
{
    /**
     * The CompanyName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\CompanyName
     */
    public $CompanyName;
    /**
     * The Address
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\AddressInfoType
     */
    public $Address;
    /**
     * The Email
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\EmailType
     */
    public $Email;
    /**
     * The Telephone
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Telephone
     */
    public $Telephone;
    /**
     * The ShareSynchInd
     * @var string
     */
    public $ShareSynchInd;
    /**
     * The ShareMarketInd
     * @var string
     */
    public $ShareMarketInd;
    /**
     * The DirectBill_ID
     * @var string
     */
    public $DirectBill_ID;
    /**
     * The BillingNumber
     * @var string
     */
    public $BillingNumber;
    /**
     * Constructor method for DirectBillType
     * @uses DirectBillType::setCompanyName()
     * @uses DirectBillType::setAddress()
     * @uses DirectBillType::setEmail()
     * @uses DirectBillType::setTelephone()
     * @uses DirectBillType::setShareSynchInd()
     * @uses DirectBillType::setShareMarketInd()
     * @uses DirectBillType::setDirectBill_ID()
     * @uses DirectBillType::setBillingNumber()
     * @param \StructType\CompanyName $companyName
     * @param \StructType\AddressInfoType $address
     * @param \StructType\EmailType $email
     * @param \StructType\Telephone $telephone
     * @param string $shareSynchInd
     * @param string $shareMarketInd
     * @param string $directBill_ID
     * @param string $billingNumber
     */
    public function __construct(\StructType\CompanyName $companyName = null, \StructType\AddressInfoType $address = null, \StructType\EmailType $email = null, \StructType\Telephone $telephone = null, $shareSynchInd = null, $shareMarketInd = null, $directBill_ID = null, $billingNumber = null)
    {
        $this
            ->setCompanyName($companyName)
            ->setAddress($address)
            ->setEmail($email)
            ->setTelephone($telephone)
            ->setShareSynchInd($shareSynchInd)
            ->setShareMarketInd($shareMarketInd)
            ->setDirectBill_ID($directBill_ID)
            ->setBillingNumber($billingNumber);
    }
    /**
     * Get CompanyName value
     * @return \StructType\CompanyName|null
     */
    public function getCompanyName()
    {
        return $this->CompanyName;
    }
    /**
     * Set CompanyName value
     * @param \StructType\CompanyName $companyName
     * @return \StructType\DirectBillType
     */
    public function setCompanyName(\StructType\CompanyName $companyName = null)
    {
        $this->CompanyName = $companyName;
        return $this;
    }
    /**
     * Get Address value
     * @return \StructType\AddressInfoType|null
     */
    public function getAddress()
    {
        return $this->Address;
    }
    /**
     * Set Address value
     * @param \StructType\AddressInfoType $address
     * @return \StructType\DirectBillType
     */
    public function setAddress(\StructType\AddressInfoType $address = null)
    {
        $this->Address = $address;
        return $this;
    }
    /**
     * Get Email value
     * @return \StructType\EmailType|null
     */
    public function getEmail()
    {
        return $this->Email;
    }
    /**
     * Set Email value
     * @param \StructType\EmailType $email
     * @return \StructType\DirectBillType
     */
    public function setEmail(\StructType\EmailType $email = null)
    {
        $this->Email = $email;
        return $this;
    }
    /**
     * Get Telephone value
     * @return \StructType\Telephone|null
     */
    public function getTelephone()
    {
        return $this->Telephone;
    }
    /**
     * Set Telephone value
     * @param \StructType\Telephone $telephone
     * @return \StructType\DirectBillType
     */
    public function setTelephone(\StructType\Telephone $telephone = null)
    {
        $this->Telephone = $telephone;
        return $this;
    }
    /**
     * Get ShareSynchInd value
     * @return string|null
     */
    public function getShareSynchInd()
    {
        return $this->ShareSynchInd;
    }
    /**
     * Set ShareSynchInd value
     * @param string $shareSynchInd
     * @return \StructType\DirectBillType
     */
    public function setShareSynchInd($shareSynchInd = null)
    {
        // validation for constraint: string
        if (!is_null($shareSynchInd) && !is_string($shareSynchInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shareSynchInd, true), gettype($shareSynchInd)), __LINE__);
        }
        $this->ShareSynchInd = $shareSynchInd;
        return $this;
    }
    /**
     * Get ShareMarketInd value
     * @return string|null
     */
    public function getShareMarketInd()
    {
        return $this->ShareMarketInd;
    }
    /**
     * Set ShareMarketInd value
     * @param string $shareMarketInd
     * @return \StructType\DirectBillType
     */
    public function setShareMarketInd($shareMarketInd = null)
    {
        // validation for constraint: string
        if (!is_null($shareMarketInd) && !is_string($shareMarketInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shareMarketInd, true), gettype($shareMarketInd)), __LINE__);
        }
        $this->ShareMarketInd = $shareMarketInd;
        return $this;
    }
    /**
     * Get DirectBill_ID value
     * @return string|null
     */
    public function getDirectBill_ID()
    {
        return $this->DirectBill_ID;
    }
    /**
     * Set DirectBill_ID value
     * @param string $directBill_ID
     * @return \StructType\DirectBillType
     */
    public function setDirectBill_ID($directBill_ID = null)
    {
        // validation for constraint: string
        if (!is_null($directBill_ID) && !is_string($directBill_ID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($directBill_ID, true), gettype($directBill_ID)), __LINE__);
        }
        $this->DirectBill_ID = $directBill_ID;
        return $this;
    }
    /**
     * Get BillingNumber value
     * @return string|null
     */
    public function getBillingNumber()
    {
        return $this->BillingNumber;
    }
    /**
     * Set BillingNumber value
     * @param string $billingNumber
     * @return \StructType\DirectBillType
     */
    public function setBillingNumber($billingNumber = null)
    {
        // validation for constraint: string
        if (!is_null($billingNumber) && !is_string($billingNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($billingNumber, true), gettype($billingNumber)), __LINE__);
        }
        $this->BillingNumber = $billingNumber;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\DirectBillType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
