<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Profile ServiceType
 * @subpackage Services
 */
class Profile extends AbstractSoapClientBase
{
    /**
     * Sets the Security SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param Security $security
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderSecurity(Security $security, $nameSpace = 'http://tempuri.org/', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'Security', $security, $mustUnderstand, $actor);
    }
    /**
     * Method to call the operation originally named ProfileCreateRQ
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Security
     * - SOAPHeaderNamespaces: http://tempuri.org/
     * - SOAPHeaderTypes: Security
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\OTA_ProfileCreateRQ $oTA_ProfileCreateRQ
     * @return \StructType\OTA_ProfileCreateRS|bool
     */
    public function ProfileCreateRQ(\StructType\OTA_ProfileCreateRQ $oTA_ProfileCreateRQ)
    {
        try {
            $this->setResult($this->getSoapClient()->ProfileCreateRQ($oTA_ProfileCreateRQ));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\OTA_ProfileCreateRS
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
