<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TypeRoom StructType
 * @subpackage Structs
 */
class TypeRoom extends AbstractStructBase
{
    /**
     * The StandardOccupancy
     * @var int
     */
    public $StandardOccupancy;
    /**
     * The MaxRollaways
     * @var int
     */
    public $MaxRollaways;
    /**
     * Constructor method for TypeRoom
     * @uses TypeRoom::setStandardOccupancy()
     * @uses TypeRoom::setMaxRollaways()
     * @param int $standardOccupancy
     * @param int $maxRollaways
     */
    public function __construct($standardOccupancy = null, $maxRollaways = null)
    {
        $this
            ->setStandardOccupancy($standardOccupancy)
            ->setMaxRollaways($maxRollaways);
    }
    /**
     * Get StandardOccupancy value
     * @return int|null
     */
    public function getStandardOccupancy()
    {
        return $this->StandardOccupancy;
    }
    /**
     * Set StandardOccupancy value
     * @param int $standardOccupancy
     * @return \StructType\TypeRoom
     */
    public function setStandardOccupancy($standardOccupancy = null)
    {
        // validation for constraint: int
        if (!is_null($standardOccupancy) && !(is_int($standardOccupancy) || ctype_digit($standardOccupancy))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($standardOccupancy, true), gettype($standardOccupancy)), __LINE__);
        }
        $this->StandardOccupancy = $standardOccupancy;
        return $this;
    }
    /**
     * Get MaxRollaways value
     * @return int|null
     */
    public function getMaxRollaways()
    {
        return $this->MaxRollaways;
    }
    /**
     * Set MaxRollaways value
     * @param int $maxRollaways
     * @return \StructType\TypeRoom
     */
    public function setMaxRollaways($maxRollaways = null)
    {
        // validation for constraint: int
        if (!is_null($maxRollaways) && !(is_int($maxRollaways) || ctype_digit($maxRollaways))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($maxRollaways, true), gettype($maxRollaways)), __LINE__);
        }
        $this->MaxRollaways = $maxRollaways;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\TypeRoom
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
