<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SourceType StructType
 * @subpackage Structs
 */
class SourceType extends AbstractStructBase
{
    /**
     * The RequestorID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\RequestorID
     */
    public $RequestorID;
    /**
     * The BookingChannel
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\BookingChannel
     */
    public $BookingChannel;
    /**
     * Constructor method for SourceType
     * @uses SourceType::setRequestorID()
     * @uses SourceType::setBookingChannel()
     * @param \StructType\RequestorID $requestorID
     * @param \StructType\BookingChannel $bookingChannel
     */
    public function __construct(\StructType\RequestorID $requestorID = null, \StructType\BookingChannel $bookingChannel = null)
    {
        $this
            ->setRequestorID($requestorID)
            ->setBookingChannel($bookingChannel);
    }
    /**
     * Get RequestorID value
     * @return \StructType\RequestorID|null
     */
    public function getRequestorID()
    {
        return $this->RequestorID;
    }
    /**
     * Set RequestorID value
     * @param \StructType\RequestorID $requestorID
     * @return \StructType\SourceType
     */
    public function setRequestorID(\StructType\RequestorID $requestorID = null)
    {
        $this->RequestorID = $requestorID;
        return $this;
    }
    /**
     * Get BookingChannel value
     * @return \StructType\BookingChannel|null
     */
    public function getBookingChannel()
    {
        return $this->BookingChannel;
    }
    /**
     * Set BookingChannel value
     * @param \StructType\BookingChannel $bookingChannel
     * @return \StructType\SourceType
     */
    public function setBookingChannel(\StructType\BookingChannel $bookingChannel = null)
    {
        $this->BookingChannel = $bookingChannel;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SourceType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
