<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SecurityInfo StructType
 * @subpackage Structs
 */
class SecurityInfo extends AbstractStructBase
{
    /**
     * The PasswordHint
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\PasswordHint[]
     */
    public $PasswordHint;
    /**
     * The Username
     * @var string
     */
    public $Username;
    /**
     * The Password
     * @var string
     */
    public $Password;
    /**
     * Constructor method for SecurityInfo
     * @uses SecurityInfo::setPasswordHint()
     * @uses SecurityInfo::setUsername()
     * @uses SecurityInfo::setPassword()
     * @param \StructType\PasswordHint[] $passwordHint
     * @param string $username
     * @param string $password
     */
    public function __construct(array $passwordHint = array(), $username = null, $password = null)
    {
        $this
            ->setPasswordHint($passwordHint)
            ->setUsername($username)
            ->setPassword($password);
    }
    /**
     * Get PasswordHint value
     * @return \StructType\PasswordHint[]|null
     */
    public function getPasswordHint()
    {
        return $this->PasswordHint;
    }
    /**
     * This method is responsible for validating the values passed to the setPasswordHint method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPasswordHint method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePasswordHintForArrayConstraintsFromSetPasswordHint(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $securityInfoPasswordHintItem) {
            // validation for constraint: itemType
            if (!$securityInfoPasswordHintItem instanceof \StructType\PasswordHint) {
                $invalidValues[] = is_object($securityInfoPasswordHintItem) ? get_class($securityInfoPasswordHintItem) : sprintf('%s(%s)', gettype($securityInfoPasswordHintItem), var_export($securityInfoPasswordHintItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The PasswordHint property can only contain items of type \StructType\PasswordHint, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set PasswordHint value
     * @throws \InvalidArgumentException
     * @param \StructType\PasswordHint[] $passwordHint
     * @return \StructType\SecurityInfo
     */
    public function setPasswordHint(array $passwordHint = array())
    {
        // validation for constraint: array
        if ('' !== ($passwordHintArrayErrorMessage = self::validatePasswordHintForArrayConstraintsFromSetPasswordHint($passwordHint))) {
            throw new \InvalidArgumentException($passwordHintArrayErrorMessage, __LINE__);
        }
        $this->PasswordHint = $passwordHint;
        return $this;
    }
    /**
     * Add item to PasswordHint value
     * @throws \InvalidArgumentException
     * @param \StructType\PasswordHint $item
     * @return \StructType\SecurityInfo
     */
    public function addToPasswordHint(\StructType\PasswordHint $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\PasswordHint) {
            throw new \InvalidArgumentException(sprintf('The PasswordHint property can only contain items of type \StructType\PasswordHint, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->PasswordHint[] = $item;
        return $this;
    }
    /**
     * Get Username value
     * @return string|null
     */
    public function getUsername()
    {
        return $this->Username;
    }
    /**
     * Set Username value
     * @param string $username
     * @return \StructType\SecurityInfo
     */
    public function setUsername($username = null)
    {
        // validation for constraint: string
        if (!is_null($username) && !is_string($username)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($username, true), gettype($username)), __LINE__);
        }
        $this->Username = $username;
        return $this;
    }
    /**
     * Get Password value
     * @return string|null
     */
    public function getPassword()
    {
        return $this->Password;
    }
    /**
     * Set Password value
     * @param string $password
     * @return \StructType\SecurityInfo
     */
    public function setPassword($password = null)
    {
        // validation for constraint: string
        if (!is_null($password) && !is_string($password)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($password, true), gettype($password)), __LINE__);
        }
        $this->Password = $password;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SecurityInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
