<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RatePlan StructType
 * @subpackage Structs
 */
class RatePlan extends RateUploadType
{
    /**
     * The InvBlockCode
     * @var string
     */
    public $InvBlockCode;
    /**
     * The MarketCode
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\MarketCode[]
     */
    public $MarketCode;
    /**
     * The Commission
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\CommissionType
     */
    public $Commission;
    /**
     * The MethodInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\MethodInfo[]
     */
    public $MethodInfo;
    /**
     * The DaysOfWeeks
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfDOW_RulesType
     */
    public $DaysOfWeeks;
    /**
     * The RatePlanCode
     * @var string
     */
    public $RatePlanCode;
    /**
     * The BookingCode
     * @var string
     */
    public $BookingCode;
    /**
     * The PromotionCode
     * @var string
     */
    public $PromotionCode;
    /**
     * The PromotionVendorCode
     * @var string[]
     */
    public $PromotionVendorCode;
    /**
     * The UpgradeIndicator
     * @var bool
     */
    public $UpgradeIndicator;
    /**
     * The DateRange
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\DateRange
     */
    public $DateRange;
    /**
     * The DestinationSystemsCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfDestinationSystemCodesTypeDestinationSystemCode
     */
    public $DestinationSystemsCode;
    /**
     * The RatePlanCandidates
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfRatePlanCandidatesTypeRatePlanCandidate
     */
    public $RatePlanCandidates;
    /**
     * The Offers
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Offers
     */
    public $Offers;
    /**
     * The HotelRef
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\HotelRef
     */
    public $HotelRef;
    /**
     * The TPA_Extensions
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\TPA_ExtensionsType
     */
    public $TPA_Extensions;
    /**
     * Constructor method for RatePlan
     * @uses RatePlan::setInvBlockCode()
     * @uses RatePlan::setMarketCode()
     * @uses RatePlan::setCommission()
     * @uses RatePlan::setMethodInfo()
     * @uses RatePlan::setDaysOfWeeks()
     * @uses RatePlan::setRatePlanCode()
     * @uses RatePlan::setBookingCode()
     * @uses RatePlan::setPromotionCode()
     * @uses RatePlan::setPromotionVendorCode()
     * @uses RatePlan::setUpgradeIndicator()
     * @uses RatePlan::setDateRange()
     * @uses RatePlan::setDestinationSystemsCode()
     * @uses RatePlan::setRatePlanCandidates()
     * @uses RatePlan::setOffers()
     * @uses RatePlan::setHotelRef()
     * @uses RatePlan::setTPA_Extensions()
     * @param string $invBlockCode
     * @param \StructType\MarketCode[] $marketCode
     * @param \StructType\CommissionType $commission
     * @param \StructType\MethodInfo[] $methodInfo
     * @param \ArrayType\ArrayOfDOW_RulesType $daysOfWeeks
     * @param string $ratePlanCode
     * @param string $bookingCode
     * @param string $promotionCode
     * @param string[] $promotionVendorCode
     * @param bool $upgradeIndicator
     * @param \StructType\DateRange $dateRange
     * @param \ArrayType\ArrayOfDestinationSystemCodesTypeDestinationSystemCode $destinationSystemsCode
     * @param \ArrayType\ArrayOfRatePlanCandidatesTypeRatePlanCandidate $ratePlanCandidates
     * @param \StructType\Offers $offers
     * @param \StructType\HotelRef $hotelRef
     * @param \StructType\TPA_ExtensionsType $tPA_Extensions
     */
    public function __construct($invBlockCode = null, array $marketCode = array(), \StructType\CommissionType $commission = null, array $methodInfo = array(), \ArrayType\ArrayOfDOW_RulesType $daysOfWeeks = null, $ratePlanCode = null, $bookingCode = null, $promotionCode = null, array $promotionVendorCode = array(), $upgradeIndicator = null, \StructType\DateRange $dateRange = null, \ArrayType\ArrayOfDestinationSystemCodesTypeDestinationSystemCode $destinationSystemsCode = null, \ArrayType\ArrayOfRatePlanCandidatesTypeRatePlanCandidate $ratePlanCandidates = null, \StructType\Offers $offers = null, \StructType\HotelRef $hotelRef = null, \StructType\TPA_ExtensionsType $tPA_Extensions = null)
    {
        $this
            ->setInvBlockCode($invBlockCode)
            ->setMarketCode($marketCode)
            ->setCommission($commission)
            ->setMethodInfo($methodInfo)
            ->setDaysOfWeeks($daysOfWeeks)
            ->setRatePlanCode($ratePlanCode)
            ->setBookingCode($bookingCode)
            ->setPromotionCode($promotionCode)
            ->setPromotionVendorCode($promotionVendorCode)
            ->setUpgradeIndicator($upgradeIndicator)
            ->setDateRange($dateRange)
            ->setDestinationSystemsCode($destinationSystemsCode)
            ->setRatePlanCandidates($ratePlanCandidates)
            ->setOffers($offers)
            ->setHotelRef($hotelRef)
            ->setTPA_Extensions($tPA_Extensions);
    }
    /**
     * Get InvBlockCode value
     * @return string|null
     */
    public function getInvBlockCode()
    {
        return $this->InvBlockCode;
    }
    /**
     * Set InvBlockCode value
     * @param string $invBlockCode
     * @return \StructType\RatePlan
     */
    public function setInvBlockCode($invBlockCode = null)
    {
        // validation for constraint: string
        if (!is_null($invBlockCode) && !is_string($invBlockCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($invBlockCode, true), gettype($invBlockCode)), __LINE__);
        }
        $this->InvBlockCode = $invBlockCode;
        return $this;
    }
    /**
     * Get MarketCode value
     * @return \StructType\MarketCode[]|null
     */
    public function getMarketCode()
    {
        return $this->MarketCode;
    }
    /**
     * This method is responsible for validating the values passed to the setMarketCode method
     * This method is willingly generated in order to preserve the one-line inline validation within the setMarketCode method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateMarketCodeForArrayConstraintsFromSetMarketCode(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $ratePlanMarketCodeItem) {
            // validation for constraint: itemType
            if (!$ratePlanMarketCodeItem instanceof \StructType\MarketCode) {
                $invalidValues[] = is_object($ratePlanMarketCodeItem) ? get_class($ratePlanMarketCodeItem) : sprintf('%s(%s)', gettype($ratePlanMarketCodeItem), var_export($ratePlanMarketCodeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The MarketCode property can only contain items of type \StructType\MarketCode, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set MarketCode value
     * @throws \InvalidArgumentException
     * @param \StructType\MarketCode[] $marketCode
     * @return \StructType\RatePlan
     */
    public function setMarketCode(array $marketCode = array())
    {
        // validation for constraint: array
        if ('' !== ($marketCodeArrayErrorMessage = self::validateMarketCodeForArrayConstraintsFromSetMarketCode($marketCode))) {
            throw new \InvalidArgumentException($marketCodeArrayErrorMessage, __LINE__);
        }
        $this->MarketCode = $marketCode;
        return $this;
    }
    /**
     * Add item to MarketCode value
     * @throws \InvalidArgumentException
     * @param \StructType\MarketCode $item
     * @return \StructType\RatePlan
     */
    public function addToMarketCode(\StructType\MarketCode $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\MarketCode) {
            throw new \InvalidArgumentException(sprintf('The MarketCode property can only contain items of type \StructType\MarketCode, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->MarketCode[] = $item;
        return $this;
    }
    /**
     * Get Commission value
     * @return \StructType\CommissionType|null
     */
    public function getCommission()
    {
        return $this->Commission;
    }
    /**
     * Set Commission value
     * @param \StructType\CommissionType $commission
     * @return \StructType\RatePlan
     */
    public function setCommission(\StructType\CommissionType $commission = null)
    {
        $this->Commission = $commission;
        return $this;
    }
    /**
     * Get MethodInfo value
     * @return \StructType\MethodInfo[]|null
     */
    public function getMethodInfo()
    {
        return $this->MethodInfo;
    }
    /**
     * This method is responsible for validating the values passed to the setMethodInfo method
     * This method is willingly generated in order to preserve the one-line inline validation within the setMethodInfo method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateMethodInfoForArrayConstraintsFromSetMethodInfo(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $ratePlanMethodInfoItem) {
            // validation for constraint: itemType
            if (!$ratePlanMethodInfoItem instanceof \StructType\MethodInfo) {
                $invalidValues[] = is_object($ratePlanMethodInfoItem) ? get_class($ratePlanMethodInfoItem) : sprintf('%s(%s)', gettype($ratePlanMethodInfoItem), var_export($ratePlanMethodInfoItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The MethodInfo property can only contain items of type \StructType\MethodInfo, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set MethodInfo value
     * @throws \InvalidArgumentException
     * @param \StructType\MethodInfo[] $methodInfo
     * @return \StructType\RatePlan
     */
    public function setMethodInfo(array $methodInfo = array())
    {
        // validation for constraint: array
        if ('' !== ($methodInfoArrayErrorMessage = self::validateMethodInfoForArrayConstraintsFromSetMethodInfo($methodInfo))) {
            throw new \InvalidArgumentException($methodInfoArrayErrorMessage, __LINE__);
        }
        $this->MethodInfo = $methodInfo;
        return $this;
    }
    /**
     * Add item to MethodInfo value
     * @throws \InvalidArgumentException
     * @param \StructType\MethodInfo $item
     * @return \StructType\RatePlan
     */
    public function addToMethodInfo(\StructType\MethodInfo $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\MethodInfo) {
            throw new \InvalidArgumentException(sprintf('The MethodInfo property can only contain items of type \StructType\MethodInfo, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->MethodInfo[] = $item;
        return $this;
    }
    /**
     * Get DaysOfWeeks value
     * @return \ArrayType\ArrayOfDOW_RulesType|null
     */
    public function getDaysOfWeeks()
    {
        return $this->DaysOfWeeks;
    }
    /**
     * Set DaysOfWeeks value
     * @param \ArrayType\ArrayOfDOW_RulesType $daysOfWeeks
     * @return \StructType\RatePlan
     */
    public function setDaysOfWeeks(\ArrayType\ArrayOfDOW_RulesType $daysOfWeeks = null)
    {
        $this->DaysOfWeeks = $daysOfWeeks;
        return $this;
    }
    /**
     * Get RatePlanCode value
     * @return string|null
     */
    public function getRatePlanCode()
    {
        return $this->RatePlanCode;
    }
    /**
     * Set RatePlanCode value
     * @param string $ratePlanCode
     * @return \StructType\RatePlan
     */
    public function setRatePlanCode($ratePlanCode = null)
    {
        // validation for constraint: string
        if (!is_null($ratePlanCode) && !is_string($ratePlanCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ratePlanCode, true), gettype($ratePlanCode)), __LINE__);
        }
        $this->RatePlanCode = $ratePlanCode;
        return $this;
    }
    /**
     * Get BookingCode value
     * @return string|null
     */
    public function getBookingCode()
    {
        return $this->BookingCode;
    }
    /**
     * Set BookingCode value
     * @param string $bookingCode
     * @return \StructType\RatePlan
     */
    public function setBookingCode($bookingCode = null)
    {
        // validation for constraint: string
        if (!is_null($bookingCode) && !is_string($bookingCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bookingCode, true), gettype($bookingCode)), __LINE__);
        }
        $this->BookingCode = $bookingCode;
        return $this;
    }
    /**
     * Get PromotionCode value
     * @return string|null
     */
    public function getPromotionCode()
    {
        return $this->PromotionCode;
    }
    /**
     * Set PromotionCode value
     * @param string $promotionCode
     * @return \StructType\RatePlan
     */
    public function setPromotionCode($promotionCode = null)
    {
        // validation for constraint: string
        if (!is_null($promotionCode) && !is_string($promotionCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($promotionCode, true), gettype($promotionCode)), __LINE__);
        }
        $this->PromotionCode = $promotionCode;
        return $this;
    }
    /**
     * Get PromotionVendorCode value
     * @return string[]|null
     */
    public function getPromotionVendorCode()
    {
        return $this->PromotionVendorCode;
    }
    /**
     * This method is responsible for validating the values passed to the setPromotionVendorCode method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPromotionVendorCode method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePromotionVendorCodeForArrayConstraintsFromSetPromotionVendorCode(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $ratePlanPromotionVendorCodeItem) {
            // validation for constraint: itemType
            if (!is_string($ratePlanPromotionVendorCodeItem)) {
                $invalidValues[] = is_object($ratePlanPromotionVendorCodeItem) ? get_class($ratePlanPromotionVendorCodeItem) : sprintf('%s(%s)', gettype($ratePlanPromotionVendorCodeItem), var_export($ratePlanPromotionVendorCodeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The PromotionVendorCode property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set PromotionVendorCode value
     * @throws \InvalidArgumentException
     * @param string[] $promotionVendorCode
     * @return \StructType\RatePlan
     */
    public function setPromotionVendorCode(array $promotionVendorCode = array())
    {
        // validation for constraint: array
        if ('' !== ($promotionVendorCodeArrayErrorMessage = self::validatePromotionVendorCodeForArrayConstraintsFromSetPromotionVendorCode($promotionVendorCode))) {
            throw new \InvalidArgumentException($promotionVendorCodeArrayErrorMessage, __LINE__);
        }
        $this->PromotionVendorCode = $promotionVendorCode;
        return $this;
    }
    /**
     * Add item to PromotionVendorCode value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\RatePlan
     */
    public function addToPromotionVendorCode($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The PromotionVendorCode property can only contain items of type string, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->PromotionVendorCode[] = $item;
        return $this;
    }
    /**
     * Get UpgradeIndicator value
     * @return bool|null
     */
    public function getUpgradeIndicator()
    {
        return $this->UpgradeIndicator;
    }
    /**
     * Set UpgradeIndicator value
     * @param bool $upgradeIndicator
     * @return \StructType\RatePlan
     */
    public function setUpgradeIndicator($upgradeIndicator = null)
    {
        // validation for constraint: boolean
        if (!is_null($upgradeIndicator) && !is_bool($upgradeIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($upgradeIndicator, true), gettype($upgradeIndicator)), __LINE__);
        }
        $this->UpgradeIndicator = $upgradeIndicator;
        return $this;
    }
    /**
     * Get DateRange value
     * @return \StructType\DateRange|null
     */
    public function getDateRange()
    {
        return $this->DateRange;
    }
    /**
     * Set DateRange value
     * @param \StructType\DateRange $dateRange
     * @return \StructType\RatePlan
     */
    public function setDateRange(\StructType\DateRange $dateRange = null)
    {
        $this->DateRange = $dateRange;
        return $this;
    }
    /**
     * Get DestinationSystemsCode value
     * @return \ArrayType\ArrayOfDestinationSystemCodesTypeDestinationSystemCode|null
     */
    public function getDestinationSystemsCode()
    {
        return $this->DestinationSystemsCode;
    }
    /**
     * Set DestinationSystemsCode value
     * @param \ArrayType\ArrayOfDestinationSystemCodesTypeDestinationSystemCode $destinationSystemsCode
     * @return \StructType\RatePlan
     */
    public function setDestinationSystemsCode(\ArrayType\ArrayOfDestinationSystemCodesTypeDestinationSystemCode $destinationSystemsCode = null)
    {
        $this->DestinationSystemsCode = $destinationSystemsCode;
        return $this;
    }
    /**
     * Get RatePlanCandidates value
     * @return \ArrayType\ArrayOfRatePlanCandidatesTypeRatePlanCandidate|null
     */
    public function getRatePlanCandidates()
    {
        return $this->RatePlanCandidates;
    }
    /**
     * Set RatePlanCandidates value
     * @param \ArrayType\ArrayOfRatePlanCandidatesTypeRatePlanCandidate $ratePlanCandidates
     * @return \StructType\RatePlan
     */
    public function setRatePlanCandidates(\ArrayType\ArrayOfRatePlanCandidatesTypeRatePlanCandidate $ratePlanCandidates = null)
    {
        $this->RatePlanCandidates = $ratePlanCandidates;
        return $this;
    }
    /**
     * Get Offers value
     * @return \StructType\Offers|null
     */
    public function getOffers()
    {
        return $this->Offers;
    }
    /**
     * Set Offers value
     * @param \StructType\Offers $offers
     * @return \StructType\RatePlan
     */
    public function setOffers(\StructType\Offers $offers = null)
    {
        $this->Offers = $offers;
        return $this;
    }
    /**
     * Get HotelRef value
     * @return \StructType\HotelRef|null
     */
    public function getHotelRef()
    {
        return $this->HotelRef;
    }
    /**
     * Set HotelRef value
     * @param \StructType\HotelRef $hotelRef
     * @return \StructType\RatePlan
     */
    public function setHotelRef(\StructType\HotelRef $hotelRef = null)
    {
        $this->HotelRef = $hotelRef;
        return $this;
    }
    /**
     * Get TPA_Extensions value
     * @return \StructType\TPA_ExtensionsType|null
     */
    public function getTPA_Extensions()
    {
        return $this->TPA_Extensions;
    }
    /**
     * Set TPA_Extensions value
     * @param \StructType\TPA_ExtensionsType $tPA_Extensions
     * @return \StructType\RatePlan
     */
    public function setTPA_Extensions(\StructType\TPA_ExtensionsType $tPA_Extensions = null)
    {
        $this->TPA_Extensions = $tPA_Extensions;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\RatePlan
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
