<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ProfileType StructType
 * @subpackage Structs
 */
class ProfileType extends AbstractStructBase
{
    /**
     * The Customer
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\CustomerType
     */
    public $Customer;
    /**
     * The UserID
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\UserID[]
     */
    public $UserID;
    /**
     * The CompanyInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\CompanyInfoType
     */
    public $CompanyInfo;
    /**
     * The ProfileType
     * @var string
     */
    public $ProfileType;
    /**
     * The RPH
     * @var string
     */
    public $RPH;
    /**
     * The ShareMarketInd
     * @var string
     */
    public $ShareMarketInd;
    /**
     * Constructor method for ProfileType
     * @uses ProfileType::setCustomer()
     * @uses ProfileType::setUserID()
     * @uses ProfileType::setCompanyInfo()
     * @uses ProfileType::setProfileType()
     * @uses ProfileType::setRPH()
     * @uses ProfileType::setShareMarketInd()
     * @param \StructType\CustomerType $customer
     * @param \StructType\UserID[] $userID
     * @param \StructType\CompanyInfoType $companyInfo
     * @param string $profileType
     * @param string $rPH
     * @param string $shareMarketInd
     */
    public function __construct(\StructType\CustomerType $customer = null, array $userID = array(), \StructType\CompanyInfoType $companyInfo = null, $profileType = null, $rPH = null, $shareMarketInd = null)
    {
        $this
            ->setCustomer($customer)
            ->setUserID($userID)
            ->setCompanyInfo($companyInfo)
            ->setProfileType($profileType)
            ->setRPH($rPH)
            ->setShareMarketInd($shareMarketInd);
    }
    /**
     * Get Customer value
     * @return \StructType\CustomerType|null
     */
    public function getCustomer()
    {
        return $this->Customer;
    }
    /**
     * Set Customer value
     * @param \StructType\CustomerType $customer
     * @return \StructType\ProfileType
     */
    public function setCustomer(\StructType\CustomerType $customer = null)
    {
        $this->Customer = $customer;
        return $this;
    }
    /**
     * Get UserID value
     * @return \StructType\UserID[]|null
     */
    public function getUserID()
    {
        return $this->UserID;
    }
    /**
     * This method is responsible for validating the values passed to the setUserID method
     * This method is willingly generated in order to preserve the one-line inline validation within the setUserID method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateUserIDForArrayConstraintsFromSetUserID(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $profileTypeUserIDItem) {
            // validation for constraint: itemType
            if (!$profileTypeUserIDItem instanceof \StructType\UserID) {
                $invalidValues[] = is_object($profileTypeUserIDItem) ? get_class($profileTypeUserIDItem) : sprintf('%s(%s)', gettype($profileTypeUserIDItem), var_export($profileTypeUserIDItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The UserID property can only contain items of type \StructType\UserID, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set UserID value
     * @throws \InvalidArgumentException
     * @param \StructType\UserID[] $userID
     * @return \StructType\ProfileType
     */
    public function setUserID(array $userID = array())
    {
        // validation for constraint: array
        if ('' !== ($userIDArrayErrorMessage = self::validateUserIDForArrayConstraintsFromSetUserID($userID))) {
            throw new \InvalidArgumentException($userIDArrayErrorMessage, __LINE__);
        }
        $this->UserID = $userID;
        return $this;
    }
    /**
     * Add item to UserID value
     * @throws \InvalidArgumentException
     * @param \StructType\UserID $item
     * @return \StructType\ProfileType
     */
    public function addToUserID(\StructType\UserID $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\UserID) {
            throw new \InvalidArgumentException(sprintf('The UserID property can only contain items of type \StructType\UserID, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->UserID[] = $item;
        return $this;
    }
    /**
     * Get CompanyInfo value
     * @return \StructType\CompanyInfoType|null
     */
    public function getCompanyInfo()
    {
        return $this->CompanyInfo;
    }
    /**
     * Set CompanyInfo value
     * @param \StructType\CompanyInfoType $companyInfo
     * @return \StructType\ProfileType
     */
    public function setCompanyInfo(\StructType\CompanyInfoType $companyInfo = null)
    {
        $this->CompanyInfo = $companyInfo;
        return $this;
    }
    /**
     * Get ProfileType value
     * @return string|null
     */
    public function getProfileType()
    {
        return $this->ProfileType;
    }
    /**
     * Set ProfileType value
     * @param string $profileType
     * @return \StructType\ProfileType
     */
    public function setProfileType($profileType = null)
    {
        // validation for constraint: string
        if (!is_null($profileType) && !is_string($profileType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($profileType, true), gettype($profileType)), __LINE__);
        }
        $this->ProfileType = $profileType;
        return $this;
    }
    /**
     * Get RPH value
     * @return string|null
     */
    public function getRPH()
    {
        return $this->RPH;
    }
    /**
     * Set RPH value
     * @param string $rPH
     * @return \StructType\ProfileType
     */
    public function setRPH($rPH = null)
    {
        // validation for constraint: string
        if (!is_null($rPH) && !is_string($rPH)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rPH, true), gettype($rPH)), __LINE__);
        }
        $this->RPH = $rPH;
        return $this;
    }
    /**
     * Get ShareMarketInd value
     * @return string|null
     */
    public function getShareMarketInd()
    {
        return $this->ShareMarketInd;
    }
    /**
     * Set ShareMarketInd value
     * @param string $shareMarketInd
     * @return \StructType\ProfileType
     */
    public function setShareMarketInd($shareMarketInd = null)
    {
        // validation for constraint: string
        if (!is_null($shareMarketInd) && !is_string($shareMarketInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shareMarketInd, true), gettype($shareMarketInd)), __LINE__);
        }
        $this->ShareMarketInd = $shareMarketInd;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ProfileType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
