<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PaymentCardType StructType
 * @subpackage Structs
 */
class PaymentCardType extends AbstractStructBase
{
    /**
     * The CardType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\List_PaymentCardIssuer
     */
    public $CardType;
    /**
     * The Issuer
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Issuer
     */
    public $Issuer;
    /**
     * The CardHolderName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CardHolderName;
    /**
     * The Address
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\AddressType
     */
    public $Address;
    /**
     * The Telephone
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Telephone[]
     */
    public $Telephone;
    /**
     * The Email
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\EmailType[]
     */
    public $Email;
    /**
     * The CardNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\EncryptionTokenType
     */
    public $CardNumber;
    /**
     * The SeriesCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\EncryptionTokenType
     */
    public $SeriesCode;
    /**
     * The CustLoyalty
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\CustLoyalty[]
     */
    public $CustLoyalty;
    /**
     * The MagneticStripe
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\EncryptionTokenType[]
     */
    public $MagneticStripe;
    /**
     * The ThreeDomainSecurity
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ThreeDomainSecurity
     */
    public $ThreeDomainSecurity;
    /**
     * The SignatureOnFile
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\SignatureOnFile
     */
    public $SignatureOnFile;
    /**
     * The ExtendedPaymentInd
     * @var bool
     */
    public $ExtendedPaymentInd;
    /**
     * The SecureInd
     * @var bool
     */
    public $SecureInd;
    /**
     * The SignatureOnFileInd
     * @var bool
     */
    public $SignatureOnFileInd;
    /**
     * The ShareSynchInd
     * @var string
     */
    public $ShareSynchInd;
    /**
     * The ShareMarketInd
     * @var string
     */
    public $ShareMarketInd;
    /**
     * The CardCode
     * @var string
     */
    public $CardCode;
    /**
     * The CardHolderRPH
     * @var string
     */
    public $CardHolderRPH;
    /**
     * The CompanyCardReference
     * @var string
     */
    public $CompanyCardReference;
    /**
     * The CountryOfIssue
     * @var string
     */
    public $CountryOfIssue;
    /**
     * The EffectiveDate
     * @var string
     */
    public $EffectiveDate;
    /**
     * The ExpireDate
     * @var string
     */
    public $ExpireDate;
    /**
     * The Remark
     * @var string
     */
    public $Remark;
    /**
     * The RPH
     * @var string
     */
    public $RPH;
    /**
     * Constructor method for PaymentCardType
     * @uses PaymentCardType::setCardType()
     * @uses PaymentCardType::setIssuer()
     * @uses PaymentCardType::setCardHolderName()
     * @uses PaymentCardType::setAddress()
     * @uses PaymentCardType::setTelephone()
     * @uses PaymentCardType::setEmail()
     * @uses PaymentCardType::setCardNumber()
     * @uses PaymentCardType::setSeriesCode()
     * @uses PaymentCardType::setCustLoyalty()
     * @uses PaymentCardType::setMagneticStripe()
     * @uses PaymentCardType::setThreeDomainSecurity()
     * @uses PaymentCardType::setSignatureOnFile()
     * @uses PaymentCardType::setExtendedPaymentInd()
     * @uses PaymentCardType::setSecureInd()
     * @uses PaymentCardType::setSignatureOnFileInd()
     * @uses PaymentCardType::setShareSynchInd()
     * @uses PaymentCardType::setShareMarketInd()
     * @uses PaymentCardType::setCardCode()
     * @uses PaymentCardType::setCardHolderRPH()
     * @uses PaymentCardType::setCompanyCardReference()
     * @uses PaymentCardType::setCountryOfIssue()
     * @uses PaymentCardType::setEffectiveDate()
     * @uses PaymentCardType::setExpireDate()
     * @uses PaymentCardType::setRemark()
     * @uses PaymentCardType::setRPH()
     * @param \StructType\List_PaymentCardIssuer $cardType
     * @param \StructType\Issuer $issuer
     * @param string $cardHolderName
     * @param \StructType\AddressType $address
     * @param \StructType\Telephone[] $telephone
     * @param \StructType\EmailType[] $email
     * @param \StructType\EncryptionTokenType $cardNumber
     * @param \StructType\EncryptionTokenType $seriesCode
     * @param \StructType\CustLoyalty[] $custLoyalty
     * @param \StructType\EncryptionTokenType[] $magneticStripe
     * @param \StructType\ThreeDomainSecurity $threeDomainSecurity
     * @param \StructType\SignatureOnFile $signatureOnFile
     * @param bool $extendedPaymentInd
     * @param bool $secureInd
     * @param bool $signatureOnFileInd
     * @param string $shareSynchInd
     * @param string $shareMarketInd
     * @param string $cardCode
     * @param string $cardHolderRPH
     * @param string $companyCardReference
     * @param string $countryOfIssue
     * @param string $effectiveDate
     * @param string $expireDate
     * @param string $remark
     * @param string $rPH
     */
    public function __construct(\StructType\List_PaymentCardIssuer $cardType = null, \StructType\Issuer $issuer = null, $cardHolderName = null, \StructType\AddressType $address = null, array $telephone = array(), array $email = array(), \StructType\EncryptionTokenType $cardNumber = null, \StructType\EncryptionTokenType $seriesCode = null, array $custLoyalty = array(), array $magneticStripe = array(), \StructType\ThreeDomainSecurity $threeDomainSecurity = null, \StructType\SignatureOnFile $signatureOnFile = null, $extendedPaymentInd = null, $secureInd = null, $signatureOnFileInd = null, $shareSynchInd = null, $shareMarketInd = null, $cardCode = null, $cardHolderRPH = null, $companyCardReference = null, $countryOfIssue = null, $effectiveDate = null, $expireDate = null, $remark = null, $rPH = null)
    {
        $this
            ->setCardType($cardType)
            ->setIssuer($issuer)
            ->setCardHolderName($cardHolderName)
            ->setAddress($address)
            ->setTelephone($telephone)
            ->setEmail($email)
            ->setCardNumber($cardNumber)
            ->setSeriesCode($seriesCode)
            ->setCustLoyalty($custLoyalty)
            ->setMagneticStripe($magneticStripe)
            ->setThreeDomainSecurity($threeDomainSecurity)
            ->setSignatureOnFile($signatureOnFile)
            ->setExtendedPaymentInd($extendedPaymentInd)
            ->setSecureInd($secureInd)
            ->setSignatureOnFileInd($signatureOnFileInd)
            ->setShareSynchInd($shareSynchInd)
            ->setShareMarketInd($shareMarketInd)
            ->setCardCode($cardCode)
            ->setCardHolderRPH($cardHolderRPH)
            ->setCompanyCardReference($companyCardReference)
            ->setCountryOfIssue($countryOfIssue)
            ->setEffectiveDate($effectiveDate)
            ->setExpireDate($expireDate)
            ->setRemark($remark)
            ->setRPH($rPH);
    }
    /**
     * Get CardType value
     * @return \StructType\List_PaymentCardIssuer|null
     */
    public function getCardType()
    {
        return $this->CardType;
    }
    /**
     * Set CardType value
     * @param \StructType\List_PaymentCardIssuer $cardType
     * @return \StructType\PaymentCardType
     */
    public function setCardType(\StructType\List_PaymentCardIssuer $cardType = null)
    {
        $this->CardType = $cardType;
        return $this;
    }
    /**
     * Get Issuer value
     * @return \StructType\Issuer|null
     */
    public function getIssuer()
    {
        return $this->Issuer;
    }
    /**
     * Set Issuer value
     * @param \StructType\Issuer $issuer
     * @return \StructType\PaymentCardType
     */
    public function setIssuer(\StructType\Issuer $issuer = null)
    {
        $this->Issuer = $issuer;
        return $this;
    }
    /**
     * Get CardHolderName value
     * @return string|null
     */
    public function getCardHolderName()
    {
        return $this->CardHolderName;
    }
    /**
     * Set CardHolderName value
     * @param string $cardHolderName
     * @return \StructType\PaymentCardType
     */
    public function setCardHolderName($cardHolderName = null)
    {
        // validation for constraint: string
        if (!is_null($cardHolderName) && !is_string($cardHolderName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cardHolderName, true), gettype($cardHolderName)), __LINE__);
        }
        $this->CardHolderName = $cardHolderName;
        return $this;
    }
    /**
     * Get Address value
     * @return \StructType\AddressType|null
     */
    public function getAddress()
    {
        return $this->Address;
    }
    /**
     * Set Address value
     * @param \StructType\AddressType $address
     * @return \StructType\PaymentCardType
     */
    public function setAddress(\StructType\AddressType $address = null)
    {
        $this->Address = $address;
        return $this;
    }
    /**
     * Get Telephone value
     * @return \StructType\Telephone[]|null
     */
    public function getTelephone()
    {
        return $this->Telephone;
    }
    /**
     * This method is responsible for validating the values passed to the setTelephone method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTelephone method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTelephoneForArrayConstraintsFromSetTelephone(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $paymentCardTypeTelephoneItem) {
            // validation for constraint: itemType
            if (!$paymentCardTypeTelephoneItem instanceof \StructType\Telephone) {
                $invalidValues[] = is_object($paymentCardTypeTelephoneItem) ? get_class($paymentCardTypeTelephoneItem) : sprintf('%s(%s)', gettype($paymentCardTypeTelephoneItem), var_export($paymentCardTypeTelephoneItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Telephone property can only contain items of type \StructType\Telephone, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Telephone value
     * @throws \InvalidArgumentException
     * @param \StructType\Telephone[] $telephone
     * @return \StructType\PaymentCardType
     */
    public function setTelephone(array $telephone = array())
    {
        // validation for constraint: array
        if ('' !== ($telephoneArrayErrorMessage = self::validateTelephoneForArrayConstraintsFromSetTelephone($telephone))) {
            throw new \InvalidArgumentException($telephoneArrayErrorMessage, __LINE__);
        }
        $this->Telephone = $telephone;
        return $this;
    }
    /**
     * Add item to Telephone value
     * @throws \InvalidArgumentException
     * @param \StructType\Telephone $item
     * @return \StructType\PaymentCardType
     */
    public function addToTelephone(\StructType\Telephone $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Telephone) {
            throw new \InvalidArgumentException(sprintf('The Telephone property can only contain items of type \StructType\Telephone, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Telephone[] = $item;
        return $this;
    }
    /**
     * Get Email value
     * @return \StructType\EmailType[]|null
     */
    public function getEmail()
    {
        return $this->Email;
    }
    /**
     * This method is responsible for validating the values passed to the setEmail method
     * This method is willingly generated in order to preserve the one-line inline validation within the setEmail method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateEmailForArrayConstraintsFromSetEmail(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $paymentCardTypeEmailItem) {
            // validation for constraint: itemType
            if (!$paymentCardTypeEmailItem instanceof \StructType\EmailType) {
                $invalidValues[] = is_object($paymentCardTypeEmailItem) ? get_class($paymentCardTypeEmailItem) : sprintf('%s(%s)', gettype($paymentCardTypeEmailItem), var_export($paymentCardTypeEmailItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Email property can only contain items of type \StructType\EmailType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Email value
     * @throws \InvalidArgumentException
     * @param \StructType\EmailType[] $email
     * @return \StructType\PaymentCardType
     */
    public function setEmail(array $email = array())
    {
        // validation for constraint: array
        if ('' !== ($emailArrayErrorMessage = self::validateEmailForArrayConstraintsFromSetEmail($email))) {
            throw new \InvalidArgumentException($emailArrayErrorMessage, __LINE__);
        }
        $this->Email = $email;
        return $this;
    }
    /**
     * Add item to Email value
     * @throws \InvalidArgumentException
     * @param \StructType\EmailType $item
     * @return \StructType\PaymentCardType
     */
    public function addToEmail(\StructType\EmailType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\EmailType) {
            throw new \InvalidArgumentException(sprintf('The Email property can only contain items of type \StructType\EmailType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Email[] = $item;
        return $this;
    }
    /**
     * Get CardNumber value
     * @return \StructType\EncryptionTokenType|null
     */
    public function getCardNumber()
    {
        return $this->CardNumber;
    }
    /**
     * Set CardNumber value
     * @param \StructType\EncryptionTokenType $cardNumber
     * @return \StructType\PaymentCardType
     */
    public function setCardNumber(\StructType\EncryptionTokenType $cardNumber = null)
    {
        $this->CardNumber = $cardNumber;
        return $this;
    }
    /**
     * Get SeriesCode value
     * @return \StructType\EncryptionTokenType|null
     */
    public function getSeriesCode()
    {
        return $this->SeriesCode;
    }
    /**
     * Set SeriesCode value
     * @param \StructType\EncryptionTokenType $seriesCode
     * @return \StructType\PaymentCardType
     */
    public function setSeriesCode(\StructType\EncryptionTokenType $seriesCode = null)
    {
        $this->SeriesCode = $seriesCode;
        return $this;
    }
    /**
     * Get CustLoyalty value
     * @return \StructType\CustLoyalty[]|null
     */
    public function getCustLoyalty()
    {
        return $this->CustLoyalty;
    }
    /**
     * This method is responsible for validating the values passed to the setCustLoyalty method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCustLoyalty method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCustLoyaltyForArrayConstraintsFromSetCustLoyalty(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $paymentCardTypeCustLoyaltyItem) {
            // validation for constraint: itemType
            if (!$paymentCardTypeCustLoyaltyItem instanceof \StructType\CustLoyalty) {
                $invalidValues[] = is_object($paymentCardTypeCustLoyaltyItem) ? get_class($paymentCardTypeCustLoyaltyItem) : sprintf('%s(%s)', gettype($paymentCardTypeCustLoyaltyItem), var_export($paymentCardTypeCustLoyaltyItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The CustLoyalty property can only contain items of type \StructType\CustLoyalty, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set CustLoyalty value
     * @throws \InvalidArgumentException
     * @param \StructType\CustLoyalty[] $custLoyalty
     * @return \StructType\PaymentCardType
     */
    public function setCustLoyalty(array $custLoyalty = array())
    {
        // validation for constraint: array
        if ('' !== ($custLoyaltyArrayErrorMessage = self::validateCustLoyaltyForArrayConstraintsFromSetCustLoyalty($custLoyalty))) {
            throw new \InvalidArgumentException($custLoyaltyArrayErrorMessage, __LINE__);
        }
        $this->CustLoyalty = $custLoyalty;
        return $this;
    }
    /**
     * Add item to CustLoyalty value
     * @throws \InvalidArgumentException
     * @param \StructType\CustLoyalty $item
     * @return \StructType\PaymentCardType
     */
    public function addToCustLoyalty(\StructType\CustLoyalty $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CustLoyalty) {
            throw new \InvalidArgumentException(sprintf('The CustLoyalty property can only contain items of type \StructType\CustLoyalty, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->CustLoyalty[] = $item;
        return $this;
    }
    /**
     * Get MagneticStripe value
     * @return \StructType\EncryptionTokenType[]|null
     */
    public function getMagneticStripe()
    {
        return $this->MagneticStripe;
    }
    /**
     * This method is responsible for validating the values passed to the setMagneticStripe method
     * This method is willingly generated in order to preserve the one-line inline validation within the setMagneticStripe method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateMagneticStripeForArrayConstraintsFromSetMagneticStripe(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $paymentCardTypeMagneticStripeItem) {
            // validation for constraint: itemType
            if (!$paymentCardTypeMagneticStripeItem instanceof \StructType\EncryptionTokenType) {
                $invalidValues[] = is_object($paymentCardTypeMagneticStripeItem) ? get_class($paymentCardTypeMagneticStripeItem) : sprintf('%s(%s)', gettype($paymentCardTypeMagneticStripeItem), var_export($paymentCardTypeMagneticStripeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The MagneticStripe property can only contain items of type \StructType\EncryptionTokenType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set MagneticStripe value
     * @throws \InvalidArgumentException
     * @param \StructType\EncryptionTokenType[] $magneticStripe
     * @return \StructType\PaymentCardType
     */
    public function setMagneticStripe(array $magneticStripe = array())
    {
        // validation for constraint: array
        if ('' !== ($magneticStripeArrayErrorMessage = self::validateMagneticStripeForArrayConstraintsFromSetMagneticStripe($magneticStripe))) {
            throw new \InvalidArgumentException($magneticStripeArrayErrorMessage, __LINE__);
        }
        $this->MagneticStripe = $magneticStripe;
        return $this;
    }
    /**
     * Add item to MagneticStripe value
     * @throws \InvalidArgumentException
     * @param \StructType\EncryptionTokenType $item
     * @return \StructType\PaymentCardType
     */
    public function addToMagneticStripe(\StructType\EncryptionTokenType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\EncryptionTokenType) {
            throw new \InvalidArgumentException(sprintf('The MagneticStripe property can only contain items of type \StructType\EncryptionTokenType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->MagneticStripe[] = $item;
        return $this;
    }
    /**
     * Get ThreeDomainSecurity value
     * @return \StructType\ThreeDomainSecurity|null
     */
    public function getThreeDomainSecurity()
    {
        return $this->ThreeDomainSecurity;
    }
    /**
     * Set ThreeDomainSecurity value
     * @param \StructType\ThreeDomainSecurity $threeDomainSecurity
     * @return \StructType\PaymentCardType
     */
    public function setThreeDomainSecurity(\StructType\ThreeDomainSecurity $threeDomainSecurity = null)
    {
        $this->ThreeDomainSecurity = $threeDomainSecurity;
        return $this;
    }
    /**
     * Get SignatureOnFile value
     * @return \StructType\SignatureOnFile|null
     */
    public function getSignatureOnFile()
    {
        return $this->SignatureOnFile;
    }
    /**
     * Set SignatureOnFile value
     * @param \StructType\SignatureOnFile $signatureOnFile
     * @return \StructType\PaymentCardType
     */
    public function setSignatureOnFile(\StructType\SignatureOnFile $signatureOnFile = null)
    {
        $this->SignatureOnFile = $signatureOnFile;
        return $this;
    }
    /**
     * Get ExtendedPaymentInd value
     * @return bool|null
     */
    public function getExtendedPaymentInd()
    {
        return $this->ExtendedPaymentInd;
    }
    /**
     * Set ExtendedPaymentInd value
     * @param bool $extendedPaymentInd
     * @return \StructType\PaymentCardType
     */
    public function setExtendedPaymentInd($extendedPaymentInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($extendedPaymentInd) && !is_bool($extendedPaymentInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($extendedPaymentInd, true), gettype($extendedPaymentInd)), __LINE__);
        }
        $this->ExtendedPaymentInd = $extendedPaymentInd;
        return $this;
    }
    /**
     * Get SecureInd value
     * @return bool|null
     */
    public function getSecureInd()
    {
        return $this->SecureInd;
    }
    /**
     * Set SecureInd value
     * @param bool $secureInd
     * @return \StructType\PaymentCardType
     */
    public function setSecureInd($secureInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($secureInd) && !is_bool($secureInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($secureInd, true), gettype($secureInd)), __LINE__);
        }
        $this->SecureInd = $secureInd;
        return $this;
    }
    /**
     * Get SignatureOnFileInd value
     * @return bool|null
     */
    public function getSignatureOnFileInd()
    {
        return $this->SignatureOnFileInd;
    }
    /**
     * Set SignatureOnFileInd value
     * @param bool $signatureOnFileInd
     * @return \StructType\PaymentCardType
     */
    public function setSignatureOnFileInd($signatureOnFileInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($signatureOnFileInd) && !is_bool($signatureOnFileInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($signatureOnFileInd, true), gettype($signatureOnFileInd)), __LINE__);
        }
        $this->SignatureOnFileInd = $signatureOnFileInd;
        return $this;
    }
    /**
     * Get ShareSynchInd value
     * @return string|null
     */
    public function getShareSynchInd()
    {
        return $this->ShareSynchInd;
    }
    /**
     * Set ShareSynchInd value
     * @param string $shareSynchInd
     * @return \StructType\PaymentCardType
     */
    public function setShareSynchInd($shareSynchInd = null)
    {
        // validation for constraint: string
        if (!is_null($shareSynchInd) && !is_string($shareSynchInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shareSynchInd, true), gettype($shareSynchInd)), __LINE__);
        }
        $this->ShareSynchInd = $shareSynchInd;
        return $this;
    }
    /**
     * Get ShareMarketInd value
     * @return string|null
     */
    public function getShareMarketInd()
    {
        return $this->ShareMarketInd;
    }
    /**
     * Set ShareMarketInd value
     * @param string $shareMarketInd
     * @return \StructType\PaymentCardType
     */
    public function setShareMarketInd($shareMarketInd = null)
    {
        // validation for constraint: string
        if (!is_null($shareMarketInd) && !is_string($shareMarketInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shareMarketInd, true), gettype($shareMarketInd)), __LINE__);
        }
        $this->ShareMarketInd = $shareMarketInd;
        return $this;
    }
    /**
     * Get CardCode value
     * @return string|null
     */
    public function getCardCode()
    {
        return $this->CardCode;
    }
    /**
     * Set CardCode value
     * @param string $cardCode
     * @return \StructType\PaymentCardType
     */
    public function setCardCode($cardCode = null)
    {
        // validation for constraint: string
        if (!is_null($cardCode) && !is_string($cardCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cardCode, true), gettype($cardCode)), __LINE__);
        }
        $this->CardCode = $cardCode;
        return $this;
    }
    /**
     * Get CardHolderRPH value
     * @return string|null
     */
    public function getCardHolderRPH()
    {
        return $this->CardHolderRPH;
    }
    /**
     * Set CardHolderRPH value
     * @param string $cardHolderRPH
     * @return \StructType\PaymentCardType
     */
    public function setCardHolderRPH($cardHolderRPH = null)
    {
        // validation for constraint: string
        if (!is_null($cardHolderRPH) && !is_string($cardHolderRPH)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cardHolderRPH, true), gettype($cardHolderRPH)), __LINE__);
        }
        $this->CardHolderRPH = $cardHolderRPH;
        return $this;
    }
    /**
     * Get CompanyCardReference value
     * @return string|null
     */
    public function getCompanyCardReference()
    {
        return $this->CompanyCardReference;
    }
    /**
     * Set CompanyCardReference value
     * @param string $companyCardReference
     * @return \StructType\PaymentCardType
     */
    public function setCompanyCardReference($companyCardReference = null)
    {
        // validation for constraint: string
        if (!is_null($companyCardReference) && !is_string($companyCardReference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($companyCardReference, true), gettype($companyCardReference)), __LINE__);
        }
        $this->CompanyCardReference = $companyCardReference;
        return $this;
    }
    /**
     * Get CountryOfIssue value
     * @return string|null
     */
    public function getCountryOfIssue()
    {
        return $this->CountryOfIssue;
    }
    /**
     * Set CountryOfIssue value
     * @param string $countryOfIssue
     * @return \StructType\PaymentCardType
     */
    public function setCountryOfIssue($countryOfIssue = null)
    {
        // validation for constraint: string
        if (!is_null($countryOfIssue) && !is_string($countryOfIssue)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($countryOfIssue, true), gettype($countryOfIssue)), __LINE__);
        }
        $this->CountryOfIssue = $countryOfIssue;
        return $this;
    }
    /**
     * Get EffectiveDate value
     * @return string|null
     */
    public function getEffectiveDate()
    {
        return $this->EffectiveDate;
    }
    /**
     * Set EffectiveDate value
     * @param string $effectiveDate
     * @return \StructType\PaymentCardType
     */
    public function setEffectiveDate($effectiveDate = null)
    {
        // validation for constraint: string
        if (!is_null($effectiveDate) && !is_string($effectiveDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($effectiveDate, true), gettype($effectiveDate)), __LINE__);
        }
        $this->EffectiveDate = $effectiveDate;
        return $this;
    }
    /**
     * Get ExpireDate value
     * @return string|null
     */
    public function getExpireDate()
    {
        return $this->ExpireDate;
    }
    /**
     * Set ExpireDate value
     * @param string $expireDate
     * @return \StructType\PaymentCardType
     */
    public function setExpireDate($expireDate = null)
    {
        // validation for constraint: string
        if (!is_null($expireDate) && !is_string($expireDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($expireDate, true), gettype($expireDate)), __LINE__);
        }
        $this->ExpireDate = $expireDate;
        return $this;
    }
    /**
     * Get Remark value
     * @return string|null
     */
    public function getRemark()
    {
        return $this->Remark;
    }
    /**
     * Set Remark value
     * @param string $remark
     * @return \StructType\PaymentCardType
     */
    public function setRemark($remark = null)
    {
        // validation for constraint: string
        if (!is_null($remark) && !is_string($remark)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($remark, true), gettype($remark)), __LINE__);
        }
        $this->Remark = $remark;
        return $this;
    }
    /**
     * Get RPH value
     * @return string|null
     */
    public function getRPH()
    {
        return $this->RPH;
    }
    /**
     * Set RPH value
     * @param string $rPH
     * @return \StructType\PaymentCardType
     */
    public function setRPH($rPH = null)
    {
        // validation for constraint: string
        if (!is_null($rPH) && !is_string($rPH)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rPH, true), gettype($rPH)), __LINE__);
        }
        $this->RPH = $rPH;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PaymentCardType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
